#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iostream>
#include <vector>

#ifndef UI_ENVIRONMENT
#define UI_ENVIRONMENT

namespace Env {
  enum Sign { eq, ne, gt, ge, lt, le };
};

class EnvVersion {
 public:
  EnvVersion (const long long int v1 = 0, const long long int v2 = 0,
	      const long long int v3 = 0, const long long int v4 = 0);
  EnvVersion (const std::string & vers);
  ~EnvVersion () {};
  bool operator== (const EnvVersion & vers) const;
  bool operator!= (const EnvVersion & vers) const;
  bool operator>  (const EnvVersion & vers) const;
  bool operator<  (const EnvVersion & vers) const;
  bool operator>= (const EnvVersion & vers) const;
  bool operator<= (const EnvVersion & vers) const;
  bool operator! () const;
  operator bool () {return !operator!();};
 private:
  long long int version [4];

  friend std::ostream & operator<< (std::ostream & os, const EnvVersion & vers);
};

std::ostream & operator<< (std::ostream & os, const EnvVersion & vers);

class EnvVersionWithSign : public EnvVersion {
 public:
  EnvVersionWithSign (const short int v1 = 0, const short int v2 = 0,
		      const short int v3 = 0, const short int v4 = 0,
		      const Env::Sign s = Env::eq);
  EnvVersionWithSign (const std::string & vers, const Env::Sign s = Env::eq);
  EnvVersionWithSign (const EnvVersion & vers, const Env::Sign s = Env::eq);
  ~EnvVersionWithSign () {};
  Env::Sign GetSign () const;
 private:
  Env::Sign sgn;
};

class Environment {
 public:
  Environment (const std::string & env);
  ~Environment () {};
  const std::string & GetOriginal () const;
  const std::string & GetName () const;
  const EnvVersion & GetVersion () const;
 private:
  std::string original;
  std::string envname;
  EnvVersion version;

  friend std::ostream & operator<< (std::ostream & os, const Environment & env);
};

std::ostream & operator<< (std::ostream & os, const Environment & env);

class EnvironmentTest {
 public:
  EnvironmentTest (const Environment & env, const Env::Sign s);
  ~EnvironmentTest () {};
  bool AddCondition (const Environment & env, const Env::Sign s);
  bool Test (const Environment & env) const;
 private:
  std::string envname;
  std::vector <EnvVersionWithSign> version;
};

#endif
