#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <iomanip>
#include <time.h>
#include <ctype.h>

#ifdef HAVE_SSTREAM
#include <sstream>
#else
#include <strstream>
#endif

#ifdef __CYGWIN__

#define timelocal mktime

time_t timegm (struct tm * tm) {
  time_t t_temp = mktime (tm);
  struct tm * tm_temp = gmtime (&t_temp);
  return (t_temp + (t_temp - mktime (tm_temp)));
}

#endif

#include "DateTime.h"


bool IsUserTime (const std::string & usertime) {

  // CCYY-MM-DD HH:MM:SS
  // CCYY-MM-DD HH:MM
  // CCYY-MM-DD

  if (usertime.length() != 10 &&
      usertime.length() != 16 &&
      usertime.length() != 19) return false;

  for (int i = 0; i < usertime.length(); i++) {
    switch (i) {
    case 4:
    case 7:
      if (usertime[i] != '-') return false;
      break;
    case 10:
      if (usertime[i] != ' ') return false;
      break;
    case 13:
    case 16:
      if (usertime[i] != ':') return false;
      break;
    default:
      if (!isdigit (usertime[i])) return false;
      break;
    }
  }
  return true;
}


const std::string GlobusTime (const std::string & usertime) {

  if (!IsUserTime (usertime)) return "";

  tm time;

  time.tm_year = atoi (usertime.substr(0, 4).c_str()) - 1900;
  time.tm_mon = atoi (usertime.substr(5, 2).c_str()) - 1;
  time.tm_mday = atoi (usertime.substr(8, 2).c_str());

  time.tm_hour = (usertime.length() > 10) ?
    atoi (usertime.substr(11, 2).c_str()) : 0;
  time.tm_min = (usertime.length() > 10) ?
    atoi (usertime.substr(14, 2).c_str()) : 0;
  time.tm_sec = (usertime.length() > 16) ?
    atoi (usertime.substr(17, 2).c_str()) : 0;

  time_t temp = timelocal (&time);

  tm globustime;
  gmtime_r (&temp, &globustime);

#ifdef HAVE_SSTREAM
  std::stringstream ss;
#else
  std::strstream ss;
#endif

  ss << std::setfill('0');
  ss << std::setw(4) << globustime.tm_year + 1900
     << std::setw(2) << globustime.tm_mon + 1
     << std::setw(2) << globustime.tm_mday
     << std::setw(2) << globustime.tm_hour
     << std::setw(2) << globustime.tm_min
     << std::setw(2) << globustime.tm_sec
     << 'Z';

#ifdef HAVE_SSTREAM
  return ss.str();
#else
  ss << std::ends;
  std::string retstr = ss.str();
  ss.freeze (false);
  return retstr;
#endif
}


bool IsGlobusTime (const std::string & globustime) {

  if (globustime.length() != 15) return false;

  for (int i = 0; i < globustime.length(); i++) {
    switch (i) {
    case 14:
      if (globustime[i] != 'Z') return false;
      break;
    default:
      if (!isdigit (globustime[i])) return false;
      break;
    }
  }
  return true;
}


const std::string UserTime (const std::string & globustime) {

  if (!IsGlobusTime (globustime)) return "";

  tm time;

  time.tm_year = atoi (globustime.substr(0, 4).c_str()) - 1900;
  time.tm_mon = atoi (globustime.substr(4, 2).c_str()) - 1;
  time.tm_mday = atoi (globustime.substr(6, 2).c_str());
  time.tm_hour = atoi (globustime.substr(8, 2).c_str());
  time.tm_min = atoi (globustime.substr(10, 2).c_str());
  time.tm_sec = atoi (globustime.substr(12, 2).c_str());

  time_t temp = timegm (&time);

  tm usertime;
  localtime_r (&temp, &usertime);

#ifdef HAVE_SSTREAM
  std::stringstream ss;
#else
  std::strstream ss;
#endif

  ss << std::setfill('0');
  ss << std::setw(4) << usertime.tm_year + 1900 << '-'
     << std::setw(2) << usertime.tm_mon + 1 << '-'
     << std::setw(2) << usertime.tm_mday << ' '
     << std::setw(2) << usertime.tm_hour << ':'
     << std::setw(2) << usertime.tm_min << ':'
     << std::setw(2) << usertime.tm_sec;

#ifdef HAVE_SSTREAM
  return ss.str();
#else
  ss << std::ends;
  std::string retstr = ss.str();
  ss.freeze (false);
  return retstr;
#endif
}


int Seconds (const std::string & period) {

  int seconds = 0;

  int pos = std::string::npos;
  int len;

  for (int i = 0; i != period.length(); i++) {
    if (isdigit (period[i])) {
      if (pos == std::string::npos) {pos = i; len = 0;}
      len ++;
    }
    else if (pos != std::string::npos) {
      switch (period[i]) {
      case 'w':
      case 'W':
	seconds += atoi (period.substr (pos, len).c_str()) * 60 * 60 * 24 * 7;
	pos = std::string::npos;
	break;
      case 'd':
      case 'D':
	seconds += atoi (period.substr (pos, len).c_str()) * 60 * 60 * 24;
	pos = std::string::npos;
	break;
      case 'h':
      case 'H':
	seconds += atoi (period.substr (pos, len).c_str()) * 60 * 60;
	pos = std::string::npos;
	break;
      case 'm':
      case 'M':
	seconds += atoi (period.substr (pos, len).c_str()) * 60;
	pos = std::string::npos;
	break;
      case 's':
      case 'S':
	seconds += atoi (period.substr (pos, len).c_str());
	pos = std::string::npos;
	break;
      case ' ':
	break;
      default:
	return -1;
	break;
      }
    }
  }
  if (pos != std::string::npos)
    // default is minutes for backward compatibility
    seconds += atoi (period.substr (pos, len).c_str()) * 60;
  return seconds;
}


const std::string Period (int seconds) {

  if (seconds == 0) {
    std::string retstr = "0";
    return retstr;
  }

  int weeks = 0;
  int days = 0;
  int hours = 0;
  int minutes = 0;

  if (seconds >= 60 * 60 * 24 * 7) {
    weeks = seconds / (60 * 60 * 24 * 7);
    seconds = seconds - weeks * (60 * 60 * 24 * 7);
  }
  if (seconds >= 60 * 60 * 24) {
    days = seconds / (60 * 60 * 24);
    seconds = seconds - days * (60 * 60 * 24);
  }
  if (seconds >= 60 * 60) {
    hours = seconds / (60 * 60);
    seconds = seconds - hours * (60 * 60);
  }
  if (seconds >= 60) {
    minutes = seconds / 60;
    seconds = seconds - minutes * 60;
  }

#ifdef HAVE_SSTREAM
  std::stringstream ss;
#else
  std::strstream ss;
#endif

  bool first = true;

  if (weeks > 0) {
    if (!first) ss << ", ";
    first = false;
    ss << weeks;
    weeks == 1 ? ss << " week" : ss << " weeks";
  }
  if (days > 0) {
    if (!first) ss << ", ";
    first = false;
    ss << days;
    days == 1 ? ss << " day" : ss << " days";
  }
  if (hours > 0) {
    if (!first) ss << ", ";
    first = false;
    ss << hours;
    hours == 1 ? ss << " hour" : ss << " hours";
  }
  if (minutes > 0) {
    if (!first) ss << ", ";
    first = false;
    ss << minutes;
    minutes == 1 ? ss << " minute" : ss << " minutes";
  }
  if (seconds > 0) {
    if (!first) ss << ", ";
    first = false;
    ss << seconds;
    seconds == 1 ? ss << " second" : ss << " seconds";
  }

#ifdef HAVE_SSTREAM
  return ss.str();
#else
  ss << std::ends;
  std::string retstr = ss.str();
  ss.freeze (false);
  return retstr;
#endif
}


const std::string TimeStamp() {

  time_t t = time (NULL);
  tm usertime;
  localtime_r (&t, &usertime);

#ifdef HAVE_SSTREAM
  std::stringstream ss;
#else
  std::strstream ss;
#endif

  ss << std::setfill('0');
  ss << std::setw(4) << usertime.tm_year + 1900 << '-'
     << std::setw(2) << usertime.tm_mon + 1 << '-'
     << std::setw(2) << usertime.tm_mday << ' '
     << std::setw(2) << usertime.tm_hour << ':'
     << std::setw(2) << usertime.tm_min << ':'
     << std::setw(2) << usertime.tm_sec;

#ifdef HAVE_SSTREAM
  return ss.str();
#else
  ss << std::ends;
  std::string retstr = ss.str();
  ss.freeze (false);
  return retstr;
#endif
}
