AC_DEFUN([NORDUGRID_INIT],
[

AC_MSG_CHECKING([for SYSV init scripts])
AC_ARG_WITH(sysv-scripts-location,
  [  --with-sysv-scripts-location=<PATH>  Location of the SYSV init scripts. [[autodetect]]],
  [ initddir="$withval" ],
  [
    initddir=
    for i in /etc/init.d /etc/rc.d/init.d; do
      if test -d "$i" ; then
	initddir="$i"
	break
      fi
    done
  ]
)
if test ! -d "$initddir"; then
  AC_MSG_ERROR(could not find a suitable location for the SYSV init scripts)
fi
AC_MSG_RESULT($initddir)
AC_SUBST(initddir)

AC_ARG_WITH(monitor-prefix,
  [  --with-monitor-prefix=<PATH>         Specify the location of the Grid Monitor WWW scripts. [[/var/www/html/gridmonitor]]],
  [ monitor_prefix="$withval" ],
  [ monitor_prefix="/var/www/html/gridmonitor" ]
)
AC_SUBST(monitor_prefix)

AC_ARG_WITH(monitor-local-prefix,
  [  --with-monitor-local-prefix=<PATH>   Specify the relative location of the Grid Monitor WWW scripts [[gridmonitor]]],
  [ monitor_local_prefix="$withval" ],
  [ monitor_local_prefix=`basename $monitor_prefix` ]
)
AC_SUBST(monitor_local_prefix)

default_cronddir="/etc/cron.d"
AC_ARG_WITH(cron-scripts-prefix,
  [  --with-cron-scripts-prefix=<PATH>    Specify the location of the cron directory. [[/etc/cron.d]]],
  [ cronddir="$withval" ],
  [ cronddir="$default_cronddir" ]
)
AC_SUBST(cronddir)

default_profiledir="/etc/profile.d"
AC_ARG_WITH(profile-scripts-prefix,
  [  --with-profile-scripts-prefix=<PATH> Specify the location of the profile directory. [[/etc/profile.d]]],
  [ profiledir="$withval" ],
  [ profiledir="$default_profiledir" ]
)
AC_SUBST(profiledir)

dnl
dnl Useful C/C++ compiler flags
dnl
CC_MISC_FLAGS=

dnl
dnl Try to use -ansi switch to force people write ASNI code
dnl
if test "x$CC" = "xgcc"; then
  CC_MISC_FLAGS="$CC_MISC_FLAGS -ansi"
fi
AC_SUBST(CC_MISC_FLAGS)

dnl
dnl Check for AIX oddities
dnl
AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
[[#if !defined _AIX
#error _AIX not defined
#endif]])],
[AC_DEFINE(_LARGE_FILES,,[Needed on AIX for consitency with Globus])]
,
)

dnl
dnl Check for the pthread library
dnl
AC_CHECK_LIB([pthread], [pthread_mutex_init],
AC_TRY_COMPILE(
[#include <pthread.h>],
[#ifndef pthread_yield
  char *p = (char *) pthread_yield;
#endif
],AC_DEFINE(HAVE_PTHREAD_YIELD,,[Is pthread_yield declared])
)
)

AH_VERBATIM([NOT_HAVE_PTHREAD_YIELD],
#ifndef HAVE_PTHREAD_YIELD
#define pthread_yield sched_yield
#endif
)dnl


dnl
dnl gSOAP
dnl
gsoap=yes
https_init_script=""
AC_ARG_WITH(gsoap-location,
  [  --with-gsoap-location=<PATH>         Specify the gSOAP installation path. [[autodetect]]],
  [ AC_PATH_PROG(soapcpp2, soapcpp2, not found, $with_gsoap_location/bin) ],
  [ AC_PATH_PROG(soapcpp2, soapcpp2, not found) ]
)
if test "x$soapcpp2" = "xnot found"; then
  gsoap_location=""
  gsoap=
  SOAPCPP2=:
  WSDL2H=:
else
  gsoap_location=`echo "$soapcpp2" | sed -e 's%/bin/soapcpp2$%%' -e 't' -e 's%.*%%'`
  SOAPCPP2=$gsoap_location/bin/soapcpp2
  WSDL2H=$gsoap_location/bin/wsdl2h
  if test "x$gsoap_location" = "x/usr"; then
    :
  else
    GSOAP_INCLUDES=-I$gsoap_location/include
    AC_SUBST(GSOAP_INCLUDES)
  fi
dnl
dnl Find gSoap library
dnl Ps: we should really use pkgconfig: PKG_CHECK_MODULES(GSOAP, gsoap++ >= 2.7.2)
dnl
  for lib in lib64 lib
  do
    if test -f "$gsoap_location/$lib/libgsoap++.la"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
    if test -f "$gsoap_location/$lib/libgsoap++.a"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
    if test -f "$gsoap_location/$lib/libgsoap++.so"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
  done
  if test x"$GSOAP_LIBS" = x ; then
    AC_MSG_WARN([No gSOAP library found. Please install gSOAP.])
    gsoap=
  fi
  https_init_script=httpsd

dnl
dnl gSOAP version
dnl
AC_MSG_CHECKING(for gSOAP version)
gsoap_version=`$gsoap_location/bin/soapcpp2 -v 2>&1 | sed -e 's/.*version \([[^ ]]*\).*/\1/' -e 't new' -e 's/^.*Compiler for C and C++ *\([[^ ]]*\).*/\1/' -e 't matched' -e 's/.*//' -e ':matched' -e ':new' | grep '.'`
if test "x$gsoap_version" = "x"; then
  AC_MSG_WARN([Could not determine version.])
  gsoap=
fi
gsoap_version_major=`echo "$gsoap_version" | sed -e 's/^\([[^\.]]\).*/\1/' -e 't match' -e 's/.*/0/' -e ':match'`
gsoap_version_minor=`echo "$gsoap_version" | sed -e 's/^[[^\.]]*\.\([[^\.]]*\).*/\1/' -e 't match' -e 's/.*/0/' -e ':match'`
gsoap_version_subminor=`echo "$gsoap_version" | sed -e 's/^[[^\.]]*\.[[^\.]]*\.\([[0-9]]*\).*/\1/' -e 't match' -e 's/.*/0/' -e ':match'`
OLD_GSOAP=
AC_MSG_RESULT($gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor)
if test "$gsoap_version_major" -lt "2"; then
  AC_MSG_WARN([found gSOAP version $gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor - gSOAP with version below 2.7.2 is not supported anymore])
  gsoap=
fi
if test "$gsoap_version_major" -eq "2"; then
  if test "$gsoap_version_minor" -lt "7" ; then
    AC_MSG_WARN([found gSOAP version $gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor - gSOAP with version below 2.7.2 is not supported anymore])
    gsoap=
  fi
  if test "$gsoap_version_minor" -eq "7" && test "$gsoap_version_subminor" -lt "2" ; then
    AC_MSG_WARN([found gSOAP version $gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor - gSOAP with version below 2.7.2 is not supported anymore])
    gsoap=
  fi
fi

fi

if test "$gsoap" == "yes"; then
  :
else
  AC_MSG_WARN([gSoap not found - many things will not be built])
fi

AC_SUBST(https_init_script)
AC_SUBST(SOAPCPP2)
AC_SUBST(WSDL2H)
AC_SUBST(GSOAP_LIBS)
AC_SUBST(GSOAP_LOCATION,$gsoap_location)
AM_CONDITIONAL(HAVE_GSOAP, test "x$gsoap" = "xyes")

dnl AC_PYTHON_DEVEL
#
# Python check - only need to have the python binary in the path and
# standard python directory layout
#

dnl
dnl Enable Python wrappers
dnl
PYTHON_LOCATION= 
PYTHON_INCLUDES=
python_devel=no
AC_ARG_ENABLE(python_wrappers,
  [  --disable-python-wrappers          Disable Python wrappers for ARCLIB],  
  [
    case "${enableval}" in
      yes) python_wrappers=true ;;
      no)  python_wrappers=false; AC_MSG_WARN(Python wrappers will be disabled) ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --disable-python-wrappers) ;;
    esac
  ],
  [ python_wrappers=true ]
)

if test "x$python_wrappers" = xtrue ; then

AM_PATH_PYTHON(2.0)
if test -n "$PYTHON"; then
  # Strip 2 path components to find PYTHON location
  PYTHON_LOCATION=`dirname $PYTHON`
  PYTHON_LOCATION=`dirname $PYTHON_LOCATION`
  AC_CHECK_HEADERS($PYTHON_LOCATION/include/python$PYTHON_VERSION/Python.h,
                 [python_devel=yes
                  PYTHON_INCLUDES=-I$PYTHON_LOCATION/include/python$PYTHON_VERSION
                 ],
                 [python_devel=no
                  AC_MSG_WARN([No python headers found - disabling arclib python bindings])])
else
  PYTHON_LOCATION=
fi

fi
AC_SUBST([PYTHON_INCLUDES],[$PYTHON_INCLUDES])
AC_SUBST([PYTHONLIB],[`echo $pythondir|cut -f2- -d/`])
AM_CONDITIONAL(HAVE_PYTHON_DEVEL, test x$python_devel = xyes)

AC_ARG_WITH(mysql-location,
  [  --with-mysql-location=<PATH>         Specify the MySQL installation path. [[autodetect]]],
  [ AC_PATH_PROG(mysql_config, mysql_config, not found, $with_mysql_location/bin) ],
  [ AC_PATH_PROG(mysql_config, mysql_config, not found) ]
)
MYSQL_INCLUDES=
MYSQL_LIBS=
if test "x$mysql_config" != "xnot found"; then
  AC_MSG_CHECKING(for mysql includes)
  mysql_include=`$mysql_config --cflags | sed "s/^-I\([[^ ]]*\).*/\1\/mysql.h/;s/'//g"`
  if ! test -f "$mysql_include"; then
    AC_MSG_RESULT(not found)
    mysql_config=""
  else
    AC_MSG_RESULT(found)
    MYSQL_INCLUDES=`$mysql_config --cflags | sed "s/'//g"`
    MYSQL_LIBS=`$mysql_config --libs | sed "s/'//g"`
  fi
else
  mysql_config=""
fi
AC_SUBST(MYSQL_INCLUDES)
AC_SUBST(MYSQL_LIBS)

XML_LIBS=
AC_ARG_WITH(xml-location,
  [  --with-libxml-location=<PATH>        Specify the libxml2 installation path. [[autodetect]]],
  [ AC_PATH_PROG(xml_config, xml2-config, not found, $with_libxml_location/bin) ],
  [ AC_PATH_PROG(xml_config, xml2-config, not found) ]
)
if test "x$xml_config" != "xnot found"; then
  XML_INCLUDES=`$xml_config --cflags`
  # Remove /usr/include
  XML_INCLUDES=`echo $XML_INCLUDES | sed -e 's, *-I/usr/include/*$, ,g' -e 's, *-I/usr/include/* , ,g'`
  XML_LIBS=`$xml_config --libs`
fi
AC_SUBST(XML_INCLUDES)
AC_SUBST(XML_LIBS)
AM_CONDITIONAL(HAVE_LIBXML, test "x$xml_config" != "xnot found")

dnl
dnl GACL_LOCATION
dnl
gridsite=yes
DEFAULT_GRIDSITE_LOCATION=/opt/gridsite
AC_SUBST(DEFAULT_GRIDSITE_LOCATION)
AC_MSG_CHECKING(for GACL)
AC_ARG_WITH(gacl-location,
  [  --with-gacl-location=<PATH>          Specify the GACL installation path. [[/opt/gridsite|autodetect]]],
  [ GACL_LOCATION=$with_gacl_location ],
  [
    if test "x$GACL_LOCATION" = "x"; then
      GACL_LOCATION=$DEFAULT_GRIDSITE_LOCATION
    fi
  ]
)
if test ! -d $GACL_LOCATION; then
  GACL_LOCATION="$PWD/grid-manager/external/gacl-0.1.5"
  gridsite=
else
  if test ! -f $GACL_LOCATION/lib/libgridsite.a; then
    GACL_LOCATION="$PWD/grid-manager/external/gacl-0.1.5"
    gridsite=
  fi
fi
AC_MSG_RESULT($GACL_LOCATION)  
AC_SUBST(GACL_LOCATION)
AM_CONDITIONAL(NG_GACL, test "x$gridsite" = "x")
AM_CONDITIONAL(GRIDSITE_GACL, test "x$gridsite" != "x")
if test "x$gridsite" = "x"; then
  AC_DEFINE(NG_GACL,,[GACL patched by NG])
else
  AC_DEFINE(GRIDSITE_GACL,,[Gridsite GACL (also patched by NG)])
fi

dnl
dnl 
dnl
AC_ARG_ENABLE(pkgdirs,
  [  --enable-pkgdirs                  Use pkg directories. Useful for /usr installations.],  
  [
    case "${enableval}" in
      yes) pkgdirs=yes ; AC_MSG_WARN(pkg directories will be enabled) ;;
      no)  pkgdirs=no ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --disable-pkgdirs) ;;
    esac
  ],
  [ pkgdirs=no ]
)

dnl
dnl NORDUGRID_LOCATION
dnl
AC_ARG_WITH(nordugrid-location,
  [  --with-nordugrid-location=<PATH>     OBSOLETE Specify the nordugrid installation path. [[/usr]]],
  AC_MSG_ERROR([Option --with-nordugrid-location has been obsoleted please use --prefix and --disable-pkgdirs to get the same sresult])
)
AC_DEFINE_UNQUOTED(DEFAULT_ARC_LOCATION,"$prefix",[Default NorduGrid installation path])
AC_DEFINE_UNQUOTED(DEFAULT_NORDUGRID_LOCATION,"$prefix",[Default NorduGrid installation path])

dnl
dnl DEFAULT_GLOBUS_LOCATION
dnl
AC_MSG_CHECKING(for DEFAULT_GLOBUS_LOCATION)
AC_ARG_WITH(default-globus-location,
  [  --with-default-globus-location=<PATH>  Specify the default globus location. [[/opt/globus]]],
  [
    DEFAULT_GLOBUS_LOCATION="$withval"
  ],
  [
    DEFAULT_GLOBUS_LOCATION="/opt/globus"
  ]
)
AC_MSG_RESULT($DEFAULT_GLOBUS_LOCATION)  
AC_DEFINE_UNQUOTED(DEFAULT_GLOBUS_LOCATION,"$DEFAULT_GLOBUS_LOCATION",[Default Globus installation path])
AC_SUBST(DEFAULT_GLOBUS_LOCATION)

dnl
dnl GLOBUS_LOCATION
dnl
AC_MSG_CHECKING(for GLOBUS_LOCATION)
AC_ARG_WITH(globus-location,
  [  --with-globus-location=<PATH>        Specify the globus installation path. [[/opt/globus]]],
  [
    GLOBUS_LOCATION="$withval"
    export GLOBUS_LOCATION
  ],
  [
    if test "x$GLOBUS_LOCATION" = "x"; then
      GLOBUS_LOCATION=$DEFAULT_GLOBUS_LOCATION
      export GLOBUS_LOCATION
    fi
  ]
)
if test -d $GLOBUS_LOCATION; then
  AC_MSG_RESULT($GLOBUS_LOCATION)  
else
  AC_MSG_RESULT(not found)  
  AC_MSG_WARN(disabling Globus - not many things will work)
  GLOBUS_LOCATION=
fi
AC_SUBST(GLOBUS_LOCATION)

dnl
dnl GPT_LOCATION
dnl
DEFAULT_GPT_LOCATION=/opt/gpt
AC_SUBST(DEFAULT_GPT_LOCATION)
AC_MSG_CHECKING(for GPT_LOCATION)
AC_ARG_WITH(gpt-location,
  [  --with-gpt-location=<PATH>           Specify the gpt installation path. [[/opt/gpt]]],
  [
    if test "x$withval" = "x"; then
      if test "x$GPT_LOCATION" = "x"; then
	GPT_LOCATION=$DEFAULT_GPT_LOCATION
	if test ! -d $GPT_LOCATION; then
	  GPT_LOCATION=$GLOBUS_LOCATION
	fi
	export GPT_LOCATION
      fi
    else
      GPT_LOCATION="$withval"
      export GPT_LOCATION
    fi
  ],
  [
    if test "x$GPT_LOCATION" = "x"; then
      GPT_LOCATION=$DEFAULT_GPT_LOCATION
      if test ! -d $GPT_LOCATION; then
	GPT_LOCATION=$GLOBUS_LOCATION
      fi
      export GPT_LOCATION
    fi
  ]
)
AC_MSG_RESULT($GPT_LOCATION)
AC_SUBST(GPT_LOCATION)

dnl
dnl globus-makefile-header
dnl
AC_ARG_WITH(globus-makefile-header,
  [  --with-globus-makefile-header        Use globus-makefile-header to generate makefile stubs],
  [
    if test "x$withval" = "xno" ; then
      USE_GLOBUS_GPT=.pre
      GLOBUS_MAKEFILE_HEADER=:
    else
      AC_CHECK_PROG(GLOBUS_MAKEFILE_HEADER, globus-makefile-header, $GLOBUS_LOCATION/bin/globus-makefile-header, not found, $GLOBUS_LOCATION/bin)
      if test "x$GLOBUS_MAKEFILE_HEADER" = "xnot found"; then
	AC_CHECK_PROG(GLOBUS_MAKEFILE_HEADER, globus-makefile-header, $GLOBUS_LOCATION/sbin/globus-makefile-header, not found, $GLOBUS_LOCATION/sbin)
	if test "x$GLOBUS_MAKEFILE_HEADER" = "xnot found"; then
	  USE_GLOBUS_GPT=.pre
	  GLOBUS_MAKEFILE_HEADER=:
	else
	  USE_GLOBUS_GPT=
	fi
      else
	USE_GLOBUS_GPT=
      fi
    fi
  ],
  [
    AC_CHECK_PROG(GLOBUS_MAKEFILE_HEADER, globus-makefile-header, $GLOBUS_LOCATION/bin/globus-makefile-header, not found, $GLOBUS_LOCATION/bin)
    if test "x$GLOBUS_MAKEFILE_HEADER" = "xnot found"; then
      AC_CHECK_PROG(GLOBUS_MAKEFILE_HEADER, globus-makefile-header, $GLOBUS_LOCATION/sbin/globus-makefile-header, not found, $GLOBUS_LOCATION/sbin)
      if test "x$GLOBUS_MAKEFILE_HEADER" = "xnot found"; then
	USE_GLOBUS_GPT=.pre
	GLOBUS_MAKEFILE_HEADER=:
      else
	USE_GLOBUS_GPT=
      fi
    else
      USE_GLOBUS_GPT=
    fi
  ]
)
AC_SUBST(USE_GLOBUS_GPT)
AC_SUBST(GLOBUS_MAKEFILE_HEADER)

AC_ARG_WITH(flavor,
  [  --with-flavor=<flavor>               Specify the globus build flavor. [[autodetect]]],
  [
    GLOBUS_FLAVOR_NAME=$withval
    if test ! -f "$GLOBUS_LOCATION/etc/globus_core/flavor_$GLOBUS_FLAVOR_NAME.gpt"; then
      echo "ERROR: Flavor $GLOBUS_FLAVOR_NAME has not been installed" >&2
      exit 1
    fi
  ],
  [
    if test "x$GLOBUS_FLAVOR_NAME" = "x"; then
      AC_CHECK_PROG(GLOBUS_FLAVOR_CONF, globus-flavor-configuration, $GLOBUS_LOCATION/sbin/globus-flavor-configuration, not found, $GLOBUS_LOCATION/sbin)
      if test "x$GLOBUS_FLAVOR_CONF" = "xnot found"; then
	AC_CHECK_PROG(GPT_FLAVOR_CONF, gpt-flavor-configuration, $GPT_LOCATION/sbin/gpt-flavor-configuration, not found, $GPT_LOCATION/sbin)
	if test "x$GPT_FLAVOR_CONF" = "xnot found"; then
	  AC_MSG_WARN([Please specify a globus build flavor])
          FLAVOR_CONF=
        else
	  FLAVOR_CONF=$GPT_FLAVOR_CONF
	fi
      else
	FLAVOR_CONF=$GLOBUS_FLAVOR_CONF
      fi
      if test "x$FLAVOR_CONF" = "x"; then
        GLOBUS_FLAVOR_NAME=
      else
        GLOBUS_FLAVOR_NAME=`$FLAVOR_CONF | grep '^[[a-zA-Z]].*:$' | cut -f1 -d: | grep thr | tail -1`
      fi
    fi
  ]
)
AC_MSG_CHECKING(for Globus flavor)
AC_MSG_RESULT($GLOBUS_FLAVOR_NAME)
AC_SUBST(GLOBUS_FLAVOR_NAME)

GLOBUS_INCLUDES="-I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME/openssl -I/usr/kerberos/include"
AC_SUBST(GLOBUS_INCLUDES)

CPPFLAGS=$GLOBUS_INCLUDES
AC_CHECK_HEADERS([globus_gsi_proxy.h])
AC_CHECK_HEADERS([globus_replica_catalog.h],[rc_supported=yes],[rc_supported=no])
AC_CHECK_HEADERS([globus_rls_client.h],[rls_supported=yes],[rls_supported=no])
AC_CHECK_HEADERS([myproxy.h],myproxy_supported=yes,myproxy_supported=no)
AC_CHECK_HEADERS([sasl.h],sasl_supported=yes,sasl_supported=no)
AC_CHECK_HEADERS([sasl/sasl.h],sasl_supported=yes,sasl_supported=no)

AC_MSG_CHECKING(for globus_io version)
IO_VERSION=`$GPT_LOCATION/sbin/gpt-query -name globus_io 2>/dev/null | \
  egrep 'ver(sion:|:)' 2>/dev/null | head -n 1 2>/dev/null | \
  sed 's/^.*ver\(sion\)*: \([[^ ]]*\).*/\2/' 2>/dev/null`
IO_VERSION_MAJOR=`echo "$IO_VERSION" | sed 's/^\([[^.]]\).*/\1/'`;
if test "x$IO_VERSION_MAJOR" = "x"; then
  AC_MSG_RESULT(failed to determine. Is Globus IO installed?) 
else
  AC_MSG_RESULT($IO_VERSION)
fi
AC_DEFINE_UNQUOTED(GLOBUS_IO_VERSION,$IO_VERSION_MAJOR,[Globus IO version])
#if test "$IO_VERSION_MAJOR" -lt "4"; then
#  AC_DEFINE(OLD_GLOBUS_IO,,[Globus IO version])
#fi


dnl
dnl Check for the globus_gss_assist_authorization_host_name function
dnl
AC_MSG_CHECKING(for globus_gss_assist_authorization_host_name)
AC_TRY_COMPILE(
[#include <globus_gss_assist.h>],
[
  char *p = (char *) globus_gss_assist_authorization_host_name;
],
[
AC_DEFINE(HAVE_GLOBUS_GSS_ASSIST_AUTHORIZATION_HOST_NAME,,[globus_gss_assist_authorization_host_name])
AC_MSG_RESULT(found)
],
[
AC_MSG_RESULT(not found)
]
)

dnl
dnl Enable VOMS
dnl
voms=true
ng_voms=
edg_voms=
AC_ARG_ENABLE(voms,
  [  --disable-voms                     Disable VOMS support],  
  [
    case "${enableval}" in
      yes) voms=true ;;
      no)  voms=false; AC_MSG_WARN(VOMS will be disabled) ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --disable-voms) ;;
    esac
  ],
  [ voms=true ]
)

if test "x$voms" = xtrue ; then

dnl
dnl VOMS_LOCATION
dnl
DEFAULT_VOMS_LOCATION=/opt/voms
AC_SUBST(DEFAULT_VOMS_LOCATION)
AC_ARG_WITH(voms-location,
  [  --with-voms-location=<PATH>          Specify the VOMS installation path. [[/opt/voms]]],
  [ 
    VOMS_LOCATION=$with_voms_location
    if test ! -d $VOMS_LOCATION; then
      AC_MSG_WARN([VOMS_LOCATION ($VOMS_LOCATION) does not exist])
      VOMS_LOCATION=
    fi
  ],[
    if test "x$VOMS_LOCATION" = "x"; then
      VOMS_LOCATION=$DEFAULT_VOMS_LOCATION
    fi
    if test ! -d $VOMS_LOCATION; then
      VOMS_LOCATION=
    fi
  ]
)

dnl
dnl Check for VOMS api availability and type
dnl
VOMS_INCLUDES=""
if test -d /usr/include/voms; then
  VOMS_INCLUDES="-I/usr/include/voms"
fi
if test "x$VOMS_LOCATION" != "x"; then
  VOMS_INCLUDES="-I$VOMS_LOCATION/include/voms -I$VOMS_LOCATION/include"
fi
AC_SUBST(VOMS_INCLUDES)

VOMS_LIBS=
VOMS_FLAVOR=
CPPFLAGS="$VOMS_INCLUDES -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME"
AC_LANG(C++)
AC_CHECK_HEADERS([voms_api.h],
  CPPFLAGS="$VOMS_INCLUDES -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME"
  [AC_CHECK_HEADERS([api_util.h],
    ng_voms=true,
    edg_voms=true
    voms_flavor="_$GLOBUS_FLAVOR_NAME"
    voms_flavor=""
  )]
  LDFLAGS=
  if test "x$VOMS_LOCATION" != "x"; then
    LDFLAGS="-L$VOMS_LOCATION/lib64 -L$VOMS_LOCATION/lib"
  fi
  AC_CHECK_LIB(vomsc$voms_flavor,VOMS_Init, VOMS_LIBS="$LDFLAGS -lvomsapi$voms_flavor",voms=false,)
  ,
  voms=false
)
AC_SUBST(VOMS_LIBS)
AC_LANG(C)

fi

if test "x$voms" != xtrue ; then
  ng_voms=
  edg_voms=
  AC_MSG_WARN(VOMS will be disabled)
  voms_supported="no"
fi

if test "x$ng_voms" != "x" ; then
  AC_DEFINE(NG_VOMS,,[voms-1.1.x])
  voms_supported="old NG patched"
fi
if test "x$edg_voms" != "x" ; then
  AC_DEFINE(EDG_VOMS,,[voms-1.2.x])
  voms_supported="yes"
fi
AM_CONDITIONAL(NG_VOMS, test "x$ng_voms" != "x")
AM_CONDITIONAL(EDG_VOMS, test "x$edg_voms" != "x")
AM_CONDITIONAL(SUPPORT_VOMS, test "x$voms" != "x")

dnl
dnl Enable LCAS
dnl
lcas=true
AC_ARG_ENABLE(lcas,
  [  --disable-lcas                     Disable LCAS support],  
  [
    case "${enableval}" in
      yes) lcas=true ;;
      no)  lcas=false; AC_MSG_WARN(LCAS will be disabled) ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --disable-lcas) ;;
    esac
  ],
  [ lcas=true ]
)

if test "x$lcas" = xtrue ; then

dnl
dnl LCAS_LOCATION
dnl
DEFAULT_LCAS_LOCATION=/opt/edg
LCAS_LOCATION=
AC_ARG_WITH(lcas-location,
  [  --with-lcas-location=<PATH>          Specify the LCAS installation path. [[/opt/edg]]],
  [ 
    LCAS_LOCATION=$with_lcas_location
    if test ! -d $LCAS_LOCATION; then
      AC_MSG_WARN([LCAS_LOCATION ($LCAS_LOCATION) does not exist])
      LCAS_LOCATION=
    fi
  ],[
    if test "x$LCAS_LOCATION" = "x"; then
      LCAS_LOCATION=$DEFAULT_LCAS_LOCATION
    fi
    if test ! -d $LCAS_LOCATION; then
      LCAS_LOCATION=
    fi
  ]
)

dnl
dnl Check for LCAS api availability
dnl
LCAS_INCLUDES=""
if test "x$LCAS_LOCATION" != "x"; then
  LCAS_INCLUDES=-I$LCAS_LOCATION/include
fi
AC_SUBST(LCAS_INCLUDES)

LCAS_LIBS=
CPPFLAGS="$LCAS_INCLUDES -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME"
AC_CHECK_HEADERS([lcas.h],
  LDFLAGS=
  if test "x$LCAS_LOCATION" != "x"; then
    LDFLAGS=-L$LCAS_LOCATION/lib
  fi
  AC_CHECK_LIB(edg_lcas,lcas_init, LCAS_LIBS="$LDFLAGS -ledg_lcas",lcas=false,)
  ,
  lcas=false
)
AC_SUBST(LCAS_LIBS)

fi

if test "x$lcas" != xtrue ; then
  AC_MSG_WARN(LCAS will be disabled)
  lcas_supported="no"
else
  AC_DEFINE(HAVE_LCAS,,[EDG LCAS])
  lcas_supported="yes"
fi
 
AM_CONDITIONAL(HAVE_LCAS, test "x$lcas" = xtrue)


dnl
dnl Enable LCMAPS
dnl
lcmaps=true
AC_ARG_ENABLE(lcmaps,
  [  --disable-lcmaps                   Disable LCMAPS support],  
  [
    case "${enableval}" in
      yes) lcmaps=true ;;
      no)  lcmaps=false; AC_MSG_WARN(LCMAPS will be disabled) ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --disable-lcmaps) ;;
    esac
  ],
  [ lcmaps=true ]
)

if test "x$lcmaps" = xtrue ; then

dnl
dnl LCMAPS_LOCATION
dnl
DEFAULT_LCMAPS_LOCATION=/opt/edg
LCMAPS_LOCATION=
AC_ARG_WITH(lcmaps-location,
  [  --with-lcmaps-location=<PATH>        Specify the LCMAPS installation path. [[/opt/edg]]],
  [ 
    LCMAPS_LOCATION=$with_lcmaps_location
    if test ! -d $LCMAPS_LOCATION; then
      AC_MSG_WARN([LCMAPS_LOCATION ($LCMAPS_LOCATION) does not exist])
      LCMAPS_LOCATION=
    fi
  ],[
    if test "x$LCMAPS_LOCATION" = "x"; then
      LCMAPS_LOCATION=$DEFAULT_LCMAPS_LOCATION
    fi
    if test ! -d $LCMAPS_LOCATION; then
      LCMAPS_LOCATION=
    fi
  ]
)

dnl
dnl Check for LCMAPS api availability
dnl
LCMAPS_INCLUDES=""
if test "x$LCMAPS_LOCATION" != "x"; then
  LCMAPS_INCLUDES=-I$LCMAPS_LOCATION/include
fi
AC_SUBST(LCMAPS_INCLUDES)

LCMAPS_LIBS=
CPPFLAGS="$LCMAPS_INCLUDES -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME"
AC_CHECK_HEADERS([lcmaps.h],
  LDFLAGS=
  if test "x$LCMAPS_LOCATION" != "x"; then
    LDFLAGS=-L$LCMAPS_LOCATION/lib
  fi
  AC_CHECK_LIB(edg_lcmaps,lcmaps_init, LCMAPS_LIBS="$LDFLAGS -ledg_lcmaps",lcmaps=false,)
  ,
  lcmaps=false
)
AC_SUBST(LCMAPS_LIBS)

fi

if test "x$lcmaps" != xtrue ; then
  AC_MSG_WARN(LCMAPS will be disabled)
  lcmaps_supported="no"
else
  AC_DEFINE(HAVE_LCMAPS,,[EDG LCMAPS])
  lcmaps_supported="yes"
fi
 
AM_CONDITIONAL(HAVE_LCMAPS, test "x$lcmaps" = xtrue)

dnl
dnl Enable LFC
dnl
lgc=true
AC_ARG_ENABLE(lfc,
  [  --disable-lfc                      Disable LFC support],  
  [
    case "${enableval}" in
      yes) lfc=true ;;
      no)  lfc=false; AC_MSG_WARN(LFC will be disabled) ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --disable-lfc) ;;
    esac
  ],
  [ lfc=true ]
)

if test "x$lfc" = xtrue ; then

dnl
dnl LFC_LOCATION
dnl
DEFAULT_LFC_LOCATION=/opt/lcg
LFC_LOCATION=
AC_ARG_WITH(lfc-location,
  [  --with-lfc-location=<PATH>           Specify the LFC installation path. [[/opt/edg]]],
  [ 
    LFC_LOCATION=$with_lfc_location
    if test ! -d $LFC_LOCATION; then
      AC_MSG_WARN([LFC_LOCATION ($LFC_LOCATION) does not exist])
      LFC_LOCATION=
    fi
  ],[
    if test "x$LFC_LOCATION" = "x"; then
      LFC_LOCATION=$DEFAULT_LFC_LOCATION
    fi
    if test ! -d $LFC_LOCATION; then
      LFC_LOCATION=
    fi
  ]
)

dnl
dnl Check for LFC api availability
dnl
LFC_INCLUDES=""
if test "x$LFC_LOCATION" != "x"; then
  LFC_INCLUDES=-I$LFC_LOCATION/include/lfc
fi
AC_SUBST(LFC_INCLUDES)

LFC_LIBS=
CPPFLAGS="$LFC_INCLUDES -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME"
AC_CHECK_HEADERS([lfc_api.h],
  LDFLAGS=
  if test "x$LFC_LOCATION" != "x"; then
    LDFLAGS="-L$LFC_LOCATION/lib -ldl -lpthread"
  fi
  AC_CHECK_LIB(lfc,lfc_startsess, LFC_LIBS="$LDFLAGS -llfc",lfc=false,)
  ,
  lfc=false
)
AC_SUBST(LFC_LIBS)

fi

if test "x$lfc" != xtrue ; then
  AC_MSG_WARN(LFC will be disabled)
  lfc_supported="no"
else
  AC_DEFINE(HAVE_LFC_API_H,,[gLite LFC])
  lfc_supported="yes"
fi
 
AM_CONDITIONAL(HAVE_LFC, test "x$lfc" = xtrue)


#
# Qt checks
#
have_qt=
QT_INCLUDES=
QT_LIBS=
# If QTDIR is not specified environment is used
# If not available in this shell then try a login shell
if test "x$QTDIR" = "x"; then
  for i in /etc/profile.d/qt.sh /etc/profile.d/qtdir3.sh
  do
    if test -f $i
    then
      . $i
      break
    fi
  done
fi
AC_ARG_WITH(qtdir,
  [  --with-qtdir=<PATH>                  Specify the QT installation path [[autodetect]]],
  [QTDIR=$with_qtdir]
)

# Fallback for Debian
if test "x$QTDIR" = "x"; then
  QTDIR=/usr/share/qt
fi

if ! test -d "$QTDIR"; then
  AC_MSG_WARN([Qt directory not found - no gui])
else
  QT_INCLUDES=-I$QTDIR/include
  CPPFLAGS=$QT_INCLUDES
  AC_CHECK_HEADER([qglobal.h],
    [
      AC_PATH_PROG([MOC], [moc], [not found], $QTDIR/bin:$PATH)
      if test "x$MOC" = "xnot found"; then
        AC_MSG_WARN([No moc - no gui])
      else
        LDFLAGS="-L$QTDIR/lib -L/usr/X11R6/lib -lm"
#        AC_CHECK_LIB(qt-mt,theMainWindow,
          QT_LIBS="$LDFLAGS -lqt-mt"
          have_qt=true
#        )
      fi       
    ],
    AC_MSG_WARN([Qt common include file not found - no gui])
  )
fi
AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LIBS)
AM_CONDITIONAL(HAVE_QT, test "x$have_qt" != "x")

dnl
dnl Check how signal SIG_CHLD is treated in threads
dnl
nonposix_signals_in_threads=
LIBS=-lpthread
AC_MSG_CHECKING(for signals in threads)
AC_TRY_RUN(
#include <stdlib.h>
#include <errno.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

pid_t pid = -1;
int res = -2;

void* parent_thread(void *arg) {
  pid=fork();
  if(pid == -1) {
    _exit(-1);
  };
  if(pid == 0) {
    sleep(5);
    exit(0);
  };
  sleep(1000);
}

void* waiter_thread(void *arg) {
  int status;
  pid_t p;
  sleep(2);
  p=waitpid(pid,&status,0);
  if(p == -1) {
    if(errno != ECHILD) { res=-1; } else { res=1; };
    _exit(res);
  };
  if(p == 0) {
    res=-1;
    _exit(-1);
  };
  res=0;
}

int main(void) {
  pthread_t parent_thr;
  pthread_t waiter_thr;
  int n;
  if(pthread_create(&parent_thr,NULL,&parent_thread,NULL) != 0) {
    _exit(-1);
  };
  if(pthread_create(&waiter_thr,NULL,&waiter_thread,NULL) != 0) {
    _exit(-1);
  };
  for(n=0;n<30;n++) {
    sleep(1);
    if(res!=-2) break;
  };
  _exit(res);
}
  ,
  AC_MSG_RESULT([quite POSIX]),
  [AC_DEFINE(NONPOSIX_SIGNALS_IN_THREADS,,[Old Linux pthreads])
  AC_MSG_RESULT([not a POSIX])],
  AC_MSG_ERROR([cross-compilation is not supported])
)
AM_CONDITIONAL(NONPOSIX_SIGNALS_IN_THREADS, test "x$nonposix_signals_in_threads" != "x")


dnl
dnl Experimental code
dnl
AC_ARG_ENABLE(experimental,
  [  --enable-experimental              Enable experimental code],  
  [
    case "${enableval}" in
      yes) experimental=true ;;
      no)  experimental=false ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --enable-experimental) ;;
    esac
  ],
  [ experimental=false ]
)
if test "x$experimental" = "xtrue"; then
  if test "x$gsoap_location" = "x"; then
    AC_MSG_ERROR(Currently there is no experimental code to be built without gSOAP)
  fi
dnl  AC_MSG_NOTICE([Turning on experimental code])
fi
AM_CONDITIONAL(EXPERIMENTAL, test x$experimental = xtrue)
AM_CONDITIONAL(BUILD_LOGGER, test "x$mysql_config" != "x" && test "x$gsoap_location" != "x")
AM_CONDITIONAL(BUILD_HTTPSD, test "x$gsoap_location" != "x")
AM_CONDITIONAL(BUILD_SE, test "x$xml_config" != "x" && test "x$gsoap_location" != "x")
AM_CONDITIONAL(BUILD_SRM, test "x$WSDL2H" != "x")
AM_CONDITIONAL(BUILD_JSDL, test "x$WSDL2H" != "x" && test "x$OLD_GSOAP" = "x")
AM_CONDITIONAL(BUILD_FIREMAN, test "x$WSDL2H" != "x")
AM_CONDITIONAL(BUILD_GUI, test "x$have_qt" != "x" && test "x$experimental" = "xtrue")
AM_CONDITIONAL(BUILD_JOBSSERVICE, test "x$WSDL2H" != "x" && test "x$experimental" = "xtrue")

if test "x$mysql_config" != "x" && test "x$gsoap_location" != "x"; then
   logger_supported="yes"
else
   logger_supported="no"
fi

if test "x$WSDL2H" = "x"; then
  AC_DEFINE(SRM_MISSING,,[Can't build SRM code])
  AC_DEFINE(FIREMAN_MISSING,,[Can't build Fireman code])
  srm_supported="no"
  fireman_supported="no"
else
  srm_supported="yes"
  fireman_supported="yes"
fi

if test "x$WSDL2H" = "x" || test "x$OLD_GSOAP" != "x" ; then
  AC_DEFINE(JSDL_MISSING,,[Can't build JSDL code])
  jsdl_supported="no"
else
  jsdl_supported="yes"
fi

dnl Add $GLOBUS_LOCATION/lib $GSOAP_LOCATION/$lib to search for system dynamic libraries.
dnl Is used to avoid rpath of the specified paths
  
AC_ARG_ENABLE(rpath-hack,
  [  --disable-rpath-hack               Do not rpath external and internal libraries in libraries/binaries],
  [
    case "${enableval}" in
      yes) rpath_hack=true ;;
      no)  rpath_hack=false ;;
      *)   AC_MSG_ERROR(bad value ${enableval} for --enable-rpath-hack) ;;
    esac
  ],
  [ rpath_hack=true ]
)
if test "x$rpath_hack" = "xtrue"; then
test "x$prefix" = xNONE && prefix=$ac_default_prefix
  cp -p libtool libtool.orig
  # libdir can be set, so can exec_prefix and finally prefix
  # Make sure that libdir will evaluate to something useful
  save_exec_prefix=$exec_prefix
  if test "x$exec_prefix" = xNONE; then
    exec_prefix=$prefix
    if test "x$exec_prefix" = xNONE; then
      exec_prefix=$ac_default_prefix
    fi
  fi
  cat libtool.orig | \
    sed "s,\(^sys_lib_dlsearch_path_spec=.*\).$,\1 $GLOBUS_LOCATION/lib $GSOAP_LOCATION/$lib `eval echo $libdir`\"," > libtool
  exec_prefix=$save_exec_prefix
fi

]
)
