#!/usr/bin/perl
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
use infosys_shared;
use InfosysQJU qw(%config %hoh_gmjobs %users &queueldif &jobsldif &usersldif);
#use warnings;

#
# generates everything under the nordugrid-queue-name=xz.
# creates the queue entry, job & user entries for 
# a PBS queue system
# The GM and configuration interface is factored into the InfosysQJU module.

$timestamp = time;

#external PBS commands
$pbsnodes_command = "$config{pbs_bin_path}/pbsnodes";
$qstat_command = "$config{pbs_bin_path}/qstat";
$qmgr_command = "$config{pbs_bin_path}/qmgr";
$showbf_command = "$config{maui_bin_path}/showbf";

# determine the flavour and version of PBS
my $qmgr_string=`$qmgr_command -c "list server"`;
if ($? != 0 and $config{loglevel}) {    
    &infosys_shared::write_log("Can't run qmgr");
}
$qmgr_string =~ /pbs_version = \b(\D+)_(\d\S+)\b/;
my $pbs_flavour=$1;
my $pbs_version=$2;
if ($pbs_flavour eq "") {
    $qmgr_string =~ /pbs_version = \b(\d\S+)\b/;
    $pbs_flavour="torque";
    $pbs_version=$1;
}

   
# read the queue information for the queue entry from the qstat
# fill the %queue_info and  @acl_users (list of LRMS-authorized unix users, 
# undefined list means every unix user is LRMS authorized)
# also fill the @acl_groups (list of LRMS-authorized unix groups
# undefined list means every unix grup is LRMS authorized)

unless (open QSTATOUTPUT,   "$qstat_command -f -Q $config{queue} |") {
    $config{loglevel} and  &infosys_shared::write_log("Error in executing qstat: $qstat_command -f -Q $config{queue}");
    die "Error in executing qstat: $qstat_command -f -Q $config{queue}\n";
}

while (my $line= <QSTATOUTPUT>) {       
      if ($line =~ m/ = /) {
      	 chomp($line);	 
      	 my ($qstat_var,$qstat_value) = split("=", $line);	
	 $qstat_var =~ s/\s+//g; 
	 $qstat_value =~ s/\s+//g;    	 
      	 $qstat{$qstat_var}=$qstat_value;
      }
}	    
close QSTATOUTPUT;

# set @acl_users, %queue_info from the $qstat{$qstat_var} hash
if (defined ($qstat{"max_running"})) {
   $queue_info{"max_running"} = $qstat{"max_running"};
}     
if (defined ($qstat{"max_user_run"})) {
   $queue_info{"max_user_run"} = $qstat{"max_user_run"};
}
if (defined ($qstat{"max_queuable"})) {
   $queue_info{"max_queuable"} = $qstat{"max_queuable"};
}
if (defined ($qstat{"resources_max.cput"})) {
    my @time=split(":",$qstat{"resources_max.cput"});
    $queue_info{"max.cput"} = ($time[0]*60+$time[1]);    
}
if (defined ($qstat{"resources_min.cput"})) {
    my @time=split(":",$qstat{"resources_min.cput"});
    $queue_info{"min.cput"} = ($time[0]*60+$time[1]+1);
}
if (defined ($qstat{"resources_default.cput"})) {
    my @time=split(":",$qstat{"resources_default.cput"});
    $queue_info{"default.cput"} = ($time[0]*60+$time[1]);   
}
if (defined ($qstat{"acl_user_enable"})) {
    $acl_user_enable = $qstat{"acl_user_enable"};
}
if ($acl_user_enable=~/True/i && defined ($qstat{"acl_users"})) {
    @acl_users = split (/\,/, $qstat{"acl_users"});
}
if (defined ($qstat{"acl_group_enable"})) {
    $acl_group_enable = $qstat{"acl_group_enable"};
}
if ($acl_group_enable=~/True/i && defined ($qstat{"acl_groups"})) {
    @acl_groups = split (/\,/, $qstat{"acl_groups"});
}

# determine the $lrms_queue_status from the LRMS
# set it to 'active' if the queue can accept jobs
if ( ($qstat{"enabled"} =~ /True/) and ($qstat{"started"} =~ /True/)) {
    $lrms_queue_status = "active";
}    



# read the job info from the PBS qstat -f to a hash of hashes %hoh_lrmsjobs
unless (open QSTATOUTPUT,  "$qstat_command -f $config{queue} |") { 
    $config{loglevel} and  &infosys_shared::write_log("Error in executing qstat: $qstat_command -f $config{queue}");
    die "Error in executing qstat: $qstat_command -f $config{queue}\n";
}

my ($jobid, $job_var, $job_value, @d);
while (my $line= <QSTATOUTPUT>) { 
      chomp($line); 
      next if ($line =~ /^$/); 
      if ($line =~ /^.*Job Id:/) {            
         $line =~ s/.*Job Id:\s*//;
	 $line =~ s/\s*$//;
	 @d = split(/\./, $line);
	 $jobid = "$d[0].$d[1]";
	 next;
      }
      if ($line =~ / = /)  {
          ($job_var,$job_value) = split (/ = /, $line);
	  $job_var =~ s/^\s+//g;  
      }
      else {                     
          $line =~ s/^\s*//;   
          $job_value = $job_value.$line;	  
      }   
      $hoh_lrmsjobs{$jobid}{$job_var}=$job_value;     
} 
close QSTATOUTPUT;


#processing the pbsnodes output by using a hash of hashes %hoh_pbsnodes
my %hoh_pbsnodes;
&infosys_shared::read_pbsnodes($pbsnodes_command, \%hoh_pbsnodes);


# loop over the PBS jobs (both grid and nongrid) and 
# count the number of running (plus exiting) jobs with their multiciplity  
# count the jobs per unix users and the number of queueing jobs per users in the queue
# These values may be needed for the calculation of the per user freecpus
# useful variables: $user_jobs_queued{$username}, $user_jobs_running{$username}
# required values for the queue entry: $totalrunning_in_the_queue, $totalqueued
# set the $hoh_lrmsjobs{$jobid}{"rank,used.mem,req.cput,used.cput,used.walltime"} values

my $queue_rank = 0;
$totalrunning_in_the_queue = 0;
my $runningjobs_in_the_queue = 0; 
my %user_jobs_queued;
my %user_jobs_running;
foreach my $jobid (sort {$a <=> $b} keys %hoh_lrmsjobs) {
    if ( $hoh_lrmsjobs{$jobid}{"Resource_List.ncpus"} ) {	         
    	$job_ncpus = $hoh_lrmsjobs{$jobid}{"Resource_List.ncpus"};		         
    }
    elsif ( $hoh_lrmsjobs{$jobid}{"Resource_List.nodes"} ) {          
    	$job_ncpus = $hoh_lrmsjobs{$jobid}{"Resource_List.nodes"};			         
    }
    elsif ( defined $hoh_lrmsjobs{$jobid}{"Resource_List.neednodes"}) {      
    	$job_ncpus = $hoh_lrmsjobs{$jobid}{"Resource_List.neednodes"}			         
    }						         
    else {
    	$job_ncpus = 1;
    }
    if ( $hoh_lrmsjobs{$jobid}{"Job_Owner"} ) {
        $username = $hoh_lrmsjobs{$jobid}{"Job_Owner"};
	$username =~ s/@.*$//;
    }
    if ( ($hoh_lrmsjobs{$jobid}{"job_state"} eq "R") or ($hoh_lrmsjobs{$jobid}{"job_state"} eq "E") ) {
       $totalrunning_in_the_queue += $job_ncpus;
       $runningjobs_in_the_queue++;
       $user_jobs_running{$username}++;
    }
    if ( $hoh_lrmsjobs{$jobid}{"job_state"} eq "Q" ) {
       $user_jobs_queued{$username}++;
       $queue_rank++;
       $hoh_lrmsjobs{$jobid}{"rank"} = $queue_rank;
    }
    #Do the INLRMS:X job state mappings
    if ( $hoh_lrmsjobs{$jobid}{"job_state"} eq "R" ) {
       $hoh_lrmsjobs{$jobid}{"job_state"} = "R";
    }
    elsif ( $hoh_lrmsjobs{$jobid}{"job_state"} eq "Q" ) {
       $hoh_lrmsjobs{$jobid}{"job_state"} = "Q";
    }
    elsif ( $hoh_lrmsjobs{$jobid}{"job_state"} eq "E" ) {
       $hoh_lrmsjobs{$jobid}{"job_state"} = "E";
    }
    elsif ( $hoh_lrmsjobs{$jobid}{"job_state"} eq "U" ) {
       $hoh_lrmsjobs{$jobid}{"job_state"} = "S";
    }
    else {
       $hoh_lrmsjobs{$jobid}{"job_state"} = "O";
    }
    if ( $hoh_lrmsjobs{$jobid}{"resources_used.mem"}) {
       $hoh_lrmsjobs{$jobid}{"used.mem"} = $hoh_lrmsjobs{$jobid}{"resources_used.mem"}-"kb";
    }
    if ( $hoh_lrmsjobs{$jobid}{"Resource_List.cput"}) {
    	@time=split(":",$hoh_lrmsjobs{$jobid}{"Resource_List.cput"});
    	$in_minutes=$time[0]*60+$time[1];
    	$hoh_lrmsjobs{$jobid}{"req.cput"} = $in_minutes;	    
    }
    if ( $hoh_lrmsjobs{$jobid}{"Resource_List.walltime"}) {
    	@time=split(":",$hoh_lrmsjobs{$jobid}{"Resource_List.walltime"});
    	$in_minutes=$time[0]*60+$time[1];
    	$hoh_lrmsjobs{$jobid}{"req.walltime"} = $in_minutes;	    
    }     
    if ($hoh_lrmsjobs{$jobid}{"resources_used.cput"}) {
    	$usedcputime_tmp=$hoh_lrmsjobs{$jobid}{"resources_used.cput"};
    	$usedcputime_tmp=~/(^\d+):(\d+):/;    
    	$hoh_lrmsjobs{$jobid}{"used.cput"} = $1*60+$2;  
    }
    if ($hoh_lrmsjobs{$jobid}{"resources_used.walltime"}) {
       $usedwall_tmp=$hoh_lrmsjobs{$jobid}{"resources_used.walltime"};  
       $usedwall_tmp=~/(^\d+):(\d+):/;         
       $hoh_lrmsjobs{$jobid}{"used.walltime"} = $1*60+$2;     
    }	  
}   



# calculate the number of queued jobs (both grid and non-grid),
# set the $totalqueued
$totalqueued = 0;
if (defined ($qstat{"state_count"})) {
   $qstat{"state_count"}=~ m/Queued:(\d+)/;
   $totalqueued = $1;
}   

# Count the running and queued GRID jobs (a subset of the PBS jobs)
# running jobs are counted with their multiciplity  
# Provide the $gridrunning, $gridqueued numbers

$gridrunning = 0;
$gridqueued=  0;
foreach my $ID (keys %hoh_gmjobs){
	 next unless  $hoh_gmjobs{$ID}{"status"} eq "INLRMS";
	 $pbsjobid=$hoh_gmjobs{$ID}{"localid"};	 
	 if ($hoh_lrmsjobs{$pbsjobid}{"job_state"} eq "R"){	      
	     $gridrunning+=$hoh_gmjobs{$ID}{"count"};
	 }
	 if ($hoh_lrmsjobs{$pbsjobid}{"job_state"} eq "E"){	      
	     $gridrunning+=$hoh_gmjobs{$ID}{"count"};
	 }	 
	 if ($hoh_lrmsjobs{$pbsjobid}{"job_state"} eq "Q"){
	     $gridqueued++;
	 }                 
}



# calculate the totalcpus & number of used cpus
# taking into account the minor output difference of OpenPBS and PBSPRO
# skipping the nondedicated nodes in case the $dedicated_node_string or the
# queue_node_string is defined
$totalcpus=0;
$usedcpus=0;
my $npstring;
if (lc($pbs_flavour) eq "openpbs"){
   $npstring="np" 
}
elsif (lc($pbs_flavour) eq "spbs"){
   $npstring="np"
}
elsif (lc($pbs_flavour) eq "torque"){
   $npstring="np"
}
elsif (lc($pbs_flavour) eq "pbspro"){
   $npstring="pcpus"
}
else {
   $config{loglevel} and  &infosys_shared::write_log("the given flavour of PBS is not supported");
   die "The given flavour of the PBS is not supported"
};  

foreach my $node (keys %hoh_pbsnodes){
   if ($config{dedicated_node_string}){ 						      
      next unless ($hoh_pbsnodes{$node}{"properties"} =~ m/$config{dedicated_node_string}/)     			 
   }											      
   if ($config{queue_node_string}){							      
       next unless ( $hoh_pbsnodes{$node}{"properties"} =~ m/$config{queue_node_string}/ or
       		     $hoh_pbsnodes{$node}{"queue"} =~ m/$config{queue_node_string}/)        	      
   }	  										      
   my $nodestate=$hoh_pbsnodes{$node}{"state"};      					      
   if ($nodestate=~/down/ or $nodestate=~/offline/) {next};
   if ($nodestate=~/(?:,|^)busy/) {
      $totalcpus += $hoh_pbsnodes{$node}{$npstring};
      $usedcpus += $hoh_pbsnodes{$node}{$npstring};
      next;
   }
   $totalcpus += $hoh_pbsnodes{$node}{$npstring};       				      
   if ($hoh_pbsnodes{$node}{"jobs"}){							      
     $usedcpus++;									      
     my @comma = ($hoh_pbsnodes{$node}{"jobs"}=~ /,/g); 				      
     $usedcpus+=@comma;
   } 											      
}      


# loop over the mapped local unix users and determine the LRMS-dependent
# freecpus and queuelength for each of them. 
# Use the %users hash which contains the grid user -> local unix user
# mapping info:  $users{Grid_User_SN}=mapped_unix_id
# Take into account queue limits (cpu & time),
# physically available cpus (values determined above) or use LRMS specific method
# Store the result in two hashes, take care of the syntax of the freecpus: cpus[:minutes] 
# here the :minutes part is optional and used for specifying time limit on CPUs.

foreach $mapped_unixid ( values %users ) {
    #nordugrid-authuser-freecpus
    next if (defined $users_freecpus{$mapped_unixid});
    if (lc($config{scheduling_policy}) eq "maui") {       
       unless (open SHOWBFOUTPUT,   "$showbf_command  -u $mapped_unixid |") {
          $config{loglevel} and  &infosys_shared::write_log("error in executing showbf: $showbf_command  -u $mapped_unixid");
          die "Error in executing showbf: $showbf_command  -u $mapped_unixid";
       }
       while (my $line= <SHOWBFOUTPUT>) {				    
          if ($line =~ /^partition/) {  				    
            last;							    
          }
          if ($line =~ /no procs available/) {
            $maui_freecpus= " 0";					    
            last;							    
          }								    
          if ($line =~ /(\d+).+available for\s+([\w:]+)/) {		    
            @tmp= reverse split /:/, $2;    
            $minutes=$tmp[1] + 60*$tmp[2] + 24*60*$tmp[3];		    
            $maui_freecpus .= " ".$1.":".$minutes;			      
          }								    
          if ($line =~ /(\d+).+available with no timelimit/) {  	    
            $maui_freecpus.= " ".$1;					      
            last; 
          }								    
       } 
       $users_freecpus{$mapped_unixid} = $maui_freecpus;
    }
    else {
       $systemlimit = $totalcpus - $usedcpus;
       if  ($queue_info{"max_running"}) {   
    	    $queuelimit =  $queue_info{"max_running"} - $runningjobs_in_the_queue;
       }    
       else  { $queuelimit =  $systemlimit; }
       if  ($queue_info{"max_user_run"}) {   
    	      $userlimit  =  $queue_info{"max_user_run"} - $user_jobs_running{$mapped_unixid};
       }
       else { $userlimit  =  $systemlimit; }	
   
       #print "SYSTEM:$systemlimit\n";
       #print "QUEUE:$queuelimit\n";;
       #print "USER:$userlimit\n";   
    	  
       @sorted_limits=sort {$a<=>$b}($systemlimit, $queuelimit, $userlimit);
  
       if ($sorted_limits[0] >0 ) {
          if ($queue_info{"max.cput"}) {     
             $users_freecpus{$mapped_unixid} = $sorted_limits[0].":".$queue_info{"max.cput"};
	  }
	  else {
	     $users_freecpus{$mapped_unixid} = $sorted_limits[0];
	  }   
       }
       else {
    	  $users_freecpus{$mapped_unixid} = "0";
       }
    }        
    #nordugrid-authuser-queuelength	        
    if ($user_jobs_queued{$mapped_unixid}) {
       $users_jobs_queued{$mapped_unixid} = $user_jobs_queued{$mapped_unixid};
    }
    else {
       $users_jobs_queued{$mapped_unixid} =  "0";   
    }	 
    
}

if ($config{loglevel} == 2) {  
   my $runtime = time - $timestamp; 
   &infosys_shared::write_log("PBS processing time: $runtime");  
}


&queueldif;

&jobsldif;

&usersldif;


my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("Total execution time: $runtime");
}
elsif ($config{loglevel} == 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}
