#!/usr/bin/perl
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
use infosys_shared;
use InfosysQJU qw(%config %hoh_gmjobs %users &queueldif &jobsldif &usersldif);
#use warnings;


# $DUMMY_LRMS_VALUES = "true";

$timestamp = time;


# External commands
$bhosts_command = "$config{lsf_bin_path}/bhosts -w";
$bqueues_command = "$config{lsf_bin_path}/bqueues";
$bjobs_command = "$config{lsf_bin_path}/bjobs";
$busers_command = "$config{lsf_bin_path}/busers";
$lshosts_command = "$config{lsf_bin_path}/lshosts -w";

# Initialize LSF environment
# This has to be extracted from config

$lsf_profile_path="$config{lsf_profile_path}/profile.lsf";
$lsf_profile=`source $lsf_profile_path`;


# read the queue information for the queue entry from the qstat
# fill the %queue_info and  @acl_users (list of LRMS-authorized unix users,
# undefined list means every unix user is LRMS authorized)

unless (open QSTATOUTPUT,   "$bqueues_command $config{queue} |") {
    $config{loglevel} and  &infosys_shared::write_log("Error in executing bqueues command: $bqueues_command $config{queue}");
    die "Error in executing bqueues: $bqueues_command $config{queue}\n";
}

while (my $line= <QSTATOUTPUT>) {
  if (! ($line =~ '^QUEUE')) {
    chomp($line);
    ($q_name,$q_priority,$q_status,$q_mjobs,$q_mslots,$q_mslots_proc,$q_mjob_slots_host,$q_num_jobs,$q_job_pending,$q_job_running,$q_job_suspended) = split(" ", $line);
  }
}

close QSTATOUTPUT;


#<LRMSPORT
# read the queue info such as limits, authorized users' list, etc from the LRMS "queue" command
# every unix user is LRMS authorized)


## set @acl_users, %queue_info from the $qstat{$qstat_var} hash
if (defined ($q_status) ) {

  if($q_status == "Open:Active")
  {
    $lrms_queue_status = "active";
  }
}

if (defined ($q_mslots) ) {

  if($q_mslots != "-")
  {
    $queue_info{"max_queuable"} = $q_mslots;
  }
}

if (defined ($q_mjob_slots_host) ) {

  if($q_mjob_slots_host != "-")
  {
    $queue_info{"max_running"} = $q_mjob_slots_host;
  }
}

#<LRMSPORT
# read the job info from LRMS to a hash of hashes %hoh_lrmsjobs
# The LRMS jobid is the key of the hash, it MUST match the one stored
# in the GM's job.xx.local file as 'localid'
# determine the queue rank of a LRMS queuing job
# $hoh_lrmsjobs{$jobid}{"rank"} = 1 

# read the job info from the LSF bjobs -a -u all to a hash of hashes %hoh_lrmsjobs
unless (open QSTATOUTPUT,  "$bjobs_command -w -a -u all -q $config{queue} |") {
    $config{loglevel} and  &infosys_shared::write_log("Error in executing bjobs: $bjobs_command -a -u all -q $config{queue}");
    die "Error in executing bjobs: $bjobs_command -a -u all -q $config{queue}\n";
}

while (my $newline= <QSTATOUTPUT>) {
    if (! ($newline =~ '^JOBID') ) {
    chomp($newline);
    my @jobInfo = split(" ", $newline);
    $length =  @jobInfo;
    if( $length > 6)
    {
      # This avoid the case of parallel jobs. Bjobs may return a list of reserved nodes treated as individual output lines.
      $lrms_jobs{$jobInfo[0]}{"owner"}=$jobInfo[1];
      $lrms_jobs{$jobInfo[0]}{"status"}=$jobInfo[2];
      $lrms_jobs{$jobInfo[0]}{"queue"}=$jobInfo[3];
      $lrms_jobs{$jobInfo[0]}{"fromHost"}=$jobInfo[4];
      $lrms_jobs{$jobInfo[0]}{"execHost"}=$jobInfo[5];
      $lrms_jobs{$jobInfo[0]}{"name"}=$jobInfo[6];


    }
  }

}

close QSTATOUTPUT;

$totalrunning_in_the_queue = 0;

foreach $local_jobid (keys (%lrms_jobs))
{

  $job_ncpus = 1;

  if(defined ($lrms_jobs{$local_jobid}{"user"}) )
  {
    $username = $lrms_jobs{$local_jobid}{"user"};
  }

  if(defined ($lrms_jobs{$local_jobid}{"status"}) )
  {

    $status = $lrms_jobs{$local_jobid}{"status"};

    if( ($status eq "RUN") || ($status eq "USUSP") )
    {
      $totalrunning_in_the_queue += $job_ncpus;
      $runningjobs_in_the_queue++;
      $user_jobs_running{$username}++;

      $hoh_lrmsjobs{$local_jobid}{"job_state"} = "R";

    } elsif ( ($status eq "PEND") || ($status eq "PSUSP")  || ($status eq "WAIT") )
    {
       $user_jobs_queued{$username}++;
       $queue_rank++;
       $hoh_lrmsjobs{$local_jobid}{"rank"} = $queue_rank;
       $hoh_lrmsjobs{$local_jobid}{"job_state"} = "Q";
    } elsif( ($status == "EXIT") || ($status == "DONE"))
    {

      $hoh_lrmsjobs{$local_jobid}{"job_state"} = "E";

    } elsif ($status == "UNKWN")
    {

      $hoh_lrmsjobs{$local_jobid}{"job_state"} = "U";

    } else
    {
      $hoh_lrmsjobs{$local_jobid}{"job_state"} = "O";
    }
  }

}

# calculate the number of queued jobs (both grid and non-grid),
# set the $totalqueued
$totalqueued = 0;
if (defined ($q_job_pending))
{
   $totalqueued = $q_job_pending;
}


#LRMSPORT>


#<LRMSPORT # Calculate the totalcpus & cpudistribution & number of used cpus # by collecting information from the LRMS 
# Consult the schema for the syntax of the $cpudistribution 
# If $dedicated_node_string is set, nondedicated nodes, which are not marked wit h 
# $dedicated_node_string should be skipped


#processing the bhosts output by using a hash of hashes %hoh_lsfnodes
my %hoh_lsfnodes;
&infosys_shared::read_lsfnodes($lshosts_command,$bhosts_command,\%hoh_lsfnodes);


# @cpudist=0;

foreach my $node (keys %hoh_lsfnodes){

  if($hoh_lsfnodes{$node}{"node_status"} eq "ok")
  {
    #  ($nodeid, $OStype, $model, $cpuf, $maxmem, $maxswp, $ncpus ) =  split(/\s+/, $hoh_lsfnodes{$node});
    $totalcpus += $hoh_lsfnodes{$node}{"node_ncpus"};
    $usedcpus += $hoh_lsfnodes{$node}{"node_used_slots"};
  }
}

#LRMSPORT>


if ($config{loglevel} == 2) {
   my $runtime = time - $timestamp; 
   &infosys_shared::write_log("LRMS I/O time: $runtime");
}


#<LRMSPORT
# Count the running and queued GRID jobs in the LRMS (a subset of all LRMS jobs)
# running jobs are counted with their multiciplity
# you can loop through the hoh_gmjobs and use the "dummy13"=$hoh_gmjobs{$ID}{"localid"}
# and the $hoh_lrmsjobs{"dummy13"}{"job_state"} to find queuing and running grid jobs
# in the LRMS

$gridrunning = 0;
$gridqueued=  0;
foreach my $ID (keys %hoh_gmjobs){

  next unless  $hoh_gmjobs{$ID}{"status"} eq "INLRMS";
  $pbsjobid=$hoh_gmjobs{$ID}{"localid"};	 
  if ($hoh_lrmsjobs{$pbsjobid}{"job_state"} eq "R"){
    $gridrunning+=$hoh_gmjobs{$ID}{"count"};
  }
  if ($hoh_lrmsjobs{$pbsjobid}{"job_state"} eq "E"){
    $gridrunning+=$hoh_gmjobs{$ID}{"count"};
  }	 
  if ($hoh_lrmsjobs{$pbsjobid}{"job_state"} eq "Q"){
    $gridqueued++;
  }
}

#LRMSPORT>


# loop over the mapped local unix users and determine the LRMS-dependent
# freecpus and queuelength for each of them. 
# Use the %users hash which contains the grid user -> local unix user
# mapping info:  $users{Grid_User_SN}=mapped_unix_id
# Take into account queue limits (cpu & time),
# physically available cpus (values determined above) or use LRMS specific method
# Store the result in two hashes, take care of the syntax of the freecpus: cpus[:minutes] 
# here the :minutes part is optional and used for specifying time limit on CPUs.
# $freecpus_for_mapped_users{unix_username}="13:33"
# $user_jobs_queued{$unix_username}=13

$systemlimit = $totalcpus - $usedcpus;
if( $systemlimit < 0) { $systemlimit = 0; }

foreach $mapped_unixid ( values %users ) {
    next  if (defined $users_freecpus{$mapped_unixid});
    #nordugrid-authuser-freecpus
    $users_freecpus{$mapped_unixid} = "$systemlimit";
    #nordugrid-authuser-queuelength: done ($users_jobs_queued{$mapped_unixid})
}

#LRMSPORT>

&queueldif;


&jobsldif;


&usersldif;



my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($config{loglevel} = 1 and $runtime >= 4 ) {
   &infosys_shared::write_log("SLOW script: $runtime");
}

