#!/usr/bin/perl
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
use infosys_shared;
use InfosysQJU qw(%config %hoh_gmjobs %users &queueldif &jobsldif &usersldif);
#use warnings;


# This is the fork LRMS qju infosys provider. 
# Generates everything under the nordugrid-queue-name=xz,
# creates the queue, job & user entries.
# Real GM, config and fork LRMS values are used,
# The GM interface is factored into the InfosysQJU module.
# Don't use 'my xyz' for the interfacing GLOBAL variables!


$timestamp = time;


# trying to interprete queue limits for fork which is not a queue system
# therefore for the begining nothing is set
# nordugrid-queue-maxrunning
#$queue_info{"max_running"} = 13;

# nordugrid-queue-maxinqueue
#$queue_info{"max_queuable"} = 133;

# nordugrid-queue-maxuserrun
#$queue_info{"max_user_run"} = 13;

# nordugrid-queue-maxcputime (in minutes)
#$queue_info{"max.cput"} = 133;

# nordugrid-queue-mincput (in minutes)
#$queue_info{"min.cput"} = 0;

# nordugrid-queue-defaultcputime (in minutes)
#$queue_info{"default.cput"} = 133;



# set it to 'active' if the queue can accept jobs
# fork is always 'active'
$lrms_queue_status = "active";


# TODO: loop over the %hoh_gmjobs and for the 'INLRMS'
# jobs try to determine some of the following values
# and determine the $gridrunning for the nordugrid-queue-gridrunning

$gridrunning = 0;
foreach my $ID (keys %hoh_gmjobs){
   next unless  $hoh_gmjobs{$ID}{"status"} eq "INLRMS";
   $localjobid=$hoh_gmjobs{$ID}{"localid"};	 
   next unless  ($localjobid) ;
   #TODO check whether the job is really in the fork
   $gridrunning++;
   # determine the fork job states
   $hoh_lrmsjobs{"$localjobid"}{"job_state"} = "R";     
   # no queue in fork, we don't set the rank
   #$hoh_lrmsjobs{"$localjobid"}{"rank"} = "";
   # value for used memory ???
   #$hoh_lrmsjobs{"$localjobid"}{"used.mem"} = "13";
   # value (in minutes) for used walltime
   #$hoh_lrmsjobs{"$localjobid"}{"used.walltime"} = 13;
   # value (in minutes) for used cputime
   #$hoh_lrmsjobs{"$localjobid"}{"used.cput"} = 13;  	   
   # value (in minutes) for requested cputime
   # $hoh_lrmsjobs{"$localjobid"}{"req.cput"} = "66";
   #nordugrid-job-executionnodes, notice the 'syntax' of multiple nodes
   # $hoh_lrmsjobs{"dummy13"}{"exec_host"} = "dummy1+dummy2+dummy3";
   # comment string from the LRMS
   $hoh_lrmsjobs{"$localjobid"}{"comment"} = "Running under fork";    
}



# nordugrid-queue-running
# $totalrunning_in_the_queue (number of active jobs in a fork system) is calculated by 
# making use of the 'ps axr'
$totalrunning_in_the_queue = 0;
unless (open PSCOMMAND,  "ps axr |") {
   $config{loglevel} and  &infosys_shared::write_log("error in executing ps axr");
   die "error in executing ps axr";
}
while(my $line = <PSCOMMAND>) {
    chomp($line);
    next if ($line =~ m/PID TTY/);
    next if ($line =~ m/ps axr/);
    next if ($line =~ m/cluster-fork/);     
    $totalrunning_in_the_queue++;
}
close PSCOMMAND;

# for consistency and to overcome the gm latency the $totalrunning_in_the_queue can't be 
# less than the $gridrunning
if ($totalrunning_in_the_queue < $gridrunning) {
    $totalrunning_in_the_queue = $gridrunning;
}    

# nordugrid-queue-queued
# no queuing jobs in fork, therefore it is set to 0
$totalqueued = 0;


# nordugrid-queue-gridqueued
# no queueing jobs under fork, therefore it is set to 0
$gridqueued = 0;


# number of cpus is calculated from the /proc/cpuinfo, by default it is set to 1
# totalcpus is used in the user-freecpus calculation
$totalcpus = 0;
unless (open CPUINFOFILE, "</proc/cpuinfo") {
   $config{loglevel} and  &infosys_shared::write_log("can't read the /proc/cpuinfo");
   die "can't read the /proc/cpuinfo";
}   
while(my $line = <CPUINFOFILE>) {
    chomp($line);
    if ($line =~ m/^processor/) {
        $totalcpus++;	
    }
}
close CPUINFOFILE;
$totalcpus ||= 1;


if ($config{loglevel} == 2) {  
   my $runtime = time - $timestamp; 
   &infosys_shared::write_log("LRMS processing time: $runtime");  
}


# loop over the mapped local unix users and determine the LRMS-dependent
# freecpus and queuelength for each of them. 
# freecpus as a first approximation is set to the number of available cpus while
# queuelength has no sense for fork


my $job_limit;
if (lc $config{fork_job_limit} eq "cpunumber") {
    $job_limit = $totalcpus;
}
elsif ( defined $config{fork_job_limit} ) {
    $job_limit = $config{fork_job_limit};
}
else {
    $job_limit = 1;
}    

    
foreach $mapped_unixid ( values %users ) {    
    #nordugrid-authuser-freecpus
    if ( ($job_limit - $gridrunning) >= 0) {
        $users_freecpus{$mapped_unixid} = $job_limit - $gridrunning;
    }
    else {
        $users_freecpus{$mapped_unixid} = 0;
    }		
    #nordugrid-authuser-queuelength is not set, there is no queue in fork
    #$users_jobs_queued{$mapped_unixid} = "";
}


&queueldif;


&jobsldif;


&usersldif;



my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("Total execution time: $runtime");
}
elsif ($config{loglevel} = 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}
