#!/usr/bin/perl
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
use infosys_shared;
use InfosysCluster qw(%config &clusterldif);
#use warnings;


# populates the nordugrid-cluster LDAP entry with config, GM
# and PBS data

#external PBS commands
$pbsnodes_command="$config{pbs_bin_path}/pbsnodes";
$qstat_command="$config{pbs_bin_path}/qstat";
$qmgr_command="$config{pbs_bin_path}/qmgr";


#determine the flavour and version of PBS"
my $qmgr_string=`$qmgr_command -c "list server"`;
if ($? != 0 and $loglevel) {    
    &infosys_shared::write_log("Can't run qmgr");
}
$qmgr_string =~ /pbs_version = \b(\D+)_(\d\S+)\b/;
$lrms_type=$1;
$lrms_version=$2;
if ($lrms_type eq "") {
    $qmgr_string =~ /pbs_version = \b(\d\S+)\b/;
    $lrms_type="torque";
    $lrms_version=$1;
}

#read the qstat information about all the jobs
unless (open QSTATOUTPUT,  "$qstat_command  |") {
    $loglevel and  &infosys_shared::write_log("Error in executing qstat");
    die "Error in executing qstat\n";
}
    
while (my $line= <QSTATOUTPUT>) {       
      if ($line =~ m/^\d+/) {
         push @all_pbs_jobs, $line;       	 
      	 }
      }	    
close QSTATOUTPUT;


#processing the pbsnodes output by using a hash of hashes %hoh_pbsnodes
my %hoh_pbsnodes;
&infosys_shared::read_pbsnodes($pbsnodes_command, \%hoh_pbsnodes);


# calculate the totalcpus & cpudistribution & number of used cpus
# taking into account the minor output difference of OpenPBS and PBSPRO
# skipping the nondedicated nodes in case the $dedicated_node_string is defined
$totalcpus=0;
$usedcpus=0;
$cpudistribution="";
@cpudist=0;
if (lc($lrms_type) eq "openpbs"){
     $npstring="np" 
}
elsif (lc($lrms_type) eq "spbs"){
     $npstring="np"
}
elsif (lc($lrms_type) eq "torque"){
     $npstring="np"
}
elsif (lc($lrms_type) eq "pbspro"){
     $npstring="pcpus"
}
else {
     $loglevel and  &infosys_shared::write_log("the given flavour of PBS is not supported");
     die "The given flavour of PBS is not supported"
};  
 
foreach my $node (keys %hoh_pbsnodes){
      my $tmpstring;
      if ($tmpstring = $config{dedicated_node_string}){
         next unless ($hoh_pbsnodes{$node}{"properties"} =~ m/$tmpstring/)	        	  
      }
      $nodestate=$hoh_pbsnodes{$node}{"state"};      
      if ($nodestate=~/down/ or $nodestate=~/offline/) {next};
      if ($nodestate=~/(?:,|^)busy/) {
         $totalcpus += $hoh_pbsnodes{$node}{$npstring};
	 $cpudist[$hoh_pbsnodes{$node}{$npstring}] +=1;
	 $usedcpus += $hoh_pbsnodes{$node}{$npstring};
	 next;
      }
      $totalcpus += $hoh_pbsnodes{$node}{$npstring};
      $cpudist[$hoh_pbsnodes{$node}{$npstring}] +=1;
      if ($hoh_pbsnodes{$node}{"jobs"}){
        $usedcpus++;
        @comma = ($hoh_pbsnodes{$node}{"jobs"}=~ /,/g);
	$usedcpus+=@comma;
      } 
}      

for (my $i=0; $i<=$#cpudist; $i++) {
   next unless ($cpudist[$i]);  
   $cpudistribution .= " ".$i."cpu:".$cpudist[$i]
}


# Calculate $lrms_queued, the number of jobs (both grid and nongrid) 
# being queued in the LRMS 
@queued_pbs_jobs = grep / [QH] /, @all_pbs_jobs;
$lrms_queued = scalar @queued_pbs_jobs;


# Calculate the total number of jobs in the PBS 
# (running, queued, hold, being in any PBS state;
# submitted by both grid and nongrid users): $lrms_total
$lrms_total = scalar @all_pbs_jobs;


# generating the cluster ldif  
&clusterldif;


# some performance test
my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($config{loglevel} == 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}
   


exit;
