package         InfosysQJU;
require         Exporter;
@ISA            =qw(Exporter);
@EXPORT         =qw(%config %hoh_gmjobs %users &queueldif &jobsldif &usersldif);
@EXPORT_OK      =qw(%config);

use Getopt::Long;
use infosys_shared;
use POSIX qw(ceil);
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
#use warnings;


# Module to initialize Grid Manager dependent variables, to process the configuration file
# and to generate the queue,job,user ldifs for the queue+jobs+users-lrms providers


GetOptions("dn:s" => \$config{dn},	     	  
	   "queue:s" => \$config{queue}, 
	   "config:s" => \$config{conf_file}, 
	   "valid-to:i" => \$config{ttl},   
	   "loglevel:i" => \$config{loglevel},
	   "help|h" => \$print_help   
	  ); 
 
if ($print_help) { 
    print "\n  
     		script usage: 
		mandatory arguments: --dn
				     --queue
				     --config
				      
		optional arguments:  --valid-to 
				     --loglevel
		this help:	     --help			  		
		\n";
		exit;
}

if (! ($config{dn} and $config{queue} and $config{conf_file})) {
    $config{loglevel} and  &infosys_shared::write_log("a command line argument is missing, see --help ");
    die "a command line argument is missing, see --help "
};

#
#  default values
#
$config{ttl}           ||= 600;
$config{gm_mount_point}  = "/jobs";
$config{gm_port}         = 2811;
$config{gridmap} 	 = "/etc/grid-security/grid-mapfile";
$config{providerlog}	 ="/var/log/infoprovider.log";
$config{homogeneity} 	 = "TRUE";
chomp ($config{hostname} = `/bin/hostname -f`);


#parse the arc.conf directly into a hash $parsedconfig{blockname}{variable_name}
unless (open (CONFIGFILE, "<$config{conf_file}")) {
    $config{loglevel} and  &infosys_shared::write_log("can't open $config{conf_file} configuration file");
    die "Can't open $config{conf_file} configuration file\n";
}
my $blockname;
while (my $line =<CONFIGFILE>) {
   next if $line =~/^#/;
   next if $line =~/^$/;
   next if $line =~/^\s+$/;
   
   if ($line =~/\[(.+)\]/ ) {
      $blockname = $1;
      next;
   }
   
   unless ($line =~ /=\s*".*"\s*$/) {
      $config{loglevel} and &infosys_shared::write_log("skipping incorrect arc.conf line: $line");
      next;
   }
    
   $line =~m/^(\w+)\s*=\s*"(.*)"\s*$/;
   $variable_name=$1;
   $variable_value=$2;
   unless ($parsedconfig{$blockname}{$variable_name}) {
      $parsedconfig{$blockname}{$variable_name} = $variable_value;
   }
   else {
      $parsedconfig{$blockname}{$variable_name} .= "[separator]".$variable_value;
   }   
}
close CONFIGFILE;


#fill the %config hash from the %parsedconfig taking into account the block hierarchy
foreach $variable (keys %{ $parsedconfig{"common"} } ) {
   $config{$variable} = $parsedconfig{"common"}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"grid-manager"} } ) {
   $config{$variable} = $parsedconfig{"grid-manager"}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"infosys"} } ) {
   $config{$variable} = $parsedconfig{"infosys"}{$variable};
}
#better no to take cluster block values for the queue block
#foreach $variable (keys %{ $parsedconfig{"cluster"} } ) {
#   $config{$variable} = $parsedconfig{"cluster"}{$variable};
#}
foreach $variable (keys %{ $parsedconfig{"queue/".$config{queue}} } ) {
   $config{$variable} = $parsedconfig{"queue/".$config{queue}}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"gridftpd/jobs"} } ) {
   $config{$variable} = $parsedconfig{"gridftpd/jobs"}{$variable};
}


#
# read the mappings from the grid-mapfile to a %users hash, the SN is the key
#

unless (open MAPFILE, "<$config{gridmap}") {
   $config{loglevel} and  &infosys_shared::write_log("can't open gridmapfile at $config{gridmap}");
   die "can't open gridmapfile at $config{gridmap}";
}   
while(my $line = <MAPFILE>) {
    chomp($line);
    if ($line =~ m/\"([^"]+)\"\s+(\S+)/) {
        $users{$1}=$2; 	
    }
}
close MAPFILE;

#
# if sessiondir ="*" read $HOME of the local unix users from "passwd" into the %homedirs{$uid} 
#
my %homedirs;
if ($config{"sessiondir"} =~ /^\s*\*\s*$/) {   
   unless (open PASSWD, "</etc/passwd") {
      $config{loglevel} and  &infosys_shared::write_log("can't open passwd file at /etc/passwd");
      die "can't open passwd file at /etc/passwd";
   }	     
   while  (my $line= <PASSWD>) {
       my @passwd_fields = split (":", $line);  
       $homedirs{$passwd_fields[0]}=$passwd_fields[5];
   }
   close PASSWD;
}

#
# Check whether the grid daemons are running, fill the %frontend_status
#
$frontend_status{grid-manager} = `pgrep grid-manager`; 								   
if ($? != 0) {  											   
    $frontend_status{grid-manager} = `ps -C grid-manager  --no-heading`;			          		   
    if ($? != 0) {											   
	$config{loglevel} and	&infosys_shared::write_log("Failed checking the grid-manager process");   	
    }													   
}													   
$frontend_status{gridftpd} = `pgrep gridftpd`;								   
if ($? != 0) {  											   
    $frontend_status{gridftpd} = `ps -C gridftpd --no-heading`; 				         	   
    if ($? != 0) {											   
	$config{loglevel} and	&infosys_shared::write_log("Failed checking the gridftpd process");	    	
    }													   
}													   

if ($config{loglevel} == 2) {  
   my $runtime = time - $^T; 
   &infosys_shared::write_log("CONFIG+GRIDMAP I/O time: $runtime");  
}


#
# read the list of jobs from the jobdir and create the @gridmanager_jobs 
# the @gridmanager_jobs contains the IDs from the job.ID.status
#

$timestamp = time;
unless (opendir JOBDIR,  $config{controldir}) {
   $config{loglevel} and  
   &infosys_shared::write_log("can't access the directory of the jobstatus files at $config{controldir}");
   die "Can't access the directory of the jobstatus files at $config{controldir}\n";
}  

my @allfiles= readdir JOBDIR;
@allfiles= grep /\.status/, @allfiles;
closedir JOBDIR;
@gridmanager_jobs = map {$_=~m/job\.(.+)\.status/; $_=$1;} @allfiles;


#
# read the gridmanager jobinfo into a hash of hashes %hoh_gmjobs 
# filter out jobs not belonging to this $queue,
# fill the %gm_queued{SN} with number of gm_queued jobs for every grid user
# count the prelrmsqueued, pendingprelrms grid jobs belonging to this queue

my %gm_queued;
my $queue_prelrmsqueued=0;
my $controldir = $config{controldir};
my @gmqueued_states = ("ACCEPTED","PENDING:ACCEPTED","PREPARING","PENDING:PREPARING","SUBMIT"); 
my $queue_pendingprelrms=0;
my @gmpendingprelrms_states =("PENDING:ACCEPTED","PENDING:PREPARING" );
foreach $ID (@gridmanager_jobs) { 
    my $gmjob_local=$controldir."/job.".$ID.".local";
    my $gmjob_status=$controldir."/job.".$ID.".status";
    my $gmjob_failed=$controldir."/job.".$ID.".failed";  
    my $gmjob_description=$controldir."/job.".$ID.".description"; 
    my $gmjob_diag=$controldir."/job.".$ID.".diag"; 
        
    unless (open (GMJOB_LOCAL, "<$gmjob_local")) {
       $config{loglevel} and
       &infosys_shared::write_log("Can't read the $gmjob_local jobfile");       
       die "Can't read the $gmjob_local jobfile\n"; 
    }    
    
    my @local_allines=<GMJOB_LOCAL>;
    
    # check that this job belongs to this queue  
    my $the_right_queue= grep /^queue=$config{queue}$/, @local_allines;
    if ($config{lrms} eq "fork") {
       # fork lrms doesn't have several queues, it is always the right one
       $the_right_queue= "true";
    }
    if (!$the_right_queue) {
       close GMJOB_LOCAL;
       next;
    }
    
    # parse the content of the job.ID.local into the %hoh_gmjobs hash 
    foreach my $line (@local_allines) {		  
  	$line=~m/^(\w+)=(.+)$/; 		   	
  	$hoh_gmjobs{$ID}{$1}=$2;
    }	 
    close GMJOB_LOCAL;

    # read the job.ID.status into "status"
    open (GMJOB_STATUS, "<$gmjob_status");
    my @status_allines=<GMJOB_STATUS>;    
    chomp (my $job_status_firstline=$status_allines[0]);    
    $hoh_gmjobs{$ID}{"status"}= $job_status_firstline;
    close GMJOB_STATUS;    
    
    # set the job_gridowner of the job (read from the job.id.local)
    # which is used as the key of the %gm_queued
    my $job_gridowner = $hoh_gmjobs{$ID}{"subject"};

    # count the gm_queued jobs per grid users (SNs) and the total
    if ( grep /^$hoh_gmjobs{$ID}{"status"}$/, @gmqueued_states ) {
       $gm_queued{$job_gridowner}++;
       $queue_prelrmsqueued++;
    }
    # count the GM PRE-LRMS pending jobs
    if ( grep /^$hoh_gmjobs{$ID}{"status"}$/, @gmpendingprelrms_states ) {       
       $queue_pendingprelrms++;      
    }

    # Skip the remaining files if the jobstate "DELETED"
    next if ( $hoh_gmjobs{$ID}{"status"} eq "DELETED");

    # Do the gm job state mappings
    if ($hoh_gmjobs{$ID}{"status"} eq "ACCEPTED") {
       $hoh_gmjobs{$ID}{"status"} = "ACCEPTING";
    }
    if ($hoh_gmjobs{$ID}{"status"} eq "PENDING:ACCEPTED") {
       $hoh_gmjobs{$ID}{"status"} = "ACCEPTED";
    }   
    if ($hoh_gmjobs{$ID}{"status"} eq "PENDING:PREPARING") {
       $hoh_gmjobs{$ID}{"status"} = "PREPARED";
    }
    if ($hoh_gmjobs{$ID}{"status"} eq "SUBMIT" and $frontend_status{grid-manager}) {
       $hoh_gmjobs{$ID}{"status"} = "SUBMITTING";
    }
    if ($hoh_gmjobs{$ID}{"status"} eq "PENDING:INLRMS") {
       $hoh_gmjobs{$ID}{"status"} = "EXECUTED";
    }
    if ($hoh_gmjobs{$ID}{"status"} eq "PREPARING" and ! $frontend_status{grid-manager}) {
       $hoh_gmjobs{$ID}{"status"} = "ACCEPTED";
    }   
    if ($hoh_gmjobs{$ID}{"status"} eq "FINISHING" and ! $frontend_status{grid-manager}) {
       $hoh_gmjobs{$ID}{"status"} = "EXECUTED";
    }
    if ($hoh_gmjobs{$ID}{"status"} eq "SUBMIT" and ! $frontend_status{grid-manager}) {
       $hoh_gmjobs{$ID}{"status"} = "PREPARED";
    }         
          
    # Comes the splitting of the terminal job state
    # check for job failure, (job.ID.failed )   "errors"
    if (-e $gmjob_failed) {
       open (GMJOB_FAILED, "<$gmjob_failed");
       my @failed_allines=<GMJOB_FAILED>;    
       chomp  @failed_allines;
       $temp_errorstring = join " ", @failed_allines;
       $temp_errorstring =~ s/\s+$//;     
       if (length $temp_errorstring >= 87) {
         $temp_errorstring = substr ($temp_errorstring, 0, 87);
       }       
       $hoh_gmjobs{$ID}{"errors"}="$temp_errorstring";
       close GMJOB_FAILED;
    }
    
    if ($hoh_gmjobs{$ID}{"status"} eq "CANCELING") {
        #canceling -> killing
	$hoh_gmjobs{$ID}{"status"} = "KILLING"
    }
     
    if ($hoh_gmjobs{$ID}{"status"} eq "FINISHED") {
        #terminal job state mapping
	if ($hoh_gmjobs{$ID}{"errors"} =~ /User requested to cancel the job/) {
	    $hoh_gmjobs{$ID}{"status"} = "KILLED"
	}
	elsif (defined $hoh_gmjobs{$ID}{"errors"}) {
	    $hoh_gmjobs{$ID}{"status"} = "FAILED"
	}
        #job-completiontime
      	my @file_stat = stat $gmjob_status;
      	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($file_stat[9]);
        my $file_time = sprintf "%4d%02d%02d%02d%02d%02d%1s", $year+1900,$mon+1,$mday,$hour,$min,$sec,"Z";    
      	$hoh_gmjobs{$ID}{"completiontime"} = "$file_time";	
    }

    # Make a job comment if the GM is dead
    unless ($frontend_status{grid-manager}) {
       $hoh_gmjobs{$ID}{"comment"} = "GM: The grid-manager is down";
    }         
	
    # do something with the job.ID.description file
    # read the stdin,stdout,stderr 
    open (GMJOB_DESC, "<$gmjob_description");
    my @desc_allines=<GMJOB_DESC>;    
    chomp (my $rsl_string=$desc_allines[0]);      
    if ($rsl_string=~m/"stdin"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"stdin"}=$1;
    }
    if ($rsl_string=~m/"stdout"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"stdout"}=$1;	
    }
    if ($rsl_string=~m/"stderr"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"stderr"}=$1;		
    }
    if ($rsl_string=~m/"count"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"count"}=$1;	
    }
    else {
        $hoh_gmjobs{$ID}{"count"}="1";
    }
    if ($rsl_string=~m/"cputime"\s+=\s+"(\S+)"/i) {
        my $reqcputime_sec=$1;
    	$hoh_gmjobs{$ID}{"reqcputime"}= int $reqcputime_sec/60;	
    }
    if ($rsl_string=~m/"walltime"\s+=\s+"(\S+)"/i) {
        my $reqwalltime_sec=$1;
    	$hoh_gmjobs{$ID}{"reqwalltime"}= int $reqwalltime_sec/60;	
    }    
    # the runtimeenvironment is multivalued, needs further processing at printout
    if ($rsl_string=~m/\("runtimeenvironment"\s+=\s+([^\)]+)/i) {
    	$hoh_gmjobs{$ID}{"runtimeenvironment"}=$1;	
    }
    close GMJOB_DESC;
     
    #read the job.ID.diag file        
    if (-s $gmjob_diag) {
       open (GMJOB_DIAG, "<$gmjob_diag");
       $kerneltime="", $usertime="";
       while ($line = <GMJOB_DIAG>) {						       
         $line=~m/nodename=(\S+)/     and   $hoh_gmjobs{$ID}{"exec_host"}.=$1."+";     
         $line=~m/WallTime=(\d+)/   and   $hoh_gmjobs{$ID}{"WallTime"} = ceil($1/60);
	 $line=~m/exitcode=(\d+)/     and   $hoh_gmjobs{$ID}{"exitcode"} = "exitcode".$1;	
	 $line=~m/UsedMemory=(\d+)/ and   $hoh_gmjobs{$ID}{"UsedMem"} = ceil($1); # in kB
         $line=~m/KernelTime=(\d+)/ and   $kerneltime = $1;			       
         $line=~m/UserTime=(\d+)/   and   $usertime = $1;  			       
       }     									       
       $hoh_gmjobs{$ID}{"CpuTime"} = ceil(($kerneltime+$usertime)/60);
       close GMJOB_DIAG;		       
    }    	 
}


# calculate the diskspace on the sessiondir, %gridareas{$user} is filled if "sessiondir=*",
# otherwise %gridareas{"common"} set to sessiondir

my %gridareas;
my %diskspaces;
if ($config{"sessiondir"} =~ /^\s*\*\s*$/) {
     while ( ($key,$user) = each %users ) { 	 
         next unless ($gridareas{$user} eq "");
	 if ($homedirs{$user} eq "") {
	    &infosys_shared::write_log("$user is not listed in the passwd file");
	    $gridareas{$user} = "";
	    next;
	 }
         $gridareas{$user} = $homedirs{$user}."/.jobs";	 
     }
}
else {
    $gridareas{"common"} = $config{sessiondir};
}  


foreach $user (keys %gridareas) {
    my $gridarea = $gridareas{$user};
    if ( -d "$gridarea") {						 
      # check if on afs 						 
      if ($gridarea =~ /\/afs\//) {					 
    	    $diskspace =`fs listquota $gridarea 2>/dev/null`;	
	    if ($? != 0) {
                &infosys_shared::write_log("Failed checking diskspace for user=$user, gridarea=$gridarea");
		$diskspace = 0;
	    }	
    	    if ($diskspace) {						
    	      $diskspace =~ /\n\S+\s+(\d+)\s+(\d+)\s+\d+%\s+\d+%/;	
    	      $diskspace = int (($1 - $2)/1024);			
    	    } else {							
    	      $diskspace = 0;						
    	    }								
      # "ordinary" disk 						 
      } else {  							 
    	    $diskspace =`df -k -P $gridarea 2>/dev/null`;    	    	
	    if ($? != 0) {                
		&infosys_shared::write_log("Failed checking diskspace for user=$user, gridarea=$gridarea");
		$diskspace = 0;
	    }
    	    if ($diskspace) {						
    	      $diskspace =~ /\n\S+\s+\d+\s+\d+\s+(\d+)\s+\d+/;  	
    	      $diskspace=int $1/1024;					
    	    } else {
    	      $diskspace = 0;						
    	    }
      } 								 
    } else {								 
      $diskspace = 0;							 
      $config{loglevel} and &infosys_shared::write_log("sessiondir $gridarea was not found");   
    }
    $diskspaces{$user} = $diskspace;
}


if ($config{loglevel} == 2) {
   my $runtime = time - $timestamp; 
   &infosys_shared::write_log("GM+diskspace I/O time: $runtime");
}


sub queueldif {
    # The dn of the queue entry 
    print "dn: $config{dn}\n";

    # The objectclasses
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-queue\n";

    # The attributes
    print "nordugrid-queue-name: $config{queue}\n";

    # nordugrid-queue-status
    if ($config{allownew} eq "no") {
        print "nordugrid-queue-status: inactive, grid-manager does not accept new jobs\n";
    }
    elsif (not $frontend_status{grid-manager}) {
    	print "nordugrid-queue-status: inactive, grid-manager is down\n";   
    }
    elsif  (not ($frontend_status{gridftpd}) )  {
       print "nordugrid-queue-status: inactive, gridftp is down\n";  
    }	
    elsif (not ($main::lrms_queue_status eq "active")) {
    	    print "nordugrid-queue-status: inactive\n";
    }
    else {
    	    print "nordugrid-queue-status: active\n";
    }

    # nordugrid-queue-running
    print "nordugrid-queue-running: $main::totalrunning_in_the_queue\n";

    #nordugrid-queue-gridrunning
    print "nordugrid-queue-gridrunning: $main::gridrunning\n";

    # nordugrid-queue-queued
    # This attribute is DEPRECATED
    #print "nordugrid-queue-queued: $main::totalqueued\n";

    #nordugrid-queue-gridqueued
    print "nordugrid-queue-gridqueued: $main::gridqueued\n";
    
    # nordugrid-queue-localqueued
    my $queue_localqueued = $main::totalqueued - $main::gridqueued;
    print "nordugrid-queue-localqueued: $queue_localqueued\n";

    # nordugrid-queue-prelrmsqueued
    if ($queue_prelrmsqueued) {
      print "nordugrid-queue-prelrmsqueued: $queue_prelrmsqueued\n";
    }
    else {
          print "nordugrid-queue-prelrmsqueued: 0\n";
    }
    
    # nordugrid-queue-maxrunning
    $main::queue_info{"max_running"} and print "nordugrid-queue-maxrunning: ", $main::queue_info{"max_running"}, "\n";

    # nordugrid-queue-maxinqueue
    $main::queue_info{"max_queuable"} and print "nordugrid-queue-maxqueuable: ", $main::queue_info{"max_queuable"}, "\n";

    # nordugrid-queue-maxuserrun
    $main::queue_info{"max_user_run"} and print "nordugrid-queue-maxuserrun: ", $main::queue_info{"max_user_run"}, "\n";

    # nordugrid-queue-maxcputime (in minutes)
    if ($main::queue_info{"max.cput"}) {
    	print "nordugrid-queue-maxcputime: ", $main::queue_info{"max.cput"}, "\n";
    }

    # nordugrid-queue-mincput (in minutes)
    if ($main::queue_info{"min.cput"}) {
       print "nordugrid-queue-mincputime: ", $main::queue_info{"min.cput"}, "\n";
    }

    # nordugrid-queue-defaultcputime (in minutes)
    if ($main::queue_info{"default.cput"}) {
    	print "nordugrid-queue-defaultcputime: ", $main::queue_info{"default.cput"}, "\n";
    }

    # nordugrid-queue-schedulingpolicy
    $config{scheduling_policy} and print "nordugrid-queue-schedulingpolicy: $config{scheduling_policy}\n";

    # nordugrid-queue-comment
    $config{comment} and print "nordugrid-queue-comment: $config{comment}\n";

    # nordugrid-queue-totalcpus
    if ($config{queue_node_string}) {
       print "nordugrid-queue-totalcpus: $main::totalcpus\n";
    }
    elsif ( $config{totalcpus}) {
       print "nordugrid-queue-totalcpus: $config{totalcpus}\n";
    }
    elsif ($main::totalcpus) {
        print "nordugrid-queue-totalcpus: $main::totalcpus\n";
    }

    # nordugrid-queue-nodecpu
    my ($modelname,$mhz);
    if ($config{nodecpu}=~/adotf/i) {
       unless (open  CPUINFO, "</proc/cpuinfo") {
          $config{loglevel} and  &infosys_shared::write_log("error in opening /proc/cpuinfo");
          die "Error in opening /proc/cpuinfo";
       }
       while (my $line= <CPUINFO>) {
          if ($line=~/^model name\s+:\s+(.*)$/) {
             $modelname=$1;
          }
          if ($line=~/^cpu MHz\s+:\s+(.*)$/) {
             $mhz=$1;
         }
       }
       close CPUINFO;
       $nodecpu = "$modelname @ $mhz MHz";
       print "nordugrid-queue-nodecpu: $nodecpu\n";
    }
    else {
       $config{nodecpu} and print "nordugrid-queue-nodecpu: $config{nodecpu}\n";
    }

    # nordugrid-queue-nodememory
    $config{nodememory} and print "nordugrid-queue-nodememory: $config{nodememory}\n";
    
    # nordugrid-queue-architecture
    if ($config{architecture}=~/adotf/i) {
       my $tmparch = `uname -m`;
       chomp $tmparch;
       print "nordugrid-queue-architecture: $tmparch\n";
    }
    else {                 
       $config{architecture} and print "nordugrid-queue-architecture: $config{architecture}\n";
    }


    #nordugrid-queue-opsys
    my @opsys =  split /\[separator\]/, $config{opsys};
    foreach my $listentry (@opsys) {
       print "nordugrid-queue-opsys: $listentry\n";
    }

    #nordugrid-queue-benchmark
    my @benchmark = split /\[separator\]/, $config{benchmark};
    foreach my $listentry (@benchmark) {
        my ($bench_name,$bench_value) = split(/\s+/, $listentry);
        print "nordugrid-queue-benchmark: $bench_name \@ $bench_value\n";
    }
    #nordugrid-queue-homogeneity
    if ($config{homogeneity}) {
       $config{homogeneity} = uc $config{homogeneity};
       print "nordugrid-queue-homogeneity: $config{homogeneity}\n";
    }
    
    # Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});
}


sub  jobsldif {
    # The nordugrid-info-group=jobs entry
    print "dn: nordugrid-info-group-name=jobs, $config{dn}\n"; 
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-info-group\n";
    print "nordugrid-info-group-name: jobs\n";
    # Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});


    # The loop goes through the %hoh_gmjobs{$ID} where $ID is the unique number from the GM jobID
    # The LRMS jobID is read from the job.xx.local file and stored as
    # $lrmsjobid=$hoh_gmjobs{$ID}{"localid"}
    # Jobs are sorted in a descending order with respect to their jobsubmission time
    foreach my $ID (sort { $hoh_gmjobs{$b}{"starttime"} <=> $hoh_gmjobs{$a}{"starttime"}}
    	    keys %hoh_gmjobs){
    	 
    	 my $lrmsjobid;
    	 if (defined $main::DUMMY_LRMS_VALUES) {
    	    $lrmsjobid = "dummy13"; 
    	 }
	 else {
	    $lrmsjobid=$hoh_gmjobs{$ID}{"localid"};
	 }
    	 my $nordugrid_globalid="gsiftp://".$config{hostname}.":".$config{gm_port}.$config{gm_mount_point}."/".$ID; 
    	 print "dn: nordugrid-job-globalid=$nordugrid_globalid, nordugrid-info-group-name=jobs, $config{dn}\n";
    	 print "objectclass: Mds\n";
    	 print "objectclass: nordugrid-job\n"; 	  
    	 print "nordugrid-job-globalid: $nordugrid_globalid\n";	  
	 if ($hoh_gmjobs{$ID}{"subject"}) {	 
    	     print "nordugrid-job-globalowner: ", $hoh_gmjobs{$ID}{"subject"}, "\n";
	 } 
	 else {
	     &infosys_shared::write_log("No value for nordugrid-job-globalowner for the job $ID");
	 }      
    	 if ($hoh_gmjobs{$ID}{"jobname"}) {
    	     print "nordugrid-job-jobname: ", $hoh_gmjobs{$ID}{"jobname"}, "\n";
    	 }
	 if ($hoh_gmjobs{$ID}{"starttime"}) {
    	     print "nordugrid-job-submissiontime: ",$hoh_gmjobs{$ID}{"starttime"}, "\n";
	 }
	 if ($config{hostname}) {   		  
    	     print "nordugrid-job-execcluster: ", $config{hostname}, "\n";
	 }
	 if ($config{queue}) {
    	     print "nordugrid-job-execqueue: ",$config{queue}, "\n";
	 }    
    	 if ($hoh_gmjobs{$ID}{"count"}) {
    	     print "nordugrid-job-cpucount: ", $hoh_gmjobs{$ID}{"count"}, "\n";
    	 }
    	 else {
    	     print "nordugrid-job-cpucount: 1\n";
    	 }  
    	 if ($hoh_gmjobs{$ID}{"errors"}) {
    	     print "nordugrid-job-errors: ", $hoh_gmjobs{$ID}{"errors"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"UsedMem"}) {
    	     print "nordugrid-job-usedmem: ", $hoh_gmjobs{$ID}{"UsedMem"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"exitcode"}) {
	     $hoh_gmjobs{$ID}{"exitcode"}=~ s/^exitcode//;
    	     print "nordugrid-job-exitcode: ", $hoh_gmjobs{$ID}{"exitcode"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"cleanuptime"}) {
    	     print "nordugrid-job-sessiondirerasetime: ",$hoh_gmjobs{$ID}{"cleanuptime"}, "\n";
    	 } 
    	 if ($hoh_gmjobs{$ID}{"stdin"}) {
    	     print "nordugrid-job-stdin: ",$hoh_gmjobs{$ID}{"stdin"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"stdout"}) {
    	     print "nordugrid-job-stdout: ",$hoh_gmjobs{$ID}{"stdout"}, "\n";
    	 } 
    	 if ($hoh_gmjobs{$ID}{"stderr"}) {
    	     print "nordugrid-job-stderr: ",$hoh_gmjobs{$ID}{"stderr"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"gmlog"}) {
    	     print "nordugrid-job-gmlog: ",$hoh_gmjobs{$ID}{"gmlog"}, "\n";
    	 }     
    	 if (my $tmpruntimestring = $hoh_gmjobs{$ID}{"runtimeenvironment"}) {	       
    	     while( $tmpruntimestring =~ m/"(\S+)"/g ) {
    		print "nordugrid-job-runtimeenvironment: ",$1, "\n";	
    	     }  		    
    	 }
    	 if ($hoh_gmjobs{$ID}{"clientname"}) {
    	     print "nordugrid-job-submissionui: ",$hoh_gmjobs{$ID}{"clientname"}, "\n";
    	 }		     
    	 if ($hoh_gmjobs{$ID}{"clientsoftware"}) {
    	     print "nordugrid-job-clientsoftware: ",$hoh_gmjobs{$ID}{"clientsoftware"}, "\n";
    	 } 
    	 if ($hoh_gmjobs{$ID}{"delegexpiretime"}) {
    	     print "nordugrid-job-proxyexpirationtime: ",$hoh_gmjobs{$ID}{"delegexpiretime"}, "\n";
    	 }
	 if ( $hoh_gmjobs{$ID}{"status"} eq "FAILED" )  {
	    if ( $hoh_gmjobs{$ID}{"failedstate"} ) {
	    	print "nordugrid-job-rerunable: ",$hoh_gmjobs{$ID}{"failedstate"}, "\n";
	    }
	    else {
	    	print "nordugrid-job-rerunable: none\n";
	    }
	 }
    	 if ($hoh_gmjobs{$ID}{"comment"}) {
    	     print "nordugrid-job-comment: ",$hoh_gmjobs{$ID}{"comment"}, "\n";
    	 }
	 
    	 #LRMS-dependent attributes taken from LRMS when the job is in state 'INLRMS'
    	 if ($hoh_gmjobs{$ID}{"status"} eq "INLRMS") {
    	     #nordugrid-job-status
    	     # take care of the GM latency, check if the job is in LRMS
    	     # according to both GM and LRMS, GM might think the job 
    	     # is still in LRMS while the job have already left LRMS		     
    	     if ($main::hoh_lrmsjobs{"$lrmsjobid"}{"job_state"}) {   
    		  print "nordugrid-job-status: INLRMS:",     
    		  $main::hoh_lrmsjobs{"$lrmsjobid"}{"job_state"}, "\n";
    	     }
    	     else {	
    		  print "nordugrid-job-status: EXECUTED\n";
    	     }      
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"rank"}) {  
    		  print "nordugrid-job-queuerank: ", $main::hoh_lrmsjobs{$lrmsjobid}{"rank"}, "\n"; 
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"used.mem"}) {
    		 print "nordugrid-job-usedmem: ", $main::hoh_lrmsjobs{$lrmsjobid}{"used.mem"}, "\n";
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"used.walltime"}) {  
    		print "nordugrid-job-usedwalltime: ", $main::hoh_lrmsjobs{$lrmsjobid}{"used.walltime"}, "\n" ;
    	     }  	    
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"used.cput"}) {
    		 print "nordugrid-job-usedcputime: ",$main::hoh_lrmsjobs{$lrmsjobid}{"used.cput"}, "\n"; 
    	     }       
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"req.cput"}) {       
    		 print "nordugrid-job-reqcputime: ", $main::hoh_lrmsjobs{$lrmsjobid}{"req.cput"},"\n"; 
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"req.walltime"}) {       
    		 print "nordugrid-job-reqwalltime: ", $main::hoh_lrmsjobs{$lrmsjobid}{"req.walltime"},"\n"; 
    	     }	     
    	     #nordugrid-job-executionnodes
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"exec_host"}) {
    		 my @exec_hosts = split('\+',$main::hoh_lrmsjobs{$lrmsjobid}{"exec_host"});
    		 foreach my $listentry (@exec_hosts) {
    		     print "nordugrid-job-executionnodes: $listentry\n";
    		 }
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"comment"}) {       
    		 print "nordugrid-job-comment: LRMS:", $main::hoh_lrmsjobs{$lrmsjobid}{"comment"}, "\n";
    	     }    
    	 }     
    	 #LRMS-dependent attributes taken from GM when the job has passed the 'INLRMS' state
    	 else {  
    	     print "nordugrid-job-status: ", $hoh_gmjobs{$ID}{"status"}, "\n";
    	     if ($hoh_gmjobs{$ID}{"completiontime"}) {
    		 print "nordugrid-job-completiontime: ", $hoh_gmjobs{$ID}{"completiontime"}, "\n";
    	     }	     
    	     if ($hoh_gmjobs{$ID}{"WallTime"}) {
    		 print "nordugrid-job-usedwalltime: ", $hoh_gmjobs{$ID}{"WallTime"}, "\n";
    	     }
	     else {
	         print "nordugrid-job-usedwalltime: 0\n";
	     }
    	     if ($hoh_gmjobs{$ID}{"CpuTime"})  {   
    		 print "nordugrid-job-usedcputime: ", $hoh_gmjobs{$ID}{"CpuTime"}, "\n";
    	     }
	     else {
	         print "nordugrid-job-usedcputime: 0\n";
	     }
    	     if ($hoh_gmjobs{$ID}{"reqcputime"})  {   
    	         print "nordugrid-job-reqcputime: ", $hoh_gmjobs{$ID}{"reqcputime"}, "\n";
    	     }
    	     if ($hoh_gmjobs{$ID}{"reqwalltime"})  {   
    		 print "nordugrid-job-reqwalltime: ", $hoh_gmjobs{$ID}{"reqwalltime"}, "\n";
    	     }	     
    	     #nordugrid-job-executionnodes
    	     if ( $hoh_gmjobs{$ID}{"exec_host"}) { 
    		 my @exec_hosts = split('\+',$hoh_gmjobs{$ID}{"exec_host"});
    		 foreach my $listentry (@exec_hosts) {
    		    print "nordugrid-job-executionnodes: $listentry\n";
    		 }
    	     }  	 
    	 }	 
    	 # Mds-validfrom/to
    	 &infosys_shared::mds_valid($config{ttl});
    }
}


sub usersldif {
    # The nordugrid-info-group=users entry 
    print "dn: nordugrid-info-group-name=users, $config{dn}\n";
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-info-group\n";
    print "nordugrid-info-group-name: users\n";
    # Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});


    # create the user entries from the LRMS-authorized members of the %users hash
    my $usernumber = 0;
    foreach my $key (sort sort_by_cn keys %users) {

       # check if there is an "acl list" of authorized LRMS users and if the mapping of the 
       # grid user is on this list
       if ( @main::acl_users and !(grep /^$users{$key}$/, @main::acl_users)) {
          #print "we skip $users{$key} \n";
    	  next
       }
       
       # check if there is an "acl list" of authorized LRMS groups and if the mapping of the
       # grid user belongs to one of those authorized Unix groups.
       if ( @main::acl_groups ) {      
          #determine the unix group of the mapped unix ID
	  my $unix_group = `id -nG $users{$key} 2>/dev/null`;	  
	  if ($? != 0) {
             $config{loglevel} and   &infosys_shared::write_log("Failed to determine user group of $users{$key}");
          }
	  chomp $unix_group;
	  unless ( grep /^$unix_group$/, @main::acl_groups ) {	  
	     #print "skip userID: $users{$key}, usergroup: $unix_group \n";                   
    	     next;
	  }
       }
       

       #nordugrid-authuser-name= CN from the SN  + unique number 
       $key =~ m/\/CN=([^\/]+)(\/Email)?/;
       my $cn = $1;
       $usernumber++;
       print "dn: nordugrid-authuser-name=", $cn, "...", $usernumber, ", nordugrid-info-group-name=users, ", $config{dn}, "\n";
       print "objectclass: Mds\n";
       print "objectclass: nordugrid-authuser\n";
       print "nordugrid-authuser-name: ", $cn, "...", $usernumber, "\n";
       print "nordugrid-authuser-sn: $key\n";
       
       #nordugrid-authuser-diskspace
       if ($config{"sessiondir"} =~ /^\s*\*\s*$/) {
    	  print "nordugrid-authuser-diskspace: $diskspaces{$users{$key}}\n";
       }
       else {	   
    	  print "nordugrid-authuser-diskspace: ", $diskspaces{"common"},"\n";
       }   
       
       $username = $users{$key};       
       #nordugrid-authuser-freecpus       
       if ( $queue_pendingprelrms ) {
          print "nordugrid-authuser-freecpus: 0\n";
       }
       elsif ($main::users_freecpus{$username}) {
          print "nordugrid-authuser-freecpus: ", $main::users_freecpus{$username}, "\n";
       }
       else {
          print "nordugrid-authuser-freecpus: 0\n";
       }          
       #nordugrid-authuser-queuelength
       my  $authuser_queuelength = $gm_queued{$key} + $main::users_jobs_queued{$username};
       if ($authuser_queuelength) {
          print "nordugrid-authuser-queuelength: $authuser_queuelength\n";   
       }
       else {
          print "nordugrid-authuser-queuelength: 0\n";
       }
	  
       #Mds-validfrom/to
       &infosys_shared::mds_valid($config{ttl});
    }
}


sub sort_by_cn{
    $a =~ m/\/CN=([^\/]+)(\/Email)?/;
    $cn_a=$1;
    $b =~ m/\/CN=([^\/]+)(\/Email)?/;
    $cn_b=$1;	
    $cn_a cmp $cn_b;
}

1;
