#include "qstring.h"

#if QT_VERSION >= 0x030100

#include "qtextedit.h"
#include <iostream>
#include "xRSLHighlighter.h"

using namespace std;

xRSLHighlighter::xRSLHighlighter(QTextEdit* textEdit) : QSyntaxHighlighter(textEdit)
{ 
	red.setRgb(255, 0, 0);
	blue.setRgb(0, 0, 255);
	black.setRgb(0, 0, 0);

	string keywords[] = {"executable", "arguments", "inputfiles", "executables", "cache", "outputfiles", "cputime", "memory", "disk", "runtimeenvironment", "middleware", "stdin", "stdout", "stderr", "join", "gmlog", "jobname", "ftpthreads", "cluster", "queue", "startime", "lifetime", "notify", "replicacollection", "rerun", "architecture", "nodeaccess", "dryrun", "rsl_substitution", "count"};
	unsigned int keywordssize = sizeof(keywords)/sizeof(*keywords);

  //                ftpthreads, count, rerun, cputime, memory, disk (numbers)
  //                nodeaccess (inbound, outbound)

	xrslattributes.assign(keywords, keywords+keywordssize);
}


xRSLHighlighter::~xRSLHighlighter() { }


int xRSLHighlighter::highlightParagraph(const QString& paragraph, int endStateOfLastPara) {
	unsigned int begin = 0;
	unsigned int middle = 0;
	unsigned int parenthesis = 0;
  
	string line = paragraph;
	string attributetyped;

	setFormat(0, line.size(), black);

	for (unsigned int i=0; i<line.size(); i++) {
    
		if (line[i]=='(') {
			begin = i+1;
			parenthesis++;
			continue;
		}

		if (begin>0 && line[i]=='=') {
			attributetyped = line.substr(begin, i-begin);
			unsigned int j;
			for (j=0; j<attributetyped.size(); j++)
				attributetyped[j] = tolower(attributetyped[j]);
			for (j=0; j<xrslattributes.size(); j++) {
				if (attributetyped==xrslattributes[j])
					setFormat(begin, i-begin, red);
			}

			begin = 0;
			middle = i+1;
			continue;
		}

		if (middle>0 && ((attributetyped=="dryrun") || (attributetyped=="join") || (attributetyped=="cache"))) {
			if (i==middle+2 && line.substr(middle, 2)=="no")
				setFormat(middle, 2, blue);
			if (i==middle+3 && line.substr(middle, 3)=="yes")
				setFormat( middle, 3, blue );
			continue;
		}

		if (middle>0 && attributetyped=="nodeaccess") {
			if (i==middle+7 && line.substr(middle, 7)=="inbound")
				setFormat(middle, 7, blue);
			if (i==middle+8 && line.substr(middle, 8)=="outbound")
				setFormat(middle, 8, blue);
			continue;
		}

		if (middle>0 && line[i]!='"' && line[i]!=' ' && line[i]!=')') {
			setFormat(i, 1, blue);
			continue;
		}

		if (middle>0 && line[i]==')') {
			parenthesis--;
			if (parenthesis==0)
				middle = 0;
		}
	}

	return endStateOfLastPara;
}

#endif
