#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <arc/common.h>

#include <cstdlib>

#include "qapplication.h"
#include "qpixmap.h"
#include "MainWindow.h"

#if QT_VERSION >= 0x030200  // >= 3.2
#include "qsplashscreen.h"
#endif

int main(int argc, char** argv)
{
	QApplication app( argc, argv );
	
#if QT_VERSION >= 0x030200
	string arc_location = GetEnv("ARC_LOCATION");
	if (arc_location.empty()) arc_location = DEFAULT_NORDUGRID_LOCATION;
	string splashpicture = arc_location + "/share/splashpicture.png";

	QPixmap pixmap(splashpicture.c_str());
	QSplashScreen* splash;
	if (!pixmap.isNull()) {
		splash = new QSplashScreen(pixmap);
		splash->show();
		splash->message("Fetching cluster-list");
	}
#endif

	MainWindow theMainWindow(0, "Main Window");
	theMainWindow.resize(720, 512);
	app.setMainWidget(&theMainWindow);
	theMainWindow.show();

#if QT_VERSION >= 0x030200
	if (!pixmap.isNull()) {
		splash->finish(&theMainWindow);
		delete splash;
	}
#endif

	return app.exec();
}
