#include "ProxyInitDialog.h"

#include "qspinbox.h"
#include "qlineedit.h"
#include "qlayout.h"
#include "qpushbutton.h"
#include "qevent.h"
#include "qlabel.h"

#include <iostream>
#include <cstdlib>
#include "unistd.h"

using namespace std;

ProxyInitDialog::ProxyInitDialog(QWidget* parent, const char* name, bool modal) : QDialog(parent, name, modal) {

	dialogLayout = new QGridLayout(this, 4, 3, 8);

	durationBox = new QSpinBox(1, 200, 1, this);
	durationBox->setValue(12);
	lineEdit = new QLineEdit(this);
	lineEdit->setEchoMode(QLineEdit::Password);

	okButton = new QPushButton("OK", this);
	cancelButton = new QPushButton("Cancel", this);

	enterPassPhrase = new QLabel("Enter pass-phrase:", this);
	validity = new QLabel("Proxy validity:", this);
	hours = new QLabel("hours", this);

	connect(cancelButton, SIGNAL(pressed()), this, SLOT(reject()));
	connect(okButton, SIGNAL(pressed()), this, SLOT(createNewProxy()));

	dialogLayout->addMultiCellWidget(enterPassPhrase, 1, 1, 0, 2);
	dialogLayout->addWidget(validity, 0, 0);
	dialogLayout->addWidget(hours, 0, 2);
	dialogLayout->addWidget(durationBox, 0, 1);
	dialogLayout->addMultiCellWidget(lineEdit, 2, 2, 0, 2);
	dialogLayout->addWidget(okButton, 3, 1);
	dialogLayout->addWidget(cancelButton, 3, 2);
}


ProxyInitDialog::~ProxyInitDialog() { }


void ProxyInitDialog::keyPressEvent(QKeyEvent* e) {
	if (e->key()==Qt::Key_Return || e->key()==Qt::Key_Enter) createNewProxy();
	if (e->key()==Qt::Key_Escape) reject();
}


void ProxyInitDialog::createNewProxy() {
	QString hours = durationBox->text();
	QString passphrase = lineEdit->text();
  
	char* tmpfile = (char*)malloc(17);
	strcpy(tmpfile, "/tmp/pass.XXXXXX");

	int fd;
	if ((fd = mkstemp(tmpfile))==-1) {
		cout << "Could not create temporary file" << endl;
		reject();
	}
	write(fd, (const char*)passphrase, passphrase.length());
	::close( fd );

	QString systemcall = "grid-proxy-init -q -valid " + hours + ":0 -pwstdin < " + tmpfile;
	system(systemcall);
	
	unlink(tmpfile);
	free(tmpfile);
	accept();
}
