#include <iostream>
#include <fstream>

#include <arc/certificate.h>

#include "qstring.h"
#include "qwidget.h"
#include "qpopupmenu.h"
#include "qmenubar.h"
#include "qfiledialog.h"
#include "qtabwidget.h"
#include "qapplication.h"
#include "qstatusbar.h"
#include "qlabel.h"
#include "qmessagebox.h"

#include "MainWindow.h"
#include "JobSubWindow.h"
#include "JobStatWindow.h"
#include "JobConstructWindow.h"
#include "ProxyInitDialog.h"

using namespace std;

MainWindow::MainWindow(QWidget* parent, const char* name) : QMainWindow(parent, name)
{
	jobWindow = new JobSubWindow(this, "jobWindow");
	jobStats = new JobStatWindow(this, "jobStats");
	jobConstruct = new JobConstructWindow(this, "jobConstruct");

	tabs = new QTabWidget(this);
	tabs->setTabShape(QTabWidget::Triangular);
	tabs->addTab(jobConstruct, "Job-construction");
	tabs->addTab(jobWindow, "Job-submission");
	tabs->addTab(jobStats, "Job-status");
	tabs->show();
	tabs->setCurrentPage(1);
	setCentralWidget(tabs);

	QPopupMenu *fileMenu = new QPopupMenu(this);
	fileMenu->insertItem("Load xrsl", this, SLOT(load()), CTRL+Key_L);  
	fileMenu->insertItem("Save xrsl", this, SLOT(save()), CTRL+Key_S);
	fileMenu->insertSeparator();
	fileMenu->insertItem("Quit", qApp, SLOT(quit()), CTRL+Key_Q);

	QPopupMenu *subMenu = new QPopupMenu(this);
	subMenu->insertItem("Submit xrsl", jobWindow, SLOT(submit()), CTRL+Key_X);
	subMenu->insertItem("Update cluster-list", jobWindow, SLOT(submit()), CTRL+Key_U);  

	QPopupMenu *proxyMenu = new QPopupMenu(this);
	proxyMenu->insertItem("Proxy info", this, SLOT(proxyInfo()), CTRL+Key_P);
	proxyMenu->insertItem( "Renew proxy", this, SLOT(renewProxy()), CTRL+Key_R);
	menuBar()->insertItem("&File", fileMenu);
	menuBar()->insertItem("&Actions", subMenu);
	menuBar()->insertItem("&Proxy-utilities", proxyMenu);

	updateStatusBar();

	connect(tabs, SIGNAL(currentChanged(QWidget*)), this, SLOT(tabChanged(QWidget*)));
	connect(jobWindow, SIGNAL(statusmessage(const QString&, int)), statusBar(), SLOT(message(const QString&, int)));
	connect(statusBar(), SIGNAL(messageChanged(const QString&)), this, SLOT(updateStatusBar(const QString&)));
}


MainWindow::~MainWindow( ) { }


void MainWindow::load() {
	QString filename = QFileDialog::getOpenFileName(".", "Xrsl-files (*.xrsl)", this, "load xrsl-file", "Choose a file");

	if (filename.isEmpty()) {
		statusBar()->message("No filename given...", 2000);
		return;
	}

	ifstream file((const char*)filename);
	if (!file) {
		statusBar()->message("Could not open file...", 2000);
		return;
	}

	string filecontents, line;
	while (getline(file, line)) {
		filecontents += line + '\n';
	}
	filecontents.resize(filecontents.size()-1);
  
	jobWindow->setTextArea(QString(filecontents.c_str()));

	char* cutfilename = strrchr((const char*)filename, '/');
	cutfilename++;

	string statusline("Read file ");
	statusline += cutfilename;

	statusBar()->message(QString(statusline.c_str()), 2000);
	return;
}


void MainWindow::save() {
	QString filename = QFileDialog::getSaveFileName(".", "Xrsl-files (*.xrsl)", this, "save xrsl-file", "Choose a file");

	if (filename.isEmpty()) {
		statusBar()->message("No filename given...", 2000);
		return;
	}

	ofstream file((const char*)filename);
	if (!file) {
		statusBar()->message("File does not exist...", 2000);
		return;
	}

	file << jobWindow->returnxRSL();

	char* cutfilename = strrchr((const char*)filename, '/');
	cutfilename++;
	string statusline("Saved file ");
	statusline += cutfilename;
	statusBar()->message(QString(statusline.c_str()), 2000);
	return;
}


void MainWindow::tabChanged(QWidget* newtab) {
	if (strcmp(newtab->name(), "jobWindow")==0) jobWindow->updateTab();
	if (strcmp(newtab->name(), "jobStats")==0) jobStats->updateTab();
}


void MainWindow::updateStatusBar(const QString& message) {
	if (!message.isEmpty()) return;
	// don't fill the message-field with info if it's already filled
	statusBar()->message(getProxyValidity().c_str());
}


void MainWindow::renewProxy() {
	ProxyInitDialog proxyDialog(this, "Renewing proxy", true);
	proxyDialog.exec();
	updateStatusBar();
}


void MainWindow::proxyInfo() {
	Certificate user;
	string text("Certificate subject name: " + user.GetSN() + "\n" + getProxyValidity());
	QMessageBox::information(this, "Proxy Info", text.c_str(), "OK");
}


string MainWindow::getProxyValidity() {
	Certificate proxy(PROXY);
	string validity("Proxy valid for: ");
	validity += proxy.ValidFor();
	return validity;
}

