#ifndef JOBSUBWINDOW_H
#define JOBSUBWINDOW_H

#include "qwidget.h"
#include <string>

#if QT_VERSION >= 300
class QTextEdit;
#else
class QMultiLineEdit;
#endif

class QFont;
class QPushButton;
class QGridLayout;
class QListBox;
class QLabel;
class QListBoxItem;
class QVGroupBox;

using namespace std;

class JobSubWindow : public QWidget
{
	Q_OBJECT

 public:
	JobSubWindow(QWidget* parent = 0, const char* name = 0);
	~JobSubWindow();

	void setTextArea(QString);
	void updateTab();
	QString returnxRSL();

 public slots:
	void submit();
	void updateClusterlist();
	void showInfo(QListBoxItem*);
	void validatexRSL();

 signals:
	void statusmessage(const QString&, int);

 private:
#if QT_VERSION >= 300
	QTextEdit* textEditor;
#else
	QMultiLineEdit* textEditor;
#endif
	QFont* textFont;
	QPushButton* submitButton;
	QPushButton* validateButton;
	QPushButton* expandButton;
	QPushButton* clusterSelect;
	QPushButton* updateClusters;
	QGridLayout* screenLayout;
	QListBox* clusterView;
	QLabel* xRSLLabel;
	QLabel* clusterLabel;
	QLabel* xRSLCommands;
	QLabel* clusterOp;
	QVGroupBox* group;

	void getLine(string&, string&);
	bool isxRSLvalid();
};

#endif
