#include <iostream>
#include <vector>
#include <sstream>

#include <arc/xrsl.h>
#include <arc/mdsdiscovery.h>
#include <arc/mdsquery.h>
#include <arc/notify.h>

#include "qfont.h"
#include "qpushbutton.h"
#include "qlayout.h"
#include "qlistbox.h"
#include "qlabel.h"
#include "qmessagebox.h"
#include "qstring.h"
#include "qvgroupbox.h"

#include "JobSubWindow.h"

#if QT_VERSION >= 300
#include "qtextedit.h"
#else
#include "qmultilineedit.h"
#endif

#if QT_VERSION >= 0x030100
#include "xRSLHighlighter.h"
#endif

using namespace std;

JobSubWindow::JobSubWindow(QWidget* parent, const char* name) : QWidget(parent, name) { 
	textFont = new QFont("System", 11, QFont::Normal);

	// textEditor column
#if QT_VERSION >= 300
	textEditor = new QTextEdit(this);
	textEditor->setWrapPolicy(QTextEdit::Anywhere); 
	textEditor->setTextFormat(Qt::PlainText);
# if QT_VERSION >= 0x030100
	xRSLHighlighter* xRSLHighlight = new xRSLHighlighter(textEditor);
# endif
#else
	textEditor = new QMultiLineEdit(this);
	textEditor->setWrapPolicy(QMultiLineEdit::Anywhere); 
#endif
	textEditor->setFont(*textFont);

	xRSLLabel = new QLabel("xRSL window", this);

	// operations column
	group = new QVGroupBox("Operations", this);

	xRSLCommands = new QLabel("xRSL operations", group);

	submitButton = new QPushButton("Submit xRSL", group);
	connect(submitButton, SIGNAL(pressed()), this, SLOT(submit()));

	expandButton = new QPushButton("Expand xRSL", group);

	validateButton = new QPushButton("Validate xRSL", group);
	connect(validateButton, SIGNAL(pressed()), this, SLOT(validatexRSL()));

	group->addSpace(15);

	clusterOp = new QLabel("Cluster operations", group);

	updateClusters = new QPushButton("Update cluster-list", group);
	connect(updateClusters, SIGNAL(pressed()), this, SLOT(updateClusterlist()));

	// clusterView column
	clusterView = new QListBox(this);
	clusterView->setSelectionMode(QListBox::Multi);
	connect(clusterView, SIGNAL(doubleClicked(QListBoxItem*)), this, SLOT(showInfo(QListBoxItem*)));

	clusterSelect = new QPushButton("Invert chosen clusters", group);
	connect(clusterSelect, SIGNAL(pressed()), clusterView, SLOT(invertSelection()));

	clusterLabel = new QLabel("Cluster list", this);

	screenLayout = new QGridLayout(this, 2, 3);
 	screenLayout->setColStretch(0, 2);
	screenLayout->setColStretch(1, 5);
	screenLayout->setColStretch(2, 2);
	screenLayout->setSpacing(4);
	screenLayout->setMargin(4);

	screenLayout->addWidget(group, 1, 0);

	screenLayout->addWidget(xRSLLabel, 0, 1);
	screenLayout->addMultiCellWidget(textEditor, 1, 7, 1, 1);

	screenLayout->addWidget(clusterLabel, 0, 2);
	screenLayout->addMultiCellWidget(clusterView, 1, 7, 2, 2);

	updateClusterlist();
}


JobSubWindow::~JobSubWindow() { }


void JobSubWindow::updateTab( ) {
    //    updateClusterlist();
}


void JobSubWindow::setTextArea(QString text) {
	textEditor->clear();
	textEditor->setText(text);
}


void JobSubWindow::submit() {
	if (isxRSLvalid()==false) {
		emit(statusmessage("xRSL not valid...", 2000));
		return;
	}

	vector<string> chosenClusters;
	for (int i=0; i<clusterView->numRows(); i++) {
		if (clusterView->isSelected(i))
			chosenClusters.push_back((const char*)clusterView->text(i));
    }

	// submit job dropping output into stream
	// Not implemented yet
	bool submitstatus = true;

	if( submitstatus==0 ) {
		emit(statusmessage("Job successfully submitted...", 2000));
	} else {
		emit(statusmessage("Job not submitted...", 2000));
	}
}


void JobSubWindow::showInfo(QListBoxItem* item) {

	URL url("ldap://" + item->text() + ":2135/o=grid/mds-vo-name=local");
	Cluster cluster = GetClusterInfo(url);

	QString caption("Information about " + item->text());
	string outputinfo(""); // add info here
	QMessageBox::information(NULL, caption, outputinfo.c_str());
}


void JobSubWindow::updateClusterlist( ) {

	SetNotifyLevel(FATAL);
	list<URL> urls = GetResources();
	clusterView->clear();

	list<URL>::iterator it;
	for (it = urls.begin(); it != urls.end(); it++)
		clusterView->insertItem(QString(it->Host().c_str()));
	clusterView->sort();
}


void JobSubWindow::getLine(string& s, string& line) {
  unsigned int i = s.find ('\n');
  if (i == string::npos) return;

  line = s.substr(0, i);
  s = s.substr(i+1);
}


QString JobSubWindow::returnxRSL() {
	return textEditor->text();
}


void JobSubWindow::validatexRSL() {
	if (!isxRSLvalid()) {
		emit(statusmessage("xRSL is not valid...", 2000));
	} else {
		emit(statusmessage("xRSL is valid...", 2000));
	}
}


bool JobSubWindow::isxRSLvalid() {
	QString xrslstring = textEditor->text();
	try {
		Xrsl xrsl((const char*)xrslstring);
	} catch(XrslError e) {
		return false;
	}

	return true;
}
