#ifndef JOBSTATWINDOW_H
#define JOBSTATWINDOW_H

#include "qwidget.h"

class QLabel;
class QListView;
class QGridLayout;
class QPushButton;

class JobStatWindow : public QWidget
{
	Q_OBJECT

 public:
	JobStatWindow(QWidget* parent = 0, const char* name = 0);
	~JobStatWindow();

	void updateTab();

 signals:
	void linemessage(const QString&);
 
 public slots:
	void updateJobs(); 
	void selectAllJobs();
	void syncJobs();
	void renewJobs();
  
 private:
	QGridLayout* screenLayout;
	QListView* listView;
	QPushButton* allJobsButton;
	QPushButton* renewJobsButton;
	QPushButton* syncJobsButton;
	QPushButton* invertJobsButton;
	QPushButton* updateJobsButton;
	QLabel* jobLabel;

	void readJobs();
};

#endif
