#include <vector>
#include <string>
#include <fstream>
#include <iostream>
#include <cstdlib>

#include <arc/common.h>
#include <arc/joblist.h>

#include "JobStatWindow.h"

#include "qlistview.h"
#include "qlayout.h"
#include "qpushbutton.h"
#include "qlabel.h"

using namespace std;

JobStatWindow::JobStatWindow(QWidget* parent, const char* name) : QWidget(parent, name) {
	listView = new QListView(this);
	listView->addColumn("JobIDs");
	listView->addColumn("JobStatus");
	listView->addColumn("JobNames");
	listView->setColumnWidthMode(1, QListView::Maximum);
	//  listView->setResizeMode( QListView::LastColumn );
	listView->setSelectionMode(QListView::Multi);

	invertJobsButton = new QPushButton("Invert selected jobs", this);
	connect(invertJobsButton, SIGNAL(pressed()), listView, SLOT(invertSelection()));

	allJobsButton = new QPushButton("Select all jobs", this);
	connect(allJobsButton, SIGNAL(pressed()), this, SLOT(selectAllJobs()));

	updateJobsButton = new QPushButton("Update selected jobs", this);
	connect(updateJobsButton, SIGNAL(pressed()), this, SLOT(updateJobs()));

	renewJobsButton = new QPushButton("Renew proxy for selected jobs", this);
	connect(renewJobsButton, SIGNAL(pressed()), this, SLOT(renewJobs()));

	syncJobsButton = new QPushButton("Synchronize joblist with IS", this);
	connect(syncJobsButton, SIGNAL(pressed()), this, SLOT(syncJobs()));

	jobLabel = new QLabel("Job window", this);

	screenLayout = new QGridLayout(this, 4, 3, 10);
	screenLayout->addMultiCellWidget(listView, 1, 1, 0, 2);
	screenLayout->addWidget(invertJobsButton, 2, 0);
	screenLayout->addWidget(allJobsButton, 3, 0);
	screenLayout->addWidget(renewJobsButton, 2, 2);
	screenLayout->addWidget(syncJobsButton, 3, 2);
	screenLayout->addWidget(updateJobsButton, 2, 1);
	screenLayout->addWidget(jobLabel, 0, 0);
}


JobStatWindow::~JobStatWindow() { }


void JobStatWindow::updateTab() {
	readJobs();
}


void JobStatWindow::readJobs() {
	QListViewItem* item;

	map<string, string> joblist = GetJobIDs();
  	map<string, string>::iterator it;
	for (it = joblist.begin(); it != joblist.end(); it++) {
		item = new QListViewItem(listView, it->first.c_str(), "UNKNOWN", it->second.c_str());
	}
	return;
}


void JobStatWindow::selectAllJobs() {
	listView->selectAll(true);
}


void JobStatWindow::updateJobs( ) { }

void JobStatWindow::renewJobs( ) { }

void JobStatWindow::syncJobs( ) { }
