#ifndef __STD_H__
#define __STD_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* #define _POSIX_C_SOURCE 2 */
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 199309L
#ifndef _BSD_SOURCE
#define _BSD_SOURCE
#endif
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#ifndef __USE_POSIX
#define __USE_POSIX
#endif
#include <features.h>
/* On some systems __USE_XOPEN is defined here and causes crypt()
   of unistd.h and openssl confict */
#undef __USE_XOPEN

/* On AIX this define changes so many things it is better to always have it */
#ifdef _AIX
#ifndef _LARGE_FILES
#define _LARGE_FILES
#endif
#endif

#include <pwd.h>
#include <grp.h>
#include <dirent.h>

/* using some non-ansi functions with -ansi compilation */
#ifdef __STRICT_ANSI__
#undef __STRICT_ANSI__
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define __STRICT_ANSI__
#else
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#endif
#include <stdint.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/vfs.h>

#include <unistd.h>

#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <limits.h>

#ifdef __HPLX
#undef __USE_POSIX
#undef __USE_MISC
#include <netdb.h>
#include <time.h>
#include <sys/time.h>
#define __USE_MISC
#define __USE_POSIX
#else
#include <time.h>
#include <sys/time.h>
#endif

#ifdef __CYGWIN__
#define _POSIX_REALTIME_SIGNALS
#define __rtems__
#include <signal.h>
#undef __rtems__
#undef _POSIX_REALTIME_SIGNALS
#define _BROKEN_SIGNAL_HANDLER_DEFINITION_
#define readdir_r(dir,entry,result) { \
  struct dirent *d; \
  if((d=readdir(dir)) == NULL) { \
   (*(result))=NULL; \
    -1; \
  } \
  else { \
    memcpy(entry,d,sizeof(struct dirent)); \
    (*(result))=(entry); \
    0; \
  }; \
}
#define getgrgid_r(gid,resultbuf,buf,buflen,result) { \
  struct group *g; \
  if((g=getgrgid(gid)) == NULL) { \
   (*(result))=NULL; \
    -1; \
  } \
  else { \
    memcpy(resultbuf,g,sizeof(struct group)); \
    (*(result))=(resultbuf); \
    0; \
  }; \
}
#define strtoq strtoll
#define strtouq strtoull
#endif

#ifndef HAVE_PTHREAD_YIELD
#define pthread_yield sched_yield
#endif

#ifndef DEFAULT_ARC_LOCATION
#define DEFAULT_ARC_LOCATION "/opt/nordugrid"
#endif

#ifndef GLOBUS_IO_VERSION
#define GLOBUS_IO_VERSION 4
#endif

#include <signal.h>

#ifdef __cplusplus

/* Internal implementation of timegm() */
#ifndef HAVE_TIMEGM
#include <arc/datetime.h>
#endif

#if defined __GNUC__ && __GNUC__ >= 3

#define istream_readline(__f,__s,__n) {      \
   __f.get(__s,__n,__f.widen('\n'));         \
   if(__f.fail()) __f.clear();               \
   __f.ignore(std::numeric_limits<std::streamsize>::max(), __f.widen('\n')); \
}

#else

#define istream_readline(__f,__s,__n) {      \
   __f.get(__s,__n,'\n');         \
   if(__f.fail()) __f.clear();               \
   __f.ignore(INT_MAX,'\n'); \
}

#endif

#endif

#endif  /* __STD_H_ */
