#include "../std.h"
#include <string>
#include <dlfcn.h>
#include <stdio.h>
#include <fstream>

#include "../misc/escaped.h"
#include "../misc/log_time.h"
#include "../misc/proxy.h"

#include <gssapi.h>
#define ALLOW_EMPTY_CREDENTIALS 1
extern "C" {
#define extern typedef
#define lcas_init (*lcas_init_t)
#define lcas_get_fabric_authorization (*lcas_get_fabric_authorization_t)
#define lcas_term (*lcas_term_t)
#include <lcas.h>
#undef lcas_init
#undef extern
};

static std::string lcas_db_file_old;
static std::string lcas_dir_old;

void set_lcas_env(const std::string& lcas_db_file,const std::string& lcas_dir) {
  char* s;
}

static void usage(void) {
  std::cout<<"Executes EDG LCAS plugins."<<std::endl;
  std::cout<<"Returns 0 if authorization passed, 1 - if not passed, -1 - if failure occured"<<std::endl;
  std::cout<<"Usage:"<<std::endl;
  std::cout<<"   lcas credentials description [library [db [directory]]]"<<std::endl;
  std::cout<<"     credentials - path to file with credentials to authorize"<<std::endl;
  std::cout<<"     description - path to file with job description"<<std::endl;
  std::cout<<"     library - path to LCAS library (full or relative to LCAS directory)"<<std::endl;
  std::cout<<"     db - path to LCAS DB file (full or relative to LCAS directory)"<<std::endl;
  std::cout<<"     directory - LCAS directory"<<std::endl;
}

int main(int argc,char* argv[]) {
  if(argc < 2) {
    usage();
    odlog(ERROR)<<"Missing name of credentials file"<<std::endl;
    return -1;
  };
  if(argc < 3) {
    odlog(ERROR)<<"Missing name of job description file"<<std::endl;
    return -1;
  };
  std::string lcas_cred = argv[1];
  std::string lcas_job = argv[2];
  std::string lcas_library = argc>=4?argv[3]:"";
  std::string lcas_db_file = argc>=5?argv[4]:"";
  std::string lcas_dir = argc>=6?argv[5]:"";
  if(lcas_library == "*") lcas_library="";
  if(lcas_db_file == "*") lcas_db_file="";
  if(lcas_dir == "*") lcas_dir="";
  if(lcas_library.length() == 0) {
    lcas_library="libedg_lcas.so";
  } else {
    if((lcas_library[0] != '/') && (lcas_library[0] != '.')) {
      if(lcas_dir.length() != 0) {
        lcas_library=lcas_dir+"/"+lcas_library;
      };
    };
  };
  if(lcas_db_file.length() != 0) {
    if((lcas_db_file[0] != '/') && (lcas_db_file[0] != '.')) {
      if(lcas_dir.length() != 0) {
        lcas_db_file=lcas_dir+"/"+lcas_db_file;
      };
    };
  };
  gss_cred_id_t cred = read_proxy(lcas_cred.c_str());
  if(cred == NULL) {
    odlog(ERROR)<<"Can't read credentials from file "<<lcas_cred<<std::endl;
    return -1;
  };
  std::string job;
  {
  std::ifstream ijob(lcas_job.c_str());
  if(!ijob.is_open()) {
    odlog(ERROR)<<"Can't read job description from file "<<lcas_job<<std::endl;
    return -1;
  };
  ijob>>job;
  };
  if(lcas_db_file.length() != 0) setenv("LCAS_DB_FILE",lcas_db_file.c_str(),1);
  if(lcas_dir.length() != 0) setenv("LCAS_DIR",lcas_dir.c_str(),1);
  void* lcas_handle = dlopen(lcas_library.c_str(),RTLD_NOW | RTLD_GLOBAL);
  if(lcas_handle == NULL) {
    odlog(ERROR)<<"Can't load LCAS library "<<lcas_library<<std::endl;
    return -1;
  };
  lcas_init_t lcas_init_f =
        (lcas_init_t)dlsym(lcas_handle,"lcas_init");
  lcas_get_fabric_authorization_t lcas_get_fabric_authorization_f =
        (lcas_get_fabric_authorization_t)dlsym(lcas_handle,
                                              "lcas_get_fabric_authorization");
  lcas_term_t lcas_term_f =
        (lcas_term_t)dlsym(lcas_handle,"lcas_term");
  if((lcas_init_f == NULL) ||
     (lcas_get_fabric_authorization_f == NULL) ||
     (lcas_term_f == NULL)) {
    dlclose(lcas_handle);
    odlog(ERROR)<<"Can't find LCAS functions in a library "<<lcas_library<<std::endl;
    return -1;
  };
  FILE* lcas_log = fdopen(STDERR_FILENO,"a");
  if((*lcas_init_f)(lcas_log) != 0) {
    dlclose(lcas_handle);
    odlog(ERROR)<<"Failed to initialize LCAS"<<std::endl;
    return -1;
  };
  if((*lcas_get_fabric_authorization_f)("",cred,(char*)(job.c_str())) != 0) {
    if((*lcas_term_f)() == 0) dlclose(lcas_handle);
    odlog(INFO)<<"LCAS does not match"<<std::endl;
    return 1;
  };
  if((*lcas_term_f)() == 0) dlclose(lcas_handle);
  return 0;
}

// Hack
#include <arc/notify.h>

Notify* Notify::getNotifier(void) { return NULL; }

void Notify::SetOutStream(std::ostream&) { };

void Notify::SetNotifyLevel(const NotifyLevel) { };

void Notify::SetNotifyTimeStamp(bool) { };

