#include "../std.h"

#include <string>
#include <list>

#include "../rsl/parse_rsl.h"
#include "../transfer/url_map.h"
#include "../misc/proxy.h"
#include "../datamove/datapoint.h"
#include "../datamove/datahandle.h"
#include "../misc/condition.h"
#include "../misc/log_time.h"

CondSimple cond;

class lfn_t {
 public:
  const char* lfn;
  bool done;
  bool failed;
  lfn_t(const char* l):lfn(l),done(false),failed(false) { };
};

void* check_url(void *arg) {
  lfn_t* lfn = (lfn_t*)arg;
  std::cerr<<lfn->lfn<<std::endl;
  DataPoint source(lfn->lfn);
  if(!source) {
    std::cerr<<"Failed to acquire source: "<<source<<std::endl;
    lfn->failed=true; lfn->done=true; cond.signal();
    return NULL;
  };
  if(!source.meta_resolve(true,UrlMap())) {
    std::cerr<<"Failed to resolve "<<source<<std::endl;
    lfn->failed=true; lfn->done=true; cond.signal();
    return NULL;
  };
  source.tries(1);
  DataHandle source_h(&source);
  // TODO. Run every URL in separate thread.
  // TODO. Do only connection (optionally)
  for(;source.have_location();) {
    if(source_h.check()) break;
    source.next_location();
  };
  if(!source.have_location()) {
    std::cerr<<"Failed to check "<<source<<std::endl;
    lfn->failed=true; lfn->done=true; cond.signal();
    return NULL;
  };
  lfn->done=true; cond.signal();
  return NULL;
}

static void usage(void) {
  olog<<"Usage: inputcheck [-h] [-d debug_level] RSL_file [proxy_file]"<<
        std::endl;
}

int main(int argc,char* argv[]) {
  unsigned int n;
  LogTime::Level(FATAL);
  LogTime::Active(true);
  while((n=getopt(argc,argv,"hd:")) != -1) {
    switch(n) {
      case ':': { olog<<"Missing argument\n"; return -1; };
      case '?': { olog<<"Unrecognized option\n"; return -1; };
      case '.': { return -1; };
      case 'h': {
        usage();
        return 0;
      };
      case 'd': {
        char* p;
        long debug_ = strtol(optarg,&p,10);
        if(((*p) != 0) || (debug_<0)) {
          olog<<"Improper debug level '"<<optarg<<"'"<<std::endl;
          return -1;
        };
        LogTime::Level(NotifyLevel(FATAL+debug_));
      }; break;
      default: { olog<<"Option processing error\n"; return -1; };
    };
  };
  if(optind >= argc) {
    usage();
    return -1;
  };
  std::string rsl = argv[optind];
  const char* proxy = NULL;
  if((optind+1) < argc) proxy=argv[optind+1];
  JobLocalDescription job;

  if(!parse_rsl(rsl,job)) return 1;

  if(proxy) {
    setenv("X509_USER_PROXY",proxy,1);
    setenv("X509_USER_CERT",proxy,1);
    setenv("X509_USER_KEY",proxy,1);
  };
  prepare_proxy();
  
  std::list<FileData>::iterator file;
  bool has_lfns = false;
  std::list<lfn_t*> lfns;
  for(file=job.inputdata.begin();file!=job.inputdata.end();++file) {
    if(file->has_lfn()) {
      pthread_t thread;
      pthread_attr_t thread_attr;
      lfn_t* lfn = new lfn_t(file->lfn.c_str());
      lfns.push_back(lfn);
      pthread_attr_init(&thread_attr);
      pthread_attr_setdetachstate(&thread_attr,PTHREAD_CREATE_DETACHED);
      pthread_create(&thread,&thread_attr,&check_url,lfn);
      has_lfns=true;
    };
  };
  for(;has_lfns;) {
    cond.wait();
    has_lfns=false;
    for(std::list<lfn_t*>::iterator l = lfns.begin();l!=lfns.end();++l) {
      if((*l)->done) {
        if((*l)->failed) {
          remove_proxy();
          exit(1);
        };
      } else {
        has_lfns=true; 
      };
    };
  };
  remove_proxy();
  exit(0);
}
/* Gross hack */
#include "../run/run_commands.h"

RunElement* RunCommands::fork(const JobUser& user,const char* cmdname) {
  return NULL;
}

#include "../run/run_commands.h"

int RunCommands::wait(RunElement* re,int timeout,char* cmdname) {
  return -1;
}

int mkdir(JobUser& user,const char *pathname, mode_t mode) { return -1; }
int open(JobUser& user,const char *pathname, int flags) { return -1; }
int open(JobUser& user,const char *pathname, int flags, mode_t mode) { return -1; }
int creat(JobUser& user,const char *pathname, mode_t mode)  { return -1; }
int stat(JobUser& user,const char *file_name, struct stat *buf) { return -1; }
int lstat(JobUser& user,const char *file_name, struct stat *buf) { return -1; }
int delete_all_files(JobUser& user,const std::string &dir_base,
     std::list<FileData> &files,bool excl,bool lfn_exs,bool lfn_mis) { return -1; }
int remove(JobUser& user,const char *pathname)  { return -1; }
int rmdir(JobUser& user,const char *pathname) { return -1; }
int unlink(JobUser& user,const char *pathname) { return -1; }
bool fix_file_permissions(JobUser& user,const std::string &fname,bool executable) { return false; }

