#ifdef __cplusplus

#include <iostream>

#include <arc/error.h>
#include "../userinterface/ngui.h"

/*
class ARCLibError : public std::exception {
    public:
        ARCLibError(std::string message) {
            this->message = message;
        };
        virtual ~ARCLibError() throw() {};
        virtual const char* what() const throw() {
            return message.c_str();
        };
    private:
        std::string message;
};
*/

class ARCCLIError : public ARCLibError {
    public:
        ARCCLIError (std::string message) : ARCLibError(message) {};
};

class ARCCLIDataError: public ARCCLIError {
 public:
  ARCCLIDataError (std::string message) : ARCCLIError(message) {};
};

// These will go into arclib ina future

void arcacl(
         const std::string& file_url,
         const std::string& command,
         int recursion = 0,
         int timeout = 0);

void arcregister (
         const std::string& source_url_,
         const std::string& destination_url_,
         bool secure = false,
         bool passive = true,
         bool force_meta = false,
         int timeout = 0);

void arccp (
         const std::string& source_url_,
         const std::string& destination_url_,
         bool secure = false,
         bool passive = true,
         bool force_meta = false,
         int recursion = 0,
         int tries = 0,
         bool verbose = false,
         int timeout = 0);

void arcls(
         const std::string& dir_url_,
         bool show_details = false,
         bool show_urls = false,
         int recursion = 0,
         int timeout = 0);

void arcrm(
         const std::string& file_url,
         bool errcont = false,
         int timeout = 0);

void arctransfer(
         const std::string& destination,
         std::list<std::string>& sources,
         int timeout = 0);

#endif

