#include "std.h"
#include "datamove/datapoint.h"
#include "datamove/datahandle.h"
#include "datamove/datamove.h"
#include "https/client/client.h"
#include "misc/globus_modules.h"
#include "misc/inttostring.h"
#include "misc/log_time.h"
#include "https/se/file_soapH.h"
extern SOAP_NMAC struct Namespace file_soap_namespaces[];

#include "ngdata.h"

static bool simplels(const std::string& dir_url_,int recursion,int timeout,std::list<std::string>& dir_urls,std::list<std::string>& file_urls) {
  std::string dir_url(dir_url_.c_str());
  DataPoint url(dir_url.c_str());
  if(!url) return false;
  std::list<DataPoint::FileInfo> files;
  DataHandle h(&url);
  h.secure(false);
  if(!h.list_files(files,true)) return false;
  for(std::list<DataPoint::FileInfo>::iterator i = files.begin();
                                               i!=files.end();++i) {
    std::string suburl = dir_url;
    if(suburl[suburl.length()-1] != '/') suburl+="/";
    suburl+=i->name;
    if(i->type == DataPoint::FileInfo::file_type_dir) {
      dir_urls.push_back(suburl);				      
    } else {
      file_urls.push_back(suburl);
    };
    if(recursion > 0) {
      if(i->type == DataPoint::FileInfo::file_type_dir) {
        if(!simplels(suburl,recursion-1,timeout,dir_urls,file_urls)) return false;
      };
    };
  };
  return true;
}

// !!! TODO: pass ACL in string instead of stdin

void arcacl(const std::string& file_url,
            const std::string& command,
            int recursion,
            int timeout) {
  LogTime::Active(false);
  bool verbose = false;

  LogTime::Level(GetNotifyLevel());

  if((command!="get") && (command!="put") && (command!="set")) {
    throw ARCCLIDataError("Only get and put commands are supported");
  };
  if(strncmp(file_url.c_str(),"gsiftp://",9) == 0) {
    // GACL-enabled GridFTP server
    std::string gacl_url(file_url.c_str());
    int n = gacl_url.rfind('/');
    if(n < 9) {
      throw ARCCLIDataError("URL contains neither path nor hostname");
    };
    bool is_dir = false;
    if(n == (gacl_url.length()-1)) {
      is_dir=true;
      gacl_url.insert(n+1,".gacl"); // directory
    } else {
      gacl_url.insert(n+1,".gacl-"); // file or directory itself
    };
    DataPoint url(gacl_url.c_str());
    if(!url) throw ARCCLIDataError("Unsupported URL");
    DataPoint tmp("-");
    DataMove mover;
    mover.secure(false);
    mover.passive(true);
    mover.verbose(verbose);
    mover.checks(false);
    DataCache cache;
    if(command=="get") {
      std::string fail_desc;
      if(mover.Transfer(url,tmp,cache,UrlMap(),&fail_desc)!=DataMove::success){
        if(fail_desc.length()) {
          throw ARCCLIDataError("ACL transfer FAILED: "+fail_desc);
        };
        throw ARCCLIDataError("ACL transfer FAILED");
      };
    } else if((command=="put") || (command=="set")) {
      std::string fail_desc;
      if(mover.Transfer(tmp,url,cache,UrlMap(),&fail_desc)!=DataMove::success){
        if(fail_desc.length()) {
          throw ARCCLIDataError("ACL transfer FAILED: "+fail_desc);
        };
        throw ARCCLIDataError("ACL transfer FAILED");
      };
      if(recursion > 0) {
        std::list<std::string> dir_urls;
        std::list<std::string> file_urls;
        if(!simplels(file_url,recursion,timeout,dir_urls,file_urls)) 
              throw ARCCLIDataError("Recursive list FAILED");
        // Make empty file. TODO - transfer from buffer
        std::string fileurl("file:///tmp/acl.XXXXXX");
        int fd = ::mkstemp(((char*)fileurl.c_str())+7);
        if (fd==-1) throw ARCCLIDataError("Could not create temporary file");
        ::close(fd);
        for(std::list<std::string>::iterator i = file_urls.end();;) {
          if(i == file_urls.begin()) break;
          --i;
          std::string gacl_url = *i;
          std::string::size_type n = gacl_url.rfind('/');
          if(n == std::string::npos) continue;
          gacl_url.insert(n+1,".gacl-");
          DataPoint tmp(fileurl.c_str());
          DataPoint url(gacl_url.c_str());
          if(!url) continue;
          if(mover.Transfer(tmp,url,cache,UrlMap(),&fail_desc) != 
                                                      DataMove::success){
            ::unlink(((char*)fileurl.c_str())+7);
            if(fail_desc.length()) {
              throw ARCCLIDataError("ACL transfer FAILED: "+fail_desc);
            };
            throw ARCCLIDataError("ACL transfer FAILED");
          };
        };
        for(std::list<std::string>::iterator i = dir_urls.end();;) {
          if(i == dir_urls.begin()) break;
          --i;
          std::string gacl_url = *i;
          gacl_url+="/"; gacl_url+=".gacl";
          {
          DataPoint tmp(fileurl.c_str());
          DataPoint url(gacl_url.c_str());
          if(!url) continue;
          if(mover.Transfer(tmp,url,cache,UrlMap(),&fail_desc) !=
                                                      DataMove::success){
            ::unlink(((char*)fileurl.c_str())+7);
            if(fail_desc.length()) {
              throw ARCCLIDataError("ACL transfer FAILED: "+fail_desc);
            };
            throw ARCCLIDataError("ACL transfer FAILED");
          };
          };
          gacl_url=*i;
          std::string::size_type n = gacl_url.rfind('/');
          if(n == std::string::npos) continue;
          gacl_url.insert(n+1,".gacl-");
          {
          DataPoint tmp(fileurl.c_str());
          DataPoint url(gacl_url.c_str());
          if(!url) continue;
          if(mover.Transfer(tmp,url,cache,UrlMap(),&fail_desc) !=
                                                      DataMove::success){
            ::unlink(((char*)fileurl.c_str())+7);
            if(fail_desc.length()) {
              throw ARCCLIDataError("ACL transfer FAILED: "+fail_desc);
            };
            throw ARCCLIDataError("ACL transfer FAILED");
          };
          };
        };
        ::unlink(((char*)fileurl.c_str())+7);
      };
    };
  } else if(strncmp(file_url.c_str(),"se://",5) == 0) {
    GlobusModuleIO io_mod;
    std::string service_url = file_url;
    std::string::size_type n;
    n=service_url.find('?');
    if(n != std::string::npos) service_url[n]='/';
    service_url.replace(0,2,"httpg");
    odlog(INFO)<<"Talking to SOAP service at "<<service_url<<std::endl;
    struct soap soap;
    HTTP_ClientSOAP s(service_url.c_str(),&soap);
    soap.namespaces=file_soap_namespaces;
    if(command=="get") {
      if(s.connect() != 0) {
        throw ARCCLIDataError("Failed to connect to "+service_url);
      };
      ns__aclResponse rr;
      int soap_err = SOAP_OK;
      if((soap_err=soap_call_ns__acl(&soap,s.SOAP_URL(),"acl",NULL,rr))
                                                             != SOAP_OK) {
        throw ARCCLIDataError("Failed to execute remote soap call 'acl' at "
                              +service_url);
      };
      if(rr.error_code != 0) {
        if(rr.error_description) {
          throw ARCCLIDataError(std::string("Failed (")
                  +inttostring(rr.error_code)+" - "+rr.error_description
                  +") to get acl at "+service_url);
        };
        throw ARCCLIDataError(std::string("Failed (")
                +inttostring(rr.error_code)
                +") to get acl at "+service_url);
      };
      if(rr.acl == NULL) {
        throw ARCCLIDataError("No acl returned by service at "+service_url);
      };
      std::cout<<rr.acl;
    } else if((command=="put") || (command=="set")) {
      if(s.connect() != 0) {
        throw ARCCLIDataError("Failed to connect to "+service_url);
      };
      std::string acl("");
      char buf[256];
      for(;;) {
        int l = ::read(0,buf,sizeof(buf)-1);
        if(l==0) break;
        if(l==-1) throw ARCCLIDataError("Failed to read stdin");
        buf[l]=0; acl+=buf;
      };
      ns__aclResponse rr;
      int soap_err = SOAP_OK;
      if((soap_err=soap_call_ns__acl(&soap,s.SOAP_URL(),"acl",
                                     (char*)acl.c_str(),rr)) != SOAP_OK) {
        throw ARCCLIDataError("Failed to execute remote soap call 'acl' at "
                              +service_url);
      };
      if(rr.error_code != 0) {
        if(rr.error_description) {
          throw ARCCLIDataError(std::string("Failed (")
                  +inttostring(rr.error_code)+" - "+rr.error_description
                  +") to get acl at "+service_url);
        };
        throw ARCCLIDataError(std::string("Failed (")
                +inttostring(rr.error_code)
                +") to get acl at "+service_url);
      };
    };
  } else if(strncmp(file_url.c_str(),"srm://",6) == 0) {
    throw ARCCLIDataError("SRM is not supported yet");
  } else if(strncmp(file_url.c_str(),"srm://",6) == 0) {
    throw ARCCLIDataError("Fireman is not supported yet");
  } else {
    throw ARCCLIDataError("This kind of URL is not supported");
  };
  if(verbose) olog<<"Operation succeeded"<<std::endl;
  return;
}

extern "C"
int ngaclxx (
    const std::string& file_url,
    const std::string& command,
    int verbosity_level,
    int timeout
) {
  try {
    SetNotifyLevel(NotifyLevel(FATAL+verbosity_level));
    arcacl(file_url,command,0,timeout);
  } catch(ARCCLIDataError& e) {
    return -1;
  } catch(std::exception& e) {
    return -1;
  };
  return 0;
}

