#include "../std.h"
#include <string>
#include <iostream>
#include "../jobs/users.h"
#include "inttostring.h"
#include "substitute.h"
#include "../config/environment.h"
#include "escaped.h"
/*
  %R - session root
  %r - list of session roots
  %C - control dir
  %c - list of control dirs
  %U - username
  %u - userid
  %g - groupid
  %H - home dir
  %Q - default queue
  %L - default lrms
  %W - installation path
  %G - globus path
*/

/*
bool substitute(string& param,const JobUser& user) {
  std::string::size_type curpos=0;
  for(;;) {
    if(curpos >= param.length()) break;
    std::string::size_type pos = param.find('%',curpos);
    if(pos == string::npos) break;
    pos++; if(pos>=param.length()) break;
    if(param[pos] == '%') { curpos=pos+1; continue; };
    string to_put;
    switch(param[pos]) {
      case 'R': to_put=user.SessionRoot(); break;
      case 'C': to_put=user.ControlDir(); break;
      case 'U': to_put=user.UnixName(); break;
      case 'H': to_put=user.Home(); break;
      case 'Q': to_put=user.DefaultQueue(); break;
      case 'L': to_put=user.DefaultLRMS(); break;
      case 'u': to_put=inttostring(user.get_uid()); break;
      case 'g': to_put=inttostring(user.get_gid()); break;
      case 'W': to_put=nordugrid_loc; break;
      case 'G': to_put=globus_loc; break;
      default: to_put=param.substr(pos-1,2);
    };
    curpos=pos+1+(to_put.length() - 2);
    param.replace(pos-1,2,to_put);
  };
  return true;
}

bool substitute(string& param,JobUsers& users) {
  string session_roots = "";
  string control_dirs = "";
  for(JobUsers::iterator i = users.begin();i!=users.end();++i) {
    string tmp_s;
    tmp_s = i->SessionRoot();
    make_escaped_string(tmp_s);
//    tmp_s="\""+tmp_s+"\" ";
    tmp_s=tmp_s+" ";
    if(session_roots.find(tmp_s) == string::npos) session_roots+=tmp_s;
    tmp_s = i->ControlDir();
    make_escaped_string(tmp_s);
//    tmp_s="\""+tmp_s+"\" ";
    tmp_s=tmp_s+" ";
    if(control_dirs.find(tmp_s) == string::npos) control_dirs+=tmp_s;
  }; 
  std::string::size_type curpos=0;
  for(;;) {
    if(curpos >= param.length()) break;
    std::string::size_type pos = param.find('%',curpos);
    if(pos == string::npos) break;
    pos++; if(pos>=param.length()) break;
    if(param[pos] == '%') { curpos=pos+1; continue; };
    string to_put;
    switch(param[pos]) {
      case 'r': to_put=session_roots; break;
      case 'c': to_put=control_dirs; break;
      default: to_put=param.substr(pos-1,2);
    };
    curpos=pos+1+(to_put.length() - 2);
    param.replace(pos-1,2,to_put);
  };
  return true;
}
*/
