#ifndef __SAFEPOINTER_H__
#define __SAFEPOINTER_H__

#include "condition.h"

template <typename T> class SafePointer {
 private:
  T* object;
  CounterSimple* counter;
  void release(void) {
    if(object) {
      if(counter->dec() == 0) { delete object; delete counter; };
      object=NULL; counter=NULL;
    };
  };
  void assign(T* o) {
    counter = new CounterSimple;
    object=o; counter->inc();
  };
 public:
  SafePointer(void):object(NULL),counter(NULL) { };
  SafePointer(T* o):object(NULL),counter(NULL) {
    assign(o);
  };
  void operator=(T* o) {
    if(o != object) {
      release();
      if(o) assign(o);
    };
  };
  void operator=(const SafePointer<T>& p) {
    if(p.object != object) {
      release();
      if(p.object) {
        counter=p.counter; object=p.object;
        counter->inc();
      };
    };
  };
  T& operator*(void) const { return *object; };
  T* operator->(void) const { return object; };
  operator bool(void) const { return (object!=NULL); };
};

#endif
