#include "../std.h"

#include <openssl/x509.h>

#include "proxy.h"

int prepare_proxy(void) {
  char* proxy_file = NULL;
  char* proxy_file_tmp = NULL;
  struct stat stx;
  int h = -1;
  off_t len;
  char* buf = NULL;
  off_t l,ll;
  int res=-1;

  if(getuid() == 0) { /* create temporary proxy */
    proxy_file=getenv("X509_USER_PROXY");
    if(proxy_file==NULL) goto exit;
    h=open(proxy_file,O_RDONLY);
    if(h==-1) goto exit;
    if((len=lseek(h,0,SEEK_END))==-1) goto exit;
    lseek(h,0,SEEK_SET);
    buf=malloc(len);
    if(buf==NULL) goto exit;
    for(l=0;l<len;) {
      ll=read(h,buf+l,len-l);
      if(ll==-1) goto exit;
      if(ll==0) break;
      l+=ll;
    };
    close(h); h=-1; len=l;
    proxy_file_tmp=malloc(strlen(proxy_file)+5);
    if(proxy_file_tmp==NULL) goto exit;
    strcpy(proxy_file_tmp,proxy_file); strcat(proxy_file_tmp,".tmp");
    h=open(proxy_file_tmp,O_WRONLY | O_CREAT,S_IRUSR | S_IWUSR);
    if(h==-1) goto exit;
    (void)chmod(proxy_file_tmp,S_IRUSR | S_IWUSR);
    for(l=0;l<len;) {
      ll=write(h,buf+l,len-l);
      if(ll==1) goto exit;
      l+=ll;
    };
    close(h); h=-1; 
    setenv("X509_USER_PROXY",proxy_file_tmp,1);
  };
  res=0;
 exit:
  if(proxy_file_tmp) free (proxy_file_tmp);
  if(buf) free(buf);
  if(h!=-1) close(h);
  return res;
}

int remove_proxy(void) {
  char* proxy_file = NULL;
  if(getuid() == 0) {
    proxy_file=getenv("X509_USER_PROXY");
    if(proxy_file == NULL) return 0;
    remove(proxy_file);
  };
  return 0;
}

int renew_proxy(const char* old_proxy,const char* new_proxy) {
  int h = -1;
  off_t len,l,ll;
  char* buf = NULL;
  char* proxy_file_tmp = NULL;
  struct stat st;
  int res = -1;

  h=open(new_proxy,O_RDONLY);
  if(h==-1) {
    fprintf(stderr,"Can't open new proxy: %s\n",new_proxy);
    goto exit;
  };
  if((len=lseek(h,0,SEEK_END))==-1) goto exit;
  lseek(h,0,SEEK_SET);
  if((buf=malloc(len)) == NULL) {
    fprintf(stderr,"Out of memory\n");
    goto exit;
  };
  for(l=0;l<len;) {
    ll=read(h,buf+l,len-l);
    if(ll==-1) {
      fprintf(stderr,"Can't read new proxy: %s\n",new_proxy);
      goto exit;
    };
    if(ll==0) break;
    l+=ll;
  };
  close(h); h=-1; len=l;
  proxy_file_tmp=malloc(strlen(old_proxy)+7);
  if(proxy_file_tmp==NULL) {
    fprintf(stderr,"Out of memory\n");
    goto exit;
  };
  strcpy(proxy_file_tmp,old_proxy); strcat(proxy_file_tmp,".renew");
  remove(proxy_file_tmp);
  h=open(proxy_file_tmp,O_WRONLY | O_CREAT | O_EXCL,S_IRUSR | S_IWUSR);
  if(h==-1) {
    fprintf(stderr,"Can't create temporary proxy: %s\n",proxy_file_tmp);
    goto exit;
  };
  (void)chmod(proxy_file_tmp,S_IRUSR | S_IWUSR);
  for(l=0;l<len;) {
    ll=write(h,buf+l,len-l);
    if(ll==-1) {
      fprintf(stderr,"Can't write temporary proxy: %s\n",proxy_file_tmp);
      goto exit;
    };
    l+=ll;
  };
  fchown(h,st.st_uid,st.st_gid);
  close(h); h=-1;
  if(stat(old_proxy,&st) == 0) {
    if(remove(old_proxy) != 0) {
      fprintf(stderr,"Can't remove proxy: %s\n",old_proxy);
      goto exit;
    };
  };
  if(rename(proxy_file_tmp,old_proxy) != 0) {
    fprintf(stderr,"Can't rename temporary proxy: %s\n",proxy_file_tmp);
    goto exit;
  };
  res=0;
 exit:
  if(h!=-1) close(h);
  if(buf) free(buf);
  if(proxy_file_tmp) { remove(proxy_file_tmp); free (proxy_file_tmp); };
  return res;
}

char* write_proxy(gss_cred_id_t cred) {
  char* proxy_fname = NULL;
  OM_uint32 major_status = 0;
  OM_uint32 minor_status = 0;
  gss_buffer_desc deleg_proxy_filename;
  if(cred == GSS_C_NO_CREDENTIAL) return NULL;
  major_status = gss_export_cred(&minor_status,
                                 cred,
                                 NULL,
                                 1,
                                 &deleg_proxy_filename);
  if (major_status == GSS_S_COMPLETE) {
    char * cp;
    cp = strchr((char *)deleg_proxy_filename.value, '=');
    if(cp != NULL) {
      cp++;
      proxy_fname=strdup(cp);
    };
    free(deleg_proxy_filename.value);
  };
  return proxy_fname;
}

gss_cred_id_t read_proxy(const char* filename) {
  gss_cred_id_t cred = NULL;
  OM_uint32 major_status;
  OM_uint32 minor_status;
  gss_buffer_desc proxy_filename;

  if(filename == NULL) return NULL;
  proxy_filename.value=malloc(strlen(filename)+32);
  strcpy(proxy_filename.value,"X509_USER_PROXY=");
  strcat(proxy_filename.value,(void*)filename);
  proxy_filename.length=strlen(proxy_filename.value);
  major_status = gss_import_cred(&minor_status,
                                 &cred,
                                 NULL,
                                 1,
                                 &proxy_filename,
                                 GSS_C_INDEFINITE,
                                 NULL);
  if (major_status != GSS_S_COMPLETE) {
    cred=NULL;
  };
  free(proxy_filename.value);
  return cred;
}
 
void free_proxy(gss_cred_id_t cred) {
  OM_uint32 minor_status;
  if(cred == NULL) return;
  gss_release_cred(&minor_status,&cred);
}

/* Following code is taken from prima_authz_module of VO Privelege Project */
char* write_cert_chain(const gss_ctx_id_t gss_context) {
  /* Globus OID for the remote parties certificate chain */
  gss_OID_desc cert_chain_oid =
        {11, "\x2b\x06\x01\x04\x01\x9b\x50\x01\x01\x01\x08"};
  gss_buffer_set_t client_cert_chain = NULL;
  OM_uint32 major_status;
  OM_uint32 minor_status;
  int certs_num = 0;
  int n,n_;
  STACK_OF(X509) *cert_chain = NULL;
  BIO* bio = NULL;
  char* fname = NULL;

  major_status = gss_inquire_sec_context_by_oid(&minor_status,
                                                gss_context,
                                                &cert_chain_oid,
                                                &client_cert_chain);
  if(major_status != GSS_S_COMPLETE) {
    return NULL;
  };
  certs_num = client_cert_chain->count;
  if(certs_num <= 0) goto err_exit;
  if((cert_chain = sk_X509_new_null()) == NULL) goto err_exit;
  for(n=0,n_=0;n<certs_num;n++) {
    unsigned char* value = client_cert_chain->elements[n].value;
    int length = client_cert_chain->elements[n].length;
    X509* cert = d2i_X509(NULL,&value,length);
    if(cert) {
      if(cert) sk_X509_insert(cert_chain,cert,n_++);
      /* {
      X509_NAME *name = X509_get_subject_name(cert);
      char buf[256]; buf[0]=0;
      if(name) {
        X509_NAME_oneline(name,buf,sizeof(buf));
        fprintf(stderr,"Name: %s\n",buf);
      } else {
        fprintf(stderr,"Name: none\n");
      };
      }; */
    } else {
      /*
      fprintf(stderr,"No cert\n");
      */
    };
  };
  /* TODO: do not store in file - pass directly to calling function */
  /* Make temporary file */
  {
    int h;
    char* prefix = "x509.";
    char* tmp = getenv("TMP");
    if(tmp == NULL) tmp="/tmp";
    fname = (char*)malloc(strlen(tmp)+1+strlen(prefix)+6+1);
    if(fname == NULL) goto err_exit;
    strcpy(fname,tmp);
    strcat(fname,"/"); strcat(fname,prefix); strcat(fname,"XXXXXX");
    if((h=mkstemp(fname)) == -1) {
      free(fname); fname=NULL; goto err_exit;
    };
    fchmod(h,S_IRUSR | S_IWUSR); close(h);
    if((bio=BIO_new_file(fname,"w")) == NULL) goto err_exit;
  };
  for(n=0;n<n_;++n) {
    X509* cert=sk_X509_value(cert_chain,n);
    if(cert) {
      if(!PEM_write_bio_X509(bio,cert))  {
        BIO_free(bio); goto err_exit;
      };
    };
  };
  goto exit;
err_exit:
  if(fname) {
    unlink(fname); free(fname); fname=NULL;
  };
exit:
  if(cert_chain) sk_X509_pop_free(cert_chain,X509_free);
  if(bio) BIO_free(bio);
  if(client_cert_chain) gss_release_buffer_set(&minor_status,&client_cert_chain);
  return fname;
}

