#include "../std.h"

#ifdef HAVE_MYPROXY_H

extern "C" {
#include <myproxy.h>
}

#include "../../arclib/arc/url.h"
#include "../../arclib/arc/certificate.h"

#include "myproxy_proxy.h"


/* Due to a way myproxy API is implemented, this function is not thread safe */
bool myproxy_renew(const char* old_proxy_file,const char* new_proxy_file,const char* myproxy_server) {
  if(!myproxy_server) return false;
  if(!old_proxy_file) return false;
  if(!new_proxy_file) return false;

  myproxy_socket_attrs_t *socket_attrs    = NULL;
  myproxy_request_t      *client_request  = NULL;
  myproxy_response_t     *server_response = NULL;
  bool res = false;

  try { 
    URL url(myproxy_server);
    if(url.Protocol() != "myproxy") return false;
    Certificate proxy(PROXY,std::string(old_proxy_file));

    myproxy_log_use_stream (stderr);
    myproxy_debug_set_level(1);

    if(!(socket_attrs=
      (myproxy_socket_attrs_t*)malloc(sizeof(*socket_attrs)))) goto error;
    memset(socket_attrs, 0, sizeof(*socket_attrs));

    if(!(client_request=
      (myproxy_request_t*)malloc(sizeof(*client_request)))) goto error;
    memset(client_request, 0, sizeof(*client_request));

    if(!(server_response=
      (myproxy_response_t*)malloc(sizeof(*server_response)))) goto error;
    memset(server_response, 0, sizeof(*server_response));

    myproxy_set_delegation_defaults(socket_attrs,client_request);
    socket_attrs->pshost=strdup(url.Host().c_str());
    if((socket_attrs->psport=url.Port()) == -1) {
      socket_attrs->psport = MYPROXY_SERVER_PORT;
    };
  
    client_request->authzcreds=(char*)old_proxy_file;
    std::map<std::string,std::string>::const_iterator m;
    m=url.Options().find("username");
    if(m != url.Options().end()) {
      client_request->username=strdup(m->second.c_str());
    } else {
      client_request->username=strdup(proxy.GetSN().c_str());
    };
    m=url.Options().find("credname");
    if(m != url.Options().end()) {
      client_request->credname=strdup(m->second.c_str());
    } else {
      client_request->credname=NULL;
    };
    client_request->proxy_lifetime = 60*60*12;
    client_request->passphrase[0]=0;

    /* Connect to server. */
    if(myproxy_init_client(socket_attrs) < 0) {
      fprintf(stderr, "Error: %s\n", verror_get_string()); goto error;
    };
    /* Get new proxy */
#if MYPROXY_VERSION_MAJOR < 2
    if(myproxy_get_delegation(socket_attrs,client_request,
                              server_response,(char*)new_proxy_file)!=0) {
#else
    if(myproxy_get_delegation(socket_attrs,client_request,
        (char*)old_proxy_file,server_response,(char*)new_proxy_file)!=0) {
#endif
      fprintf(stderr, "Failed to receive a proxy: %s\n", verror_get_string());
      goto error;
    };
    res=true;
  }
  catch (URLError e) { goto error; }
  catch (CertificateError e) { goto error; };
error:
  if(client_request) {
    if(client_request->credname) {
      free(client_request->credname);
      client_request->credname=NULL;
    };
  };
  myproxy_free(socket_attrs, client_request, server_response);
  verror_clear();
  return res;
}

#endif

