#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "mkdir_recursive.h"

static int mkdir_force(const char* path,mode_t mode);

int mkdir_recursive(const char* base_path,const char* path,mode_t mode,uid_t uid,gid_t gid) {
  char* name;
  char* name_start;
  char* name_end;
  int l;
  if(!base_path) base_path="";
  name = malloc(strlen(base_path)+strlen(path)+2);
  if(!name) return -1;
  strcpy(name,base_path); if(path[0]!='/')strcat(name,"/"); strcat(name,path);  
  name_start=name+strlen(base_path);
  /* go down */
  l=strlen(name_start); name_end=name_start+l;
  for(;;) {
    if((mkdir_force(name,mode) == 0) || (errno == EEXIST)) {
      if(errno != EEXIST) lchown(name,uid,gid);
      /* go up */
      for(;;) {
        if((name_end-name_start) >= l) { free(name); return 0; };
        (*name_end)='/'; name_end=name_end+strlen(name_end);
        if(mkdir(name,mode) != 0) {
          if(errno == EEXIST) continue;
          free(name); return -1;
        };
        (void)chmod(name,mode);
        (void)lchown(name,uid,gid);
      };
    };
    /* if(errno == EEXIST) { free(name); errno=EEXIST; return -1; }; */
    if((name_end=strrchr(name_start,'/')) == NULL) break;
    if(name_end == name_start) break;
    (*name_end)=0;
  };
  free(name);
  return -1;
}

int mkdir_force(const char* path,mode_t mode) {
  struct stat st;
  int r;
  if(stat(path,&st) != 0) {
    r=mkdir(path,mode);
    if(r==0) (void)chmod(path,mode);
    return r;
  };
  if(S_ISDIR(st.st_mode)) { /* simulate error */
    r=mkdir(path,mode);
    if(r==0) (void)chmod(path,mode);
    return r;
  };
  if(remove(path) != 0) return -1;
  r=mkdir(path,mode);
  if(r==0) (void)chmod(path,mode);
  return r;
}
