#ifndef GM_LOG_TIME_H
#define GM_LOG_TIME_H

#include <pthread.h>
#include <iostream>
#include <string>

#include <arc/notify.h>

/*
  Object and macros to control output.
  olog/odlog are used instead of cerr.
  LogTime::level allows to control which messages are printed.
  If LogTime::active is set, date+time will be added at the beginning
  of message.
*/


#define OLOG_STREAM (std::cerr)
#define OLOG_HANDLE (STDERR_FILENO)
#define olog        oilog(-1)
#define olog_       oilog_
#define oilog(i)    (OLOG_STREAM<<LogTime(i))
#define oilog_      (OLOG_STREAM)
#define odlog(l)    odilog(l,-1)
#define odlog_(l)   odilog_(l)
#define odilog(l,i) if((l)<=LogTime::Level()) (OLOG_STREAM<<LogTime(i))
#define odilog_(l)  if((l)<=LogTime::Level()) (OLOG_STREAM)

class LogTime {
 friend std::ostream& operator<<(std::ostream&,LogTime);
 private:
  int id;
  static std::string logname;
  static int lognum;
  static unsigned int logsize;
  static pthread_mutex_t mutex;
  static bool active;
  static NotifyLevel level;
 public:
  LogTime(int id = -1);
  static void Active(bool a);
  static inline bool Active(void) { return active; };
  static void Level(NotifyLevel l);
  static inline NotifyLevel Level(void) { return level; };
  static void Log(const char* name = "",unsigned int size = 0,int num = 0);
  static void rotate(void);
  static void gmdatetime(std::ostream& o);
};

std::ostream& operator<<(std::ostream& o,LogTime t);

#endif
