#include "../std.h"

#include <arc/error.h>
#include <arc/stringconv.h>

#include "log_time.h"

static char* month_names[13] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "---"
};

bool LogTime::active = true;
NotifyLevel LogTime::level = FATAL;
std::string LogTime::logname("");
int LogTime::lognum = 0;
unsigned int LogTime::logsize = 0;
pthread_mutex_t LogTime::mutex = PTHREAD_MUTEX_INITIALIZER;


LogTime::LogTime(int id_) {
  id=id_;
};

void LogTime::Active(bool a) {
  try {
    Notify* n = Notify::getNotifier();
    if(n) {
      n->SetOutStream(OLOG_STREAM);
      n->SetNotifyTimeStamp(a);
    };
  } catch (ARCLibError) { };
  active=a;
};

void LogTime::Level(NotifyLevel l) {
  level=l;
  try {
    Notify* n = Notify::getNotifier();
    if(n) n->SetNotifyLevel(level);
  } catch (ARCLibError) { };
}

void LogTime::rotate(void) {
  if(!logname.length()) return;
  if(lognum>0) {
    std::string log_to;
    std::string log_from;
    log_to=logname+"."+tostring<int>(lognum-1);
    unlink(log_to.c_str());
    for(int n = lognum-2;n>=0;n--) {
      log_from=logname+"."+tostring<int>(n);
      rename(log_from.c_str(),log_to.c_str());
      log_to=log_from;
    };
    rename(logname.c_str(),log_to.c_str());
    int h=::open(logname.c_str(),O_WRONLY | O_CREAT | O_APPEND,S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
    if(h != -1) {
      dup2(h,OLOG_HANDLE);
      close(h);
    }; 
  } else {
    lseek(OLOG_HANDLE,0,SEEK_SET);
    ftruncate(OLOG_HANDLE,0);
  };
}

void LogTime::Log(const char* name,unsigned int size,int num) {
  logname=name; logsize=size; lognum=num;
}

void LogTime::gmdatetime(std::ostream& o) {
  char buf[100];
  time_t tt;
  struct tm t_buf;
  struct tm *t;
  // get current time
  time(&tt);
  t=gmtime_r(&tt,&t_buf);
  if(t==NULL) return;
  // print time
  // if(strftime(buf,100,"%d-%m-%Y %H:%M:%S ",t) != 0) {
  if(snprintf(buf,100,"%02u-%02u-%u %02u:%02u:%02u ",
              t->tm_mday,t->tm_mon+1,t->tm_year+1900,
              t->tm_hour,t->tm_min,t->tm_sec) != 0) {
    o<<buf;
  };
}


std::ostream& operator<<(std::ostream& o,LogTime lt) {
  if(lt.active) {
    char buf[100];
    time_t tt;
    struct tm t_buf;
    struct tm *t;
    // rotate log
    if(LogTime::logsize) {
      struct stat st;
      if(fstat(OLOG_HANDLE,&st) == 0) {
        if(st.st_size >= LogTime::logsize) {
          pthread_mutex_lock(&LogTime::mutex);
          if(fstat(OLOG_HANDLE,&st) == 0) {
            if(st.st_size >= LogTime::logsize) {
              LogTime::rotate();
            };
          };
          pthread_mutex_unlock(&LogTime::mutex);
        };
      };
    };
    // get current time
    time(&tt);
    t=localtime_r(&tt,&t_buf);
    if(t) {
      // print time
      //if(strftime(buf,100,"%b %d %H:%M:%S ",t) != 0) o<<buf;
      if((t->tm_mon < 0) || (t->tm_mon > 11)) t->tm_mon=12;
      if(snprintf(buf,100,"%s %02u %02u:%02u:%02u ",
                   month_names[t->tm_mon],t->tm_mday,
                   t->tm_hour,t->tm_min,t->tm_sec) != 0) o<<buf;
    };
    if(lt.id != -1) o<<"["<<lt.id<<"] ";
  };
  return o;
};

