#include "../std.h"
#include <netinet/in.h>
#include <netdb.h>

#include "../misc/condition.h"
#include "../misc/random.h"

#include "guid.h"

static char guid_chars[] = {
  'A','B','C','D','E','F','G','H','I','J','K','L','M',
  'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
  'a','b','c','d','e','f','g','h','i','j','k','l','m',
  'n','o','p','q','r','s','t','u','v','w','x','y','z',
  '0','1','2','3','4','5','6','7','8','9'
};

static CounterSimple guid_counter;

static void guid_add_string(std::string &guid,uint32_t n) {
  uint32_t max = 0xFFFFFFFF;
  for(;max;) {
    uint32_t i = n % sizeof(guid_chars);
    guid+=guid_chars[i];
    n/=sizeof(guid_chars); max/=sizeof(guid_chars);
    n+=0x55555555;
  };
}

void GUID(std::string& guid) {
  struct timeval tv;
  struct timezone tz;
  gettimeofday(&tv,&tz);
  // Use up to 4 IP addresses
  uint32_t hostid[4] = { INADDR_ANY, INADDR_ANY, INADDR_ANY, INADDR_ANY };
  hostid[0]=gethostid();
  if(htonl(INADDR_LOOPBACK) == hostid[0]) hostid[0]=INADDR_ANY;
  char hostname[1024];
  // Local addresses
  if(gethostname(hostname,sizeof(hostname)-1) == 0) {
    hostname[sizeof(hostname)-1]=0;
    struct hostent* host;
    struct hostent  hostbuf;
    int    errcode;
#ifndef _AIX
    char   buf[BUFSIZ];
    if(gethostbyname_r(hostname,&hostbuf,buf,sizeof(buf),&host,&errcode) == 0) {
#else
    struct hostent_data buf[BUFSIZ];
    if((errcode=gethostbyname_r(hostname,(host=&hostbuf),buf)) == 0) {
#endif
      if(host->h_length >= sizeof(struct in_addr)) {
        struct in_addr** addr = (struct in_addr**)host->h_addr_list;
        for(;*addr;++addr) {
          if((*addr)->s_addr == htonl(INADDR_LOOPBACK)) continue;
          int i;
          for(i=0;i<3;i++) {
            if(hostid[i] == INADDR_ANY) break;
            if((*addr)->s_addr == hostid[i]) break;
          };
          if(i>=3) continue;
          if(hostid[i] != INADDR_ANY) continue;
          hostid[i]=(*addr)->s_addr;
        };
      };
    };
  };
  // External addresse (TODO)

  // Use collected information
  guid_add_string(guid,tv.tv_usec);
  guid_add_string(guid,tv.tv_sec);
  guid_add_string(guid,hostid[0]);
  guid_add_string(guid,hostid[1]);
  guid_add_string(guid,hostid[2]);
  guid_add_string(guid,hostid[3]);
  guid_add_string(guid,getpid());
  guid_add_string(guid,guid_counter.inc());
  guid_add_string(guid,Random::get());
}

