#ifndef __GLOBUS_MODULES_H__
#define __GLOBUS_MODULES_H__

//#include "../std.h"
#include <pthread.h>

class GlobusModuleGlobalLock {
 private:
  static pthread_mutex_t mutex;
 public:
  static void lock();
  static void unlock();
};

#define NEW_GLOBUS_MODULE_CLASS_HEADER(class_name) \
class class_name : public GlobusModuleGlobalLock { \
 private: \
  static unsigned int counter; \
  bool activated; \
  static bool activate(); \
  static bool deactivate(); \
 public: \
  class_name(void); \
  ~class_name(void); \
  bool active(void) { return activated; }; \
};

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleCommon);

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleIO);

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleGASSTransfer);

/*
NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleGASSCopy);
*/

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleFTPControl);

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleFTPClient);

#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleReplicaCatalog);
#endif

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleGSIGSSAPI);

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleErrors);

/*
NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleRSL);
*/

NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleGSICredential);

#ifdef HAVE_GLOBUS_RLS_CLIENT_H
NEW_GLOBUS_MODULE_CLASS_HEADER(GlobusModuleRLSClient);
#endif

#endif /* __GLOBUS_MODULES_H__ */
