#include "../std.h"

#include "globus_modules.h"
#include <dlfcn.h>

#include <globus_common.h>

pthread_mutex_t GlobusModuleGlobalLock::mutex = PTHREAD_MUTEX_INITIALIZER;

void GlobusModuleGlobalLock::lock() {
  pthread_mutex_lock(&mutex);
}

void GlobusModuleGlobalLock::unlock() { 
  pthread_mutex_unlock(&mutex);
}

#define NEW_GLOBUS_MODULE_CLASS(class_name,module_name,class_string) \
unsigned int class_name::counter = 0; \
class_name::class_name(void) { \
  activated=activate(); \
}; \
class_name::~class_name(void) { \
  if(activated) deactivate(); \
}; \
bool class_name::activate(void) { \
  lock(); \
  int res = GLOBUS_SUCCESS; \
  if(counter==0) { \
    globus_module_descriptor_t* mod = (globus_module_descriptor_t*)dlsym(RTLD_DEFAULT,module_name);\
    res=globus_module_activate(mod); \
  }; \
  if(res==GLOBUS_SUCCESS) counter++; \
  unlock(); \
  return (res==GLOBUS_SUCCESS); \
}; \
bool class_name::deactivate(void) { \
  lock(); \
  int res = GLOBUS_SUCCESS; \
  if(counter>0) { \
    counter--; \
    if(counter==0) { \
      globus_module_descriptor_t* mod = (globus_module_descriptor_t*)dlsym(RTLD_DEFAULT,module_name);\
      /* workaround!!! res=globus_module_deactivate(mod); */ \
    }; \
    if(res != GLOBUS_SUCCESS) counter++; \
  }; \
  unlock(); \
  return (res==GLOBUS_SUCCESS); \
}

NEW_GLOBUS_MODULE_CLASS(GlobusModuleCommon,"globus_i_common_module","COMMON")

NEW_GLOBUS_MODULE_CLASS(GlobusModuleGASSTransfer,"globus_i_gass_transfer_module","GASS_TRANSFER")


NEW_GLOBUS_MODULE_CLASS(GlobusModuleFTPControl,"globus_i_ftp_control_module","FTP CONTROL")

NEW_GLOBUS_MODULE_CLASS(GlobusModuleFTPClient,"globus_i_ftp_client_module","FTP_CLIENT")

#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
NEW_GLOBUS_MODULE_CLASS(GlobusModuleReplicaCatalog,"globus_i_replica_catalog_module","REPLICA CATALOG")
#endif

NEW_GLOBUS_MODULE_CLASS(GlobusModuleGSIGSSAPI,"globus_i_gsi_gssapi_module","GSI GSSAPI")

NEW_GLOBUS_MODULE_CLASS(GlobusModuleErrors,"globus_i_error_module","ERROR")

#if GLOBUS_IO_VERSION<5
NEW_GLOBUS_MODULE_CLASS(GlobusModuleIO,"globus_i_io_module","IO")
#else
NEW_GLOBUS_MODULE_CLASS(GlobusModuleIO,"globus_l_io_module","IO")
#endif

/*
NEW_GLOBUS_MODULE_CLASS(GlobusModuleRSL,"globus_i_rsl_module","RSL")
*/

NEW_GLOBUS_MODULE_CLASS(GlobusModuleGSICredential,"globus_i_gsi_credential_module","GSI CREDENTIAL")

#ifdef HAVE_GLOBUS_RLS_CLIENT_H
NEW_GLOBUS_MODULE_CLASS(GlobusModuleRLSClient,"globus_rls_client_module","RLS");
#endif

