#include "../std.h"
#include "globus_error_utils.h"

/*
ostream& operator<<(ostream& o,globus_result_t res) {
  if(res == GLOBUS_SUCCESS) {
    o<<"<success>"; return o;
  };
  globus_object_t* err = globus_error_get(res);
  if(err) {
    char* tmp=globus_object_printable_to_string(err);
    if(tmp) { o<<tmp; free(tmp); };
    globus_object_free(err);
  };
  return o;
}
*/

std::ostream& operator<<(std::ostream& o,GlobusResult res) {
  if(res == GlobusResult(GLOBUS_SUCCESS)) {
    o<<"<success>"; return o;
  };
  globus_object_t* err_top = globus_error_get(res);
  for(globus_object_t* err_=err_top;err_;) {
    char* tmp=globus_object_printable_to_string(err_);
    if(tmp) { if(err_ != err_top) o<<"/"; o<<tmp; free(tmp); };
    err_=globus_error_base_get_cause(err_);
  };
  if(err_top) globus_object_free(err_top);
  return o;
}

void GlobusResult::get(std::string& s) {
  if(r == GLOBUS_SUCCESS) { s="<success>"; return; };
  globus_object_t* err_top = globus_error_get(r);
  s="";
  for(globus_object_t* err_=err_top;err_;) {
    char* tmp=globus_object_printable_to_string(err_);
    if(tmp) { if(err_ != err_top) s+="/"; s+=tmp; free(tmp); };
    err_=globus_error_base_get_cause(err_);
  };
  if(s.empty()) s="unknown error";
  return;
}

std::ostream& operator<<(std::ostream& o,globus_object_t* err) {
  if(err == GLOBUS_NULL) {
    o<<"<success>"; return o;
  };
  for(globus_object_t* err_=err;err_;) {
    char* tmp=globus_object_printable_to_string(err_);
    if(tmp) { if(err_ != err) o<<"/"; o<<tmp; free(tmp); };
    err_=globus_error_base_get_cause(err_);
  };
  return o;
}

void globus_object_to_string(globus_object_t* err,std::string& s) {
  if(err == GLOBUS_NULL) { s="<success>"; return; };
  for(globus_object_t* err_=err;err_;) {
    char* tmp=globus_object_printable_to_string(err_);
    if(tmp) { if(err_ != err) s+="/"; s=tmp; free(tmp); };
    err_=globus_error_base_get_cause(err_);
  };
  if(s.empty()) s="unknown error";
  return;
}

