#ifndef __ARC_HTTPS_SERVISE_SOAP_H__
#define __ARC_HTTPS_SERVISE_SOAP_H__

#include "../httpsd.h"
#include <stdsoap2.h>

#define MAX_RANGES 16

#include "../lib/timestamps.h"

/// This service adds minimal helper methods needed to manage 
/// at least data transfers.
class HTTP_ServiceData:public HTTP_Service {
 protected:
  HTTP_Connector *c;
  // HTTP Header
  uint64_t range_start[MAX_RANGES];
  uint64_t range_end[MAX_RANGES];
  uint64_t entity_range_start;
  uint64_t entity_range_end;
  uint64_t entity_size;
  HTTP_Time entity_last_modified;
  HTTP_Time entity_expires;
  int nranges;
  bool range_passed;
  bool failure_parsing;
  uint64_t length;
  bool length_passed;
  bool entity_range_passed;
  bool entity_size_passed;
  bool entity_last_modified_passed;
  bool entity_expires_passed;
  bool unsupported_option_passed;
  virtual HTTP_Error parse_header(int &keep_alive);
  virtual HTTP_Error send_header(int &keep_alive,int code = 200);
  HTTP_Error send_header(int &keep_alive,uint64_t start,uint64_t end,bool partial,uint64_t full_size,const HTTP_Time& expires,const HTTP_Time& last_modified);
 public:
  HTTP_ServiceData(HTTP_Connector *c_):c(c_) { };
  virtual ~HTTP_ServiceData(void) { };
};

class HTTP_ServiceAdv:public HTTP_ServiceData {
 protected:
  // SOAP
  bool ignore_soap_output;
  struct soap sp;
  struct Namespace* namespaces;
  char soap_fbuf[1024];
  int soap_fbuf_n;
  static int soap_fsend(struct soap *sp, const char* buf, size_t l);
  static int soap_flush(struct soap *sp);
  static size_t soap_frecv(struct soap* sp, char* buf, size_t l);
  static int soap_fopen(struct soap*, const char*, const char*, int);
  static int soap_fclose(struct soap*);
  static int soap_parse(struct soap *sp);
  void soap_init(void);
  void soap_deinit(void);
  virtual HTTP_Error post(const char* uri,int &keep_alive);
  HTTP_Error soap_post(const char* uri,int &keep_alive);
  virtual void soap_methods(void);
  void add_namespaces(struct Namespace* namespaces);
 public:
  HTTP_ServiceAdv(HTTP_Connector *c_):HTTP_ServiceData(c_),soap_fbuf_n(0),namespaces(NULL),ignore_soap_output(false) { };
  virtual ~HTTP_ServiceAdv(void);
};

#endif // __ARC_HTTPS_SERVISE_SOAP_H__
