#ifndef __INCLUDE_SE_REPLICATOR_H__
#define __INCLUDE_SE_REPLICATOR_H__

#include "file.h"
#include "se_files.h"
#include "../../misc/thread.h"

class SEReplicator {
 private:
  LockSimple lock;
  int timeout;
 public:
  SEReplicator(void);
  ~SEReplicator(void);
  int Obtain(SEFile& file);
  void Timeout(int t) { timeout=t; };
};

class SEReplicator_Thread: public Thread {
 private:
  SEFilesList& files;
  virtual void func(void);
 public:
  SEReplicator_Thread(SEFilesList& f):files(f) { };
  ~SEReplicator_Thread(void) { };
};

#endif // __INCLUDE_SE_REPLICATOR_H__
