#include <ldap.h>

#include <arc/url.h>
#include "file.h"
#include "se_ns.h"

class SENameServerRC: public SENameServer {
 private:
  URL url;
  bool valid;
  LDAP* connect(void);
  std::string name;
 public:
  SENameServerRC(const char* contact,const char* se_url);
  virtual ~SENameServerRC(void);
  virtual int Register(SEFile& file,bool require_unique);
  virtual int Unregister(SEFile& file,bool allow_last);
  virtual int Modify(SEFile& file);
  virtual int Get(SEAttributes& file);
  virtual operator bool(void) { return valid; };
};

