#ifndef __INCLUDE_SE_NS_H__
#define __INCLUDE_SE_NS_H__

#include <string>
#include <vector>

class SEFile;
class SEAttributes;

class SENameServer {
 private:
  std::string contact_;
  std::string se_url_;
  std::vector<std::string> access_urls_;
 public:
  SENameServer(const char* contact,const char* se_url):contact_(contact),se_url_(se_url)  { };
  virtual ~SENameServer(void) { };
  virtual int Connect(void) { return 0; };
  virtual int Disconnect(void) { return 0; };
  virtual int Register(SEFile& file,bool require_unique = false) { return 0; };
  virtual int Unregister(SEFile& file,bool allow_last = true) { return 0; };
  virtual int Modify(SEFile& file) { return 0; };
  virtual int Get(SEAttributes& file) { return 0; };
  virtual int Maintain(void) { return 0; };
  virtual const char* contact() const { return contact_.c_str(); };
  virtual const char* se_url() const { return se_url_.c_str(); };
  virtual void access_url(const char* u) {
    access_urls_.push_back(std::string(u));
  };
  virtual const char* access_url(int n) const {
    if((n<0) || (n>=access_urls_.size())) return NULL;
    return access_urls_[n].c_str();
  };
  virtual std::string url(SEAttributes& file);
  virtual operator bool(void) { return (contact_.length()>0); };
};

SENameServer* create_ns(const char* contact,const char* se_url);

#endif // __INCLUDE_SE_NS_H__
