#include <string>
#include <list>

typedef int(*query_callback_t)(const char* dn,const char* attr,const char* value,void* ref);

class LDAPConnector {
 private:
  LDAP* connection;
  std::string host;
  int port;
  int connect(void);
 public:
  class Attribute {
   public:
    std::string attr;
    std::string value;
    bool value_available;
    Attribute(const char* a):attr(a),value(""),value_available(false) { };
    Attribute(const char* a,const char* v):attr(a),value(v),value_available(true) { };
  };
  LDAPConnector(const char* host,int port);
  ~LDAPConnector(void);
  operator bool(void) { return (connection!=NULL); };
  int CheckEntry(const char* base,const char* filter);
  int GetAttributes(const char* base,std::list<Attribute> &attrs);
  int Query(const char* base,const char* filter,int scope,const char* attrs[],query_callback_t callback,void* ref);
  int SetAttributes(const char* base,std::list<Attribute> &attrs);
  int CreateEntry(const char* base,std::list<Attribute> &attrs);
};

