#ifndef __SE_FILES_H__
#define __SE_FILES_H__

#include <string>

#include "se_ns.h"
#include "disk_space.h"
#include "../../misc/condition.h"
//#include "../../auth/auth.h"
#include "../../misc/safelist.h"

#include "file.h"

#define DEFAULT_TIMEOUT_COLLECTING (10*60)
#define DEFAULT_SIZE_COLLECTING (10)
#define DEFAULT_TIMEOUT_DOWNLOADING (10*60)
#define DEFAULT_SIZE_DOWNLOADING (10)
#define DEFAULT_RETRIES_DOWNLOADING (10)
#define DEFAULT_TIMEOUT_COMPLETE (30*60)
#define DEFAULT_TIMEOUT_FAILED (24*60*60)

class SENameServer;

#define registration_immediate 1
#define registration_retry 2
class SEFiles {
 public:
  typedef SafeList<SEFile>::iterator iterator;
 private:
  SafeList<SEFile> files;
//  uint32_t nfiles;
  SENameServer* ns;   // Server for registrations to be sent
  bool valid;
  std::string path; // directory path to store new files
  LockSimple lock;
  DiskSpace space;
  SEFile* find_by_id(const char* id);
  int reg_type;
  int timeout_collecting;
  int timeout_downloading;
  int retries_downloading;
  int timeout_complete;
  int timeout_failed;
  bool try_unregister(iterator file);
  bool try_register(iterator file);
 public:
  iterator begin() { return files.begin(); };
  iterator end() { return files.end(); };
  void acquire(void) { lock.block(); };
  void release(void) { lock.unblock(); };
  SEFiles();
  SEFiles(const char* dirpath);
  ~SEFiles();
  operator bool(void) { return valid; };
  iterator add(SEFile& file);
  bool remove(iterator& file);
  bool remove(SEFile& file);
  SEFile* get(const char* id); 
  SENameServer* NS(void) { return ns; };
  void NS(SENameServer* ns_,int reg_) {
    if(ns) delete ns;
    ns=ns_; reg_type=reg_;
  };
  void NS(const char* ns_cfg,const char* se_url,int reg_) {
    if(ns) delete ns;
    ns=create_ns(ns_cfg,se_url);
    reg_type=reg_;
  };
  const char* Path(void) { return path.c_str(); };
  int Register(void);
  int Unregister(void);
  int RemoveStuck(void);
  int Replicate(void);
  int Verify(void);
  bool register_immediately(void) {
    return (reg_type & registration_immediate)?true:false;
  };
  bool register_retry(void) {
    return (reg_type & registration_retry)?true:false;
  };
  int check_acl(const AuthUser &user);
  int write_acl(const AuthUser &user,const char* acl);
  int read_acl(const AuthUser &user,std::string& acl);
  DiskSpace& Space(void) { return space; };
  void Maintain(void);
  void TimeoutCollecting(int t) { timeout_collecting=t; };
  void TimeoutDownloading(int t) { timeout_downloading=t; };
  void RetriesDownloading(int n) { retries_downloading=n; };
  void TimeoutComplete(int t) { timeout_complete=t; };
  void TimeoutFailed(int t) { timeout_failed=t; };
};

class SEFileHandle {
 private:
  SEFile& file;
  uint64_t offset;
  bool open_read;
  bool active;
 public:
  SEFileHandle(SEFile& f,uint64_t offset,bool open_read);
  ~SEFileHandle(void);
  static SEFileHandle* open(const char* id,uint64_t offset,bool for_read,SEFiles& files);
  static SEFileHandle* open(const char* id,bool for_read,SEFiles& files) { return open(id,0,for_read,files); };
  static SEFileHandle* create(const char* id,bool for_read,SEFiles& files);
  uint64_t write(void* buf,uint64_t size);
  uint64_t read(void* buf,uint64_t size);
  uint64_t tell(void) { return offset; };
  void seek(uint64_t o) { offset=o; };
  void close(void) { if(active) { active=false; file.close(open_read); }; };
  uint64_t size(void) { return file.size(); };
  bool full(void) { return file.full(); };
  operator bool(void) { return active; };
  bool operator!(void) { return !active; };
  SEFile& instance(void) { return file; };
};

#endif // __SE_FILES_H__
