//gsoap ns service name: ARCStorageElement
//gsoap ns service documentation: Stores content and and registers it into Indexing Service
//gsoap ns service portType: ARCStorageElementPortType
//gsoap ns service namespace: http://www.nordugrid.org/ws/schemas/ARCStorageElement
//gsoap ns service method-documentation: add Add new content(file)
//gsoap ns service method-documentation: update Update metadata of content
//gsoap ns service method-documentation: info Search for named content and provide metadata
//gsoap ns service method-documentation: acl Manipulate access rules for named content
//gsoap ns service method-documentation: del Remove contant and unregister it

enum ns__filestate {
  accepted = 0,
  collecting = 1,
  complete = 2,
  deleting = 3,
};

class ns__fileinfo {
 public:
  char* id;
  unsigned long long int* size;
  char* checksum;
  char* acl;
  char* created;
  enum ns__filestate* state;
  int __size_url;
  char** url;
  ns__fileinfo();
  ~ns__fileinfo();
};

struct ns__addResponse {
  int error_code;
  int sub_error_code;
  char* error_description;
  ns__fileinfo file;
};

struct ns__updateResponse {
  int error_code;
  int sub_error_code;
  char* error_description;
  ns__fileinfo file;
};

struct ns__infoResponse {
  int error_code;
  int sub_error_code;
  char* error_description;
  int __size_file;
  ns__fileinfo* file;
};

struct ns__aclResponse {
  int error_code;
  int sub_error_code;
  char* error_description;
  char* acl;
};

struct ns__delResponse {
  int error_code;
  int sub_error_code;
  char* error_description;
};

// create new file
int ns__add(
  ns__fileinfo *file,
  int __size_source,
  char** source,
  struct ns__addResponse &r
);

// update information about file (used to provide checksum after upload)
int ns__update(
  ns__fileinfo *file,
  struct ns__updateResponse &r
);

// get file info
int ns__info(
  char *pattern,
  struct ns__infoResponse &r
);

// get/set ACL
int ns__acl(
  char *acl,
  struct ns__aclResponse &r
);

// remove file
int ns__del(
  struct ns__delResponse &r
);

