#include "../../std.h"

#include <string>

#include "../../misc/time_utils.h"
#include "../../misc/escaped.h"

#include "file.h"

bool SEReqAttr::parse(const char* s) {
  who_=""; till_=time(NULL);
  int n;
  std::string id;
  std::string t;
  n=input_escaped_string(s,id);
  if(n == 0) return false;
  n=input_escaped_string(s+n,t);
  if(n == 0) return false;
  time_t tt;
  if(stringtotime(tt,t) != 0) return false;
  till_=tt; who_=id;  
  return true;
}

SEReqAttr::SEReqAttr(std::istream& i) {
  // read till end of line
  char buf[1024];
  istream_readline(i,buf,sizeof(buf));
  parse(buf);
}

bool SEReqAttr::extend(int valid) {
  if(valid <= 0) return false;
  if(valid <= left()) return false;
  till_=time(NULL)+valid;
  return true;
}

std::ostream& operator<<(std::ostream& o,const SEReqAttr &a) {
  std::string s;
  std::string id(a.id());
  make_escaped_string(id);
  timetostring(a.till(),s);
  o<<id<<"\""<<s<<"\"";
  return o;
}

SEPins::SEPins(void) {
}

bool SEPins::add(const char* s) {
  SEReqAttr a(s);
  return add(a);
}

bool SEPins::add(std::istream& i) {
  SEReqAttr a(i);
  return add(a);
}

bool SEPins::add(const char* id,int valid) {
  SEReqAttr a(id,valid);
  return add(a);
}

bool SEPins::add(const SEReqAttr& a) {
  if(!a) return false;
  for(std::list<SEReqAttr>::iterator p = pins_.begin();p!=pins_.end();++p) {
    if(strcmp(p->id(),a.id()) == 0) {
      return p->extend(a.left());
    };
  };
  pins_.push_back(a);
  return true;
}

bool SEPins::remove(const char* id) {
  for(std::list<SEReqAttr>::iterator p = pins_.begin();p!=pins_.end();) {
    if(strcmp(p->id(),id) == 0) {
      p=pins_.erase(p); continue;
    };
    ++p;
  };
}

bool SEPins::maintain(void) {
  for(std::list<SEReqAttr>::iterator p = pins_.begin();p!=pins_.end();) {
    if(p->left() < 0) {
      p=pins_.erase(p); continue;
    };
    ++p;
  };
}

int SEPins::pinned(const char* id) const {
  int left = 0;
  for(std::list<SEReqAttr>::const_iterator p = pins_.begin();p!=pins_.end();++p) {
    if(strcmp(id,p->id()) == 0) {
      if(p->left() > left) left=p->left();
    };
  };
  return left;
}

int SEPins::pinned(void) const {
  int left = 0;
  for(std::list<SEReqAttr>::const_iterator p = pins_.begin();p!=pins_.end();++p) {
    if(p->left() > left) left=p->left();
  };
  return left;
}

std::ostream& operator<<(std::ostream& o,const SEPins &a) {
  for(std::list<SEReqAttr>::const_iterator p = a.pins_.begin();p!=a.pins_.end();++p) {
    o<<"pin="<<*p<<std::endl;
  };
}

bool SEPin::add(const char* s) {
  if(s == NULL) { pin_=true; return true; };
  if(s[0] == 0) { pin_=true; return true; };
  if(strcasecmp("yes",s) == 0) { pin_=true; return true; }
  else if(strcasecmp("true",s) == 0) { pin_=true; return true; }
  else if(strcasecmp("no",s) == 0) { pin_=false; return true; }
  else if(strcasecmp("false",s) == 0) { pin_=false; return true; };
  return false;
}

std::ostream& operator<<(std::ostream& o,const SEPin &a) {
  if(a.pinned()) {
    o<<"pin=yes"<<std::endl;
  } else {
    o<<"pin=no"<<std::endl;
  };
  return o;
}

