#include "../../std.h"

#ifndef HAVE_OLD_LIBXML_INCLUDES
#include <libxml/parser.h>
#else
#include <parser.h>
#ifndef xmlChildrenNode
#define xmlChildrenNode childs
#endif
#endif

#include "file.h"


static int write_credentials(const char* cred,const std::string& gname) {
  int h=::open(gname.c_str(),O_WRONLY | O_CREAT | O_EXCL,0600);
  if(h == -1) return -1;
  const char* s = cred;
  int ll = strlen(cred);
  int l = 0;
  for(;(ll>0) && (l!=-1);s+=l,ll-=l) l=::write(h,s,ll);
  if(ll != 0) return -1;
  return 0;
}

static int read_credentials(std::string& cred,const std::string& gname) {
  int h=::open(gname.c_str(),O_RDONLY);
  if(h==-1) return -1;
  int l = 0;
  cred.resize(0);
  for(;;) {
    char buf[1024];
    int ll = ::read(h,buf,sizeof(buf));
    if(ll == -1) { close(h); return -1; };
    if(l>=10240) { close(h); return -1; };
    if(ll == 0) break;
    cred.append(buf,ll);
    l+=ll;
  };
  close(h);
  return 0;
}

int SEFile::write_credentials(const char* cred) {
  std::string gname=path+".cred";
  return ::write_credentials(cred,gname);
}

int SEFile::read_credentials(std::string& cred) {
  std::string gname=path+".cred";
  return ::read_credentials(cred,gname);
}

std::string SEFile::credentials_file(void) {
  return (path+".cred");
}

