#ifndef SE_DISK_SPACE
#define SE_DISK_SPACE

#include <stdint.h>
#include <string>

#include "../../misc/condition.h"

class DiskSpace: public LockSimple {
 private:
   uint64_t blocks_;
   uint64_t bsize_;
   std::string path_;
 public:
  DiskSpace(void);
  DiskSpace(const char* p);
  ~DiskSpace(void);
  operator bool(void) { return (bsize_!=0); };
  bool operator!(void) { return (bsize_==0); };
  bool request(uint64_t si_new,uint64_t si_old=0);
};

class DiskSpaceLink {
 friend class DiskSpace;
 private:
  DiskSpace& space_;
  uint64_t size_;
 public:
  DiskSpaceLink(uint64_t si,DiskSpace& sp);
  ~DiskSpaceLink(void);
  uint64_t size(void) { return size_; };
  bool request(uint64_t si);
  bool release(uint64_t si);
  bool release(void) { return release(size_); };
};

#endif // SE_DISK_SPACE
