#include <string>
#include <iostream>

#include "httpsd.h"
#include "server/service_soap.h"

#include "se/file.h"
#include "se/files.h"

//#include "se/file_soapH.h"

#define SUCCESS                   0
#define ERR_MISSING_INPUT_DATA    1
#define ERR_EXCESSIVE_INPUT_DATA  2
#define ERR_WRONG_INPUT_DATA      3
#define ERR_OBJECT_MISSING        4
#define ERR_INSUFFICIENT_ACCESS   5
#define ERR_CREATING_NEW_FILE     10
#define ERR_UPDATING_FILE         11
#define ERR_ACCESS                12
#define ERR_UNSUPPORTED_FEATURE   13
#define ERR_IMPROPER_STATE        14
#define ERR_FILE_NOT_FOUND        15
#define ERR_INTERNAL_ERROR        100


class HTTP_SE_Handle;

//class SEFile;
//class SEFiles;
//class SEAttributes;
class ns__fileinfo;
class ns__infoResponse;
class ns__aclResponse;
class ns__delResponse;

class HTTP_SE: public HTTP_ServiceAdv {
  friend int ns__add(struct soap* sp,ns__fileinfo *file,int __size_source,char** source,struct ns__addResponse &r);
  friend int ns__info(soap *sp, char *pattern, ns__infoResponse &r);
  friend int ns__acl(soap *sp, char *acl, ns__aclResponse &r);
  friend int ns__del(soap *sp, ns__delResponse &r);
  friend int ns__update(struct soap *sp, ns__fileinfo *file, struct ns__updateResponse &r);
 private:
  HTTP_SE_Handle* handle;
  std::string service_url;
  std::string files_url;
  const char* current_name;
  SEFile* current_file;
  bool acl_create;
  bool acl_replicate;
  bool acl_read;
 public:
  HTTP_SE(HTTP_Connector *c,HTTP_SE_Handle *handle,const char* uri,bool create,bool replicate,bool read);
  virtual ~HTTP_SE(void);
  virtual HTTP_Error get(const char* uri,int &keep_alive);
  virtual HTTP_Error put(const char* uri,int &keep_alive);
  virtual HTTP_Error post(const char* uri,int &keep_alive);
  virtual void soap_methods(void);
  SEFiles::iterator new_file(SEAttributes& attr);
  bool delete_file(SEFile& f);
  SEFiles* files(void);
  int check_acl(void);
  std::string base_url(const char* proto = NULL); // for SRM
  bool register_new_file(SEFile* f); // for SRM
  bool set_current_file(const char* uri); // for SRM
  void new_files(void); // for SRM
};

HTTP_Service* se_service_creator(HTTP_Connector& c,const char* uri,void* arg);
bool se_service_configurator(std::istream& f,const char* uri,HTTP_Service_Properties &prop);
