// TODO: Run multiple clients in parallel

#include "../../std.h"
#include <string>
#include <list>
#include <fstream>

#include <arc/stringconv.h>
#include "../client/client.h"
#include "../../misc/log_time.h"

#include "logger_common.h"

#include "logger_client.h"

#include "logger_soap.nsmap"
#include "logger2_soap.nsmap"

void copy_jobinfo(nl2__UsageRecord& to,const nl__jobinfo& from,struct soap* sp) {
  to.projectname=NULL;
  to.requestedcputime=NULL;
  to.requestedmemory=NULL;
  to.requesteddisk=NULL;
  to.localuserid=NULL;
  to.queue=NULL;
  to.lrms=NULL;
  to.localjobid=NULL;
  to.lrmssubmissiontime=NULL;
  to.lrmsendtime=NULL;
  //to.nodename=NULL;
  to.nodecount=NULL;
  to.usedwalltime=NULL;
  to.useddisk=NULL;
  to.status=NULL;
  to.downloadtime=NULL;
  to.uploadtime=NULL;
  if(from.start) to.submissiontime=(time_t*)soap_malloc(sp,sizeof(time_t));
  if(to.submissiontime) *(to.submissiontime)=from.start;
  if(from.end) to.endtime=(time_t*)soap_malloc(sp,sizeof(time_t));
  if(to.endtime) *(to.endtime)=from.end;
  //to.cluster=from.cluster?soap_new_std__string(sp,-1):NULL;
  //if(to.cluster) *(to.cluster)=from.cluster;
  to.cluster=from.cluster?from.cluster:"";
  to.globaluserid=from.user?from.user:"";
  to.globaljobid=from.id?from.id:"";
  to.jobname=from.name?soap_new_std__string(sp,-1):NULL;
  if(to.jobname) *(to.jobname)=from.name;
  to.failurestring=from.failure?soap_new_std__string(sp,-1):NULL;
  if(to.failurestring) *(to.failurestring)=from.failure;
  to.lrms=from.lrms?soap_new_std__string(sp,-1):NULL;
  if(to.lrms) *(to.lrms)=from.lrms;
  to.queue=from.queue?soap_new_std__string(sp,-1):NULL;
  if(to.queue) *(to.queue)=from.queue;
  to.jobdescription=from.rsl?soap_new_std__string(sp,-1):NULL;
  if(to.jobdescription) *(to.jobdescription)=from.rsl;
  to.submithost=from.ui?soap_new_std__string(sp,-1):NULL;
  if(to.submithost) *(to.submithost)=from.ui;
  if(from.usedcpu) to.usedcputime=(int*)malloc(sizeof(int));
  if(to.usedcputime) *(to.usedcputime)=from.usedcpu;
  if(from.usedmem) to.usedmemory=(int*)malloc(sizeof(int));
  if(to.usedmemory) *(to.usedmemory)=from.usedmem;
  if(from.end) {
    to.exitcode=(int*)malloc(sizeof(int));
    if(to.exitcode) *(to.exitcode)=from.failure?(-1):0;
  };
};

/*
#include <globus_common.h>
#include <globus_io.h>

#include "../../files/info_types.h"
#include "../../misc/globus_error_utils.h"

#include "../../misc/url_options.h"
#include "../../config/conf.h"



time_t* soap_new_time(struct soap* sp,const char* s) {
  mds_time t;
  t=s;
  if(!t.defined()) return NULL;
  time_t* p = sp?(time_t*)soap_malloc(sp,sizeof(time_t)):(new time_t);
  if(p) *p=(time_t)t;
  return p;
}

time_t* soap_new_time(struct soap* sp,const std::string& s) {
  return soap_new_time(sp,s.c_str());
}

template<typename T> T* soap_new_i(struct soap* sp,const std::string& s) {
  T n;
  if(!isdigit(s[0])) return NULL;
  std::stringstream ss(s);
  ss >> n;
  T* p = sp?(T*)soap_malloc(sp,sizeof(T)):(new T);
  if(p) *p=n;
  return p;
}

template<typename T> T* soap_new_i(struct soap* sp,const char* s) {
  T n;
  if(!s) return NULL;
  if(!isdigit(s[0])) return NULL;
  std::stringstream ss(s);
  ss >> n;
  T* p = sp?(T*)soap_malloc(sp,sizeof(T)):(new T);
  if(p) *p=n;
  return p;
}

class JobRecord {
 private:
  bool valid;
  bool allocated;
 public:
  nl2__UsageRecord info;
  std::string url;
  operator bool(void) { return valid; };
  bool operator!(void) { return !valid; };
  JobRecord(std::istream& i,struct soap* sp = NULL);
  JobRecord(const JobRecord& j);
  ~JobRecord(void);
};

JobRecord::JobRecord(const JobRecord& j) {
  valid=j.valid;
  info=j.info;
  allocated=false;
}

JobRecord::JobRecord(std::istream& i,struct soap* sp):valid(false),url("") {
  allocated=(sp != NULL);
  if(sp) {
    info.soap_default(sp);
  } else {
      info.ngjobid="";
      info.usersn="";
      info.cluster=NULL;
      info.description=NULL;
      info.projectname=NULL;
      info.jobname=NULL;
      info.clienthost=NULL;
      info.localuser=NULL;
      info.queue=NULL;
      info.lrms=NULL;
      info.localjobid=NULL;
      info.nodename=NULL;
      info.failurestring=NULL;
      info.status=NULL;
      info.requestedcputime=NULL;
      info.requestedmemory=NULL;
      info.requesteddisk=NULL;
      info.nodecount=NULL;
      info.exitcode=NULL;
      info.usedcputime=NULL;
      info.usedmemory=NULL;
      info.usedwalltime=NULL;
      info.useddisk=NULL;
      info.submissiontime=NULL;
      info.lrmssubmissiontime=NULL;
      info.lrmsendtime=NULL;
      info.endtime=NULL;
      info.downloadtime=NULL;
      info.uploadtime=NULL;
  };
  for(;;) {
    if(i.fail()) goto error;
    if(i.eof()) break;
    std::string value;
    std::string key = config_read_line(i,value,'=');
    if(key=="loggerurl") { url=value; }
    else if(key=="ngjobid") { info.ngjobid=value; }
    else if(key=="usersn") { info.usersn=value; }
    else if(key=="cluster") { info.cluster=soap_new_std__string(sp,value); }
    else if(key=="description") { info.description=soap_new_std__string(sp,value); }
    else if(key=="projectname") { info.projectname=soap_new_std__string(sp,value); }
    else if(key=="jobname") { info.jobname=soap_new_std__string(sp,value); }
    else if(key=="clienthost") { info.clienthost=soap_new_std__string(sp,value); }
    else if(key=="localuser") { info.localuser=soap_new_std__string(sp,value); }
    else if(key=="queue") { info.queue=soap_new_std__string(sp,value); }
    else if(key=="lrms") { info.lrms=soap_new_std__string(sp,value); }
    else if(key=="localjobid") { info.localjobid=soap_new_std__string(sp,value); }
    else if(key=="nodename") { info.nodename=soap_new_std__string(sp,value); }
    else if(key=="failurestring") { info.failurestring=soap_new_std__string(sp,value); }
    else if(key=="status") { info.status=soap_new_std__string(sp,value); }
    else if(key=="requestedcputime") { info.requestedcputime=soap_new_i<int>(sp,value); }
    else if(key=="requestedmemory") { info.requestedmemory=soap_new_i<int>(sp,value); }
    else if(key=="requesteddisk") { info.requesteddisk=soap_new_i<int>(sp,value); }
    else if(key=="nodecount") { info.nodecount=soap_new_i<int>(sp,value); }
    else if(key=="exitcode") { info.exitcode=soap_new_i<int>(sp,value); }
    else if(key=="usedcputime") { info.usedcputime=soap_new_i<int>(sp,value); }
    else if(key=="usedmemory") { info.usedmemory=soap_new_i<int>(sp,value); }
    else if(key=="usedwalltime") { info.usedwalltime=soap_new_i<int>(sp,value); }
    else if(key=="useddisk") { info.useddisk=soap_new_i<int>(sp,value); }
    else if(key=="submissiontime") { info.submissiontime=soap_new_time(sp,value); }
    else if(key=="lrmssubmissiontime") { info.lrmssubmissiontime=soap_new_time(sp,value); }
    else if(key=="lrmsendtime") { info.lrmsendtime=soap_new_time(sp,value); }
    else if(key=="endtime") { info.endtime=soap_new_time(sp,value); }
    else if(key=="downloadtime") { info.downloadtime=soap_new_time(sp,value); }
    else if(key=="uploadtime") { info.uploadtime=soap_new_time(sp,value); }
  };
  valid=true;
error:
  return;
}

JobRecord::~JobRecord(void) {
  if(allocated) {
    if(info.cluster) delete info.cluster;
    if(info.description) delete info.description;
    if(info.projectname) delete info.projectname;
    if(info.jobname) delete info.jobname;
    if(info.clienthost) delete info.clienthost;
    if(info.localuser) delete info.localuser;
    if(info.queue) delete info.queue;
    if(info.lrms) delete info.lrms;
    if(info.localjobid) delete info.localjobid;
    if(info.nodename) delete info.nodename;
    if(info.failurestring) delete info.failurestring;
    if(info.status) delete info.status;
    if(info.requestedcputime) delete info.requestedcputime;
    if(info.requestedmemory) delete info.requestedmemory;
    if(info.requesteddisk) delete info.requesteddisk;
    if(info.nodecount) delete info.nodecount;
    if(info.exitcode) delete info.exitcode;
    if(info.usedcputime) delete info.usedcputime;
    if(info.usedmemory) delete info.usedmemory;
    if(info.usedwalltime) delete info.usedwalltime;
    if(info.useddisk) delete info.useddisk;
    if(info.submissiontime) delete info.submissiontime;
    if(info.lrmssubmissiontime) delete info.lrmssubmissiontime;
    if(info.lrmsendtime) delete info.lrmsendtime;
    if(info.endtime) delete info.endtime;
    if(info.downloadtime) delete info.downloadtime;
    if(info.uploadtime) delete info.uploadtime;
  };
}

#define print_element(name) \
  if(j.name.length()) o<<#name<<"="<<j.name<<std::endl;

#define print_optional_element(name) \
  if(j.name) o<<#name<<"="<<*(j.name)<<std::endl;

std::ostream& operator<<(std::ostream& o,const nl2__UsageRecord& j) {
  print_element(ngjobid);
  print_element(usersn);
  print_optional_element(cluster);
  print_optional_element(description);
  print_optional_element(projectname);
  print_optional_element(jobname);
  print_optional_element(clienthost);
  print_optional_element(requestedcputime);
  print_optional_element(requestedmemory);
  print_optional_element(requesteddisk);
  print_optional_element(submissiontime);
  print_optional_element(localuser);
  print_optional_element(queue);
  print_optional_element(lrms);
  print_optional_element(lrmssubmissiontime);
  print_optional_element(lrmsendtime);
  print_optional_element(nodename);
  print_optional_element(nodecount);
  print_optional_element(exitcode);
  print_optional_element(failurestring);
  print_optional_element(usedcputime);
  print_optional_element(usedmemory);
  print_optional_element(usedwalltime);
  print_optional_element(useddisk);
  print_optional_element(status);
  print_optional_element(endtime);
  print_optional_element(downloadtime);
  print_optional_element(uploadtime);
  return o;
}
*/

LoggerClient::LoggerClient(void):url(NULL),client(NULL) {
}

LoggerClient::~LoggerClient(void) {
  if(client) delete client;
}

bool LoggerClient::Initialized(void) {
  return (client != NULL);
}

bool LoggerClient::SameContact(const char* url_) {
  if(!url) return false;
  try {
    URL u(url_);
    return((u.Protocol() == url->Protocol()) && 
           (u.Host() == url->Host()) && 
           (u.Port() == url->Port()));
  } catch (std::exception e) {
    return false;
  };
}

bool LoggerClient::NewURL(const char* url_) {
  if(url_ == NULL) return false;
  try {
    if(url) {
      URL u(url_);
      if((u.Protocol() == url->Protocol()) &&
         (u.Host() == url->Host()) &&
         (u.Port() == url->Port())) {
        *url=u;
      } else { // reinitialize for different server
        *url=u; if(client) delete client; client=NULL;
      };
    } else { // initialize for first connection
      url=new URL(url_); if(client) delete client; client=NULL;
    };
  } catch (std::exception e) {
    delete url; url=NULL; if(client) delete client; client=NULL;
    return false;
  };
  if(client == NULL) {
    std::string soap_url = url->Protocol()+"://"+url->Host()+":"+tostring(url->Port());
    client = new HTTP_ClientSOAP(soap_url.c_str(),&soap);
    client->AddSOAPNamespaces(logger_soap_namespaces);
    client->AddSOAPNamespaces(logger2_soap_namespaces);
  } else {
    client->reset();
  };
  return true;
}

bool LoggerClient::Report(const char* url_,std::list<nl2__UsageRecord>& info) {
  // Try V2, if it fails try V1
  if(ReportV2(url_,info)) return true;
  return ReportV1(url_,info);
}

bool LoggerClient::ReportV2(const char* url_,std::list<nl2__UsageRecord>& info) {
  if(!NewURL(url_)) return false;
  if(info.size() <= 0) return true;
  if(client->connect() != 0) {
    odlog(INFO)<<"Failed to connect to "<<*url<<std::endl;
    return false;
  };
  nl2__addRequest req; req.soap_default(&soap);
  for(std::list<nl2__UsageRecord>::iterator i = info.begin();
                                             i!=info.end();++i) {
    req.job.push_back(&(*i));
  };
  int soap_err = SOAP_OK;
  nl2__addResponse r; r.soap_default(&soap);
  if((soap_err=soap_call___nl2__add(&soap,client->SOAP_URL(url->Path().c_str()).c_str(),"add",&req,&r)) !=
SOAP_OK) {
    odlog(INFO)<<"Failed to pass information to database"<<std::endl;
    if(LogTime::Level() > FATAL) soap_print_fault(&soap, stderr);
    client->disconnect();
    return false;;
  } else if(r.result == NULL) {
    odlog(INFO)<<"Record refused."<<std::endl;
  } else if(r.result->Code != nl2__ResultCode__NoError) {
    odlog(INFO)<<"Record refused. Error code: "<<r.result->Code<<std::endl;
    return false;
  };
  return (r.result->Code == nl2__ResultCode__NoError);
}

bool LoggerClient::ReportV1(const char* url_,std::list<nl2__UsageRecord>& info) {
  if(!NewURL(url_)) return false;
  int r = 0;
  for(std::list<nl2__UsageRecord>::iterator i = info.begin();i!=info.end();++i) {
    // connect to server if not yet connected
    if(client->connect() != 0) {
      odlog(INFO)<<"Failed to connect to "<<*url<<std::endl;
      return false;
    };
    // Convert information to version 1
    nl__jobinfo i_;
    i_.start=i->submissiontime?*(i->submissiontime):0;
    i_.end=i->endtime?*(i->endtime):0;
    //i_.cluster=(char*)(i->cluster?i->cluster->c_str():NULL);
	i_.cluster=(char*)(i->cluster.c_str());
    i_.user=(char*)(i->globaluserid.c_str());
    i_.id=(char*)(i->globaljobid.c_str());
    i_.name=(char*)(i->jobname?i->jobname->c_str():NULL);
    i_.failure=(char*)(i->failurestring?i->failurestring->c_str():NULL);
    i_.lrms=(char*)(i->lrms?i->lrms->c_str():NULL);
    i_.queue=(char*)(i->queue?i->queue->c_str():NULL);
    i_.rsl=(char*)(i->jobdescription?i->jobdescription->c_str():NULL);
    i_.ui=(char*)(i->submithost?i->submithost->c_str():NULL);
    i_.usedcpu=i->usedcputime?*(i->usedcputime):0;
    i_.usedmem=i->usedmemory?*(i->usedmemory):0;
    // Send report
    int soap_err = SOAP_OK;
    if((soap_err=soap_call_nl__add(&soap,client->SOAP_URL(url->Path().c_str()).c_str(),"add",&i_,r)) != SOAP_OK) {
      odlog(INFO)<<"Failed to pass information to database"<<std::endl;
      r=1;
      if(LogTime::Level() > FATAL) soap_print_fault(&soap, stderr);
      client->disconnect();
      break;
    } else if(r != 0) {
      odlog(INFO)<<"Record refused. Error code: "<<r<<std::endl;
      break;
    };
  };
  // Do not disconnect
  return (r==0);
}

//bool LoggerClient::Query(const char* url_,const char* q,unsigned long long offset,std::list<nl2__UsageRecord>& info_) 
bool LoggerClient::Query(const char* url_,const char* q,unsigned long long offset,unsigned long long size,std::list<nl2__UsageRecord>& info_) {
  // Try V2, if it fails try V1
  if(QueryV2(url_,q,offset,size,info_)) return true;
  return QueryV1(url_,q,offset,info_);
}

bool LoggerClient::QueryV1(const char* url_,const char* q,unsigned long long offset,std::list<nl2__UsageRecord>& info_) {
  array_jobinfo info;
  if(!NewURL(url_)) return false;
  // connect to server if not yet connected
  if(client->connect() != 0) {
    odlog(INFO)<<"Failed to connect to "<<*url<<std::endl;
    return false;
  };
  // Query server
  int soap_err = SOAP_OK;
  array_jobinfo r;
  if((soap_err=soap_call_nl__get(&soap,client->SOAP_URL(url->Path().c_str()).c_str(),"get",(char*)q,offset,r)) != SOAP_OK) {
    odlog(INFO)<<"Failed to get information from database"<<std::endl;
    if(LogTime::Level() > FATAL) soap_print_fault(&soap, stderr);
    client->disconnect();
    return false;
  };
  // Do not disconnect
  for(int i = 0; i<info.__size_job; i++) {
    nl2__UsageRecord job;
    copy_jobinfo(job,r.job[i],&soap);
    info_.push_back(job);
  };
  return true;
}

bool LoggerClient::QueryV2(const char* url_,const char* q,unsigned long long offset,unsigned long long size,std::list<nl2__UsageRecord>& info_) {
  if(!NewURL(url_)) return false;
  nl2__getRequest req;
  req.soap_default(&soap);
  req.query=soap_new_std__string(&soap,q);
  req.offset=offset;
  req.size=size;
  nl2__getResponse resp;
  resp.soap_default(&soap);
  int soap_err = SOAP_OK;
  if((soap_err=soap_call___nl2__get(&soap,client->SOAP_URL(url->Path().c_str()).c_str(),"get",&req,&resp))
                                                           != SOAP_OK) {
    odlog(INFO)<<"Failed to get information from database"<<std::endl;
    if(LogTime::Level() > FATAL) soap_print_fault(&soap, stderr);
    client->disconnect();
    return false;
  };
  for(std::vector<nl2__UsageRecord*>::iterator i = resp.job.begin();
                                        i!=resp.job.end();++i) {
    if(!*i) continue;
    info_.push_back(**i);
  };
  return true;
}

