#include "../../std.h"
#include "timestamps.h"

static const char* W_names1[7] = {
  "Mon","Tue","Wed","Thu","Fri","Sat","Sun"
};

static const char* W_names2[7] = {
  "Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"
};

static const char* M_names[12] = {
  "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"
};

bool HTTP_Time::set(const char* str) {
  char         W[32];
  unsigned int Y;
  char         M[32];
  unsigned int D;
  unsigned int h;
  unsigned int m;
  unsigned int s;
  unsigned int n;
  char Z[32];

  defined=false;
  if((str == NULL) || ((*str) == 0)) return false;
  // RFC1123
  if(sscanf(str,
       "%31[^ ,], %2u %31s %4u %2u:%2u:%2u %31s",W,&D,M,&Y,&h,&m,&s,Z) == 8) {
    if(strcmp(Z,"GMT") != 0) return false;
    for(n=0;n<7;n++) if(strcmp(W_names1[n],W) == 0) break;
    if(n>=7) return false; if(n==6) { n=0; } else { n--; };
    weekday=n;
  }
  // RFC850
  else if(sscanf(str,
       "%31[^ ,], %2u-%31[^ -]-%2u %2u:%2u:%2u %31s",W,&D,M,&Y,&h,&m,&s,Z) == 8) {
    if(strcmp(Z,"GMT") != 0) return false;
    Y+=1900; if(Y<1980) Y+=100;
    for(n=0;n<7;n++) if(strcmp(W_names2[n],W) == 0) break;
    if(n>=7) return false; if(n==6) { n=0; } else { n--; };
    weekday=n;
  }
  // asctime
  else if(sscanf(str,
       "%31[^ ,], %31s %4u %2u:%2u:%2u %4u",W,M,&D,&h,&m,&s,&Y) == 8) {
    for(n=0;n<7;n++) if(strcmp(W_names1[n],W) == 0) break;
    if(n>=7) return false; if(n==6) { n=0; } else { n--; };
    weekday=n;
  }
  else { return false; };
  year=Y;
  for(n=0;n<12;n++) if(strcmp(M_names[n],M) == 0) break;
  if(n>=12) return false;
  month=n;
  if((D>31) || (D<1)) return false;
  day=D-1;
  if((h>23) || (m>59) || (s>59)) return false;
  hours=h; minutes=m; seconds=s;
  defined=true;
  return true;
}

time_t HTTP_Time::Get(struct tm *tm) const {
  if(!defined) return (time_t)(-1);
  struct tm t;
  t.tm_sec=seconds;
  t.tm_min=minutes;
  t.tm_hour=hours;
  t.tm_mday=day+1;
  t.tm_mon=month;
  t.tm_year=year-1900;
  t.tm_wday=0;
  t.tm_yday=0;
  t.tm_isdst=0;
  time_t tt = timegm(&t);
  if(tm) (*tm)=t;
  return tt;
}

bool HTTP_Time::set(time_t t) {
  defined=false;
  if(t == (time_t)(-1)) return false;
  struct tm tt_;
  struct tm *tt;
  tt=gmtime_r (&t,&tt_);
  if(tt == NULL) return false;
  seconds=tt->tm_sec;
  minutes=tt->tm_min;
  hours=tt->tm_hour;
  day=tt->tm_mday-1;
  month=tt->tm_mon;
  year=tt->tm_year+1900;
  weekday=tt->tm_wday; if(weekday==0) { weekday=6; } else { weekday++; };
  defined=true;
  return true;
}

bool HTTP_Time::set(const struct tm& t) {
  defined=false;
  seconds=t.tm_sec;
  minutes=t.tm_min;
  hours=t.tm_hour;
  day=t.tm_mday-1;
  month=t.tm_mon;
  year=t.tm_year+1900;
  weekday=t.tm_wday; if(weekday==0) { weekday=6; } else { weekday++; };
  defined=true;
  return true;
}

std::string HTTP_Time::Str(void) const {
  if(!defined) return "";
  char buf[256];
  snprintf(buf,256,"%10s, %2u %10s %4u %2u:%2u:%2u GMT",
           W_names1[weekday],day+1,M_names[month],year,hours,minutes,seconds);
  return buf;
}

