//gsoap nj service name: ARCJobTypes
//gsoap nj service namespace: http://www.nordugrid.org/ws/schemas/ARCJobTypes

//gsoap njf service name: ARCJobFactory
//gsoap njf service portType: ARCJobFactoryPortType
//gsoap njf service namespace: http://www.nordugrid.org/ws/schemas/ARCJobFactory
//gsoap njf service documentation: Interface to start new jobs and to query existing jobs
//gsoap njf service method-documentation: create Submit new job
//gsoap njf service method-documentation: query Get list of job matching request
//gsoap njc service name: ARCJobControl
//gsoap njc service portType: ARCJobControlPortType
//gsoap njc service namespace: http://www.nordugrid.org/ws/schemas/ARCJobControl
//gsoap njc service documentation: Interface to control jobs
//gsoap njc service method-documentation: query Get job parameters
//gsoap njc service method-documentation: modify Modify job
//gsoap ncr service name: ARCCredentials
//gsoap ncr service namespace: http://www.nordugrid.org/ws/schemas/ARCCredentials
//gsoap ncr service documentation: Interface to handle credentials delegation
//gsoap ncr service method-documentation: delegationOffer Establish delegation context

#import "stlvector.h"

/* Job Control Service */
class nj__attribute {
 public:
  char* name;
  char* value;
};

class nj__job {
 public:
  int* failure_code;
  char* failure_reason;
  char* state;
  char* id;
  char* url;
  char* delegation;
  char* description;
  std::vector<nj__attribute> attribute;
};

class nj__jobResult {
  int* code;
  char* description;
  nj__job* job;
};

class nj__jobFiles {
 public:
  std::vector<char*> url;
};

// Create new job.
int njf__create(
  std::vector<nj__job> job,
  std::vector<nj__jobResult>& jobResult
);

// Get list of matching jobs
int njf__query(
  std::vector<nj__job> pattern,
  std::vector<nj__job>& job
);

// Serve particular job


// Get info about job
int njc__query(
  nj__job* pattern,
  nj__job& job
);

int njc__queryFiles(
  char* pattern,
  nj__jobFiles& files
);

int njc__queryLog(
  char* type,
  char*& content
);

// Modify job's parameters
int njc__modify(
  nj__job* modification,
  nj__jobResult& job
);

// Delegation
int ncr__delegationOffer(
  const char* intoken,
  const char* &outtoken
); 
