#ifndef __JOBS_CLIENT_H__
#define __JOBS_CLIENT_H__

#include <string>
#include <map>

#include "../client/client.h"
#include <arc/common.h>
#include <arc/jobcontrol.h>
#include <arc/resource.h>

#include "jobs_soapH.h"


class JobHTTPControl : public JobControl {
	public:
		JobHTTPControl();
		~JobHTTPControl();
		operator bool(void);
		bool operator!(void);
		virtual std::string Submit(const URL& url,
                    const std::string& rsl,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
		virtual std::string Submit(const URL& url,
		            const std::string& rsl,
		            std::multimap<std::string,std::string>& files,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
		virtual void Cancel(const std::string& jobid,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
		virtual void Clean(const std::string& jobid,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
		virtual void RenewCreds(const std::string& jobid,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
        virtual void Resume(const std::string& jobid,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
        virtual Job GetJobInfo(const std::string& jobid,
                    int timeout = TIMEOUT,
                    bool disconnectafteruse = true);
        virtual void Get(const std::string& jobid,
                       const std::string& localdir = "",
                       int timeout = TIMEOUT,
                       bool disconnectafteruse = true);
        virtual void Get(const std::string& jobid,
                       const std::string& name,
                       const std::string& localfile = "",
                       int timeout = TIMEOUT,
                       bool disconnectafteruse = true);
        virtual std::list<FileInfo> ListFiles(const std::string& jobid,
                       int timeout = TIMEOUT,
                       bool disconnectafteruse = true);
	private:
		std::string jobid_;
		std::string joburl_;
		URL url_;
		HTTP_ClientSOAP* client_;
		struct soap soap_;
        bool set_connection(const URL& url,int timeout);
        bool set_connection(const std::string& url,std::string& path,int timeout);
};

#endif // __JOBS_CLIENT_H__
