#include <string>
#include <iostream>

#include "../httpsd.h"
#include "../server/service_soap.h"

#include "jobs_soapH.h"

#include "../../gridftp/fileroot.h"

class HTTP_JobControl_Handle;

class HTTP_JobControl: public HTTP_ServiceAdv {
 friend int njf__create(struct soap*,std::vector<nj__job>,std::vector<nj__jobResult>&);
 friend int njf__query(struct soap*,std::vector<nj__job>,std::vector<nj__job>&);
 friend int njc__query(struct soap*,nj__job*,nj__job&);
 friend int njc__modify(struct soap*,nj__job*,nj__jobResult&);
 friend int njc__queryFiles(struct soap*,char*,nj__jobFiles&);
 friend int njc__queryLog(struct soap*,char*,char*&);
 private:
  FilePlugin *jobplugin;
  userspec_t userspec;
  std::string service_url;
  std::string job_id;
  bool job_only;
  bool extract_job_id(void);
  bool create_job(nj__job& jobdef,nj__jobResult& job);
  bool get_job(const std::string& id,nj__job& job);
  bool get_files(const std::string& path,std::vector<char*>& url);
  bool read_info_file(const char* name,std::string& content);
  bool read_info_file(const char* name,const std::string& key,std::string& value);
  bool restart_job(void);
 public:
  HTTP_JobControl(HTTP_Connector *c,const char* uri,HTTP_JobControl_Handle& handle);
  virtual ~HTTP_JobControl(void);
  virtual HTTP_Error get(const char* uri,int &keep_alive);
  virtual HTTP_Error put(const char* uri,int &keep_alive);
  virtual HTTP_Error post(const char* uri,int &keep_alive);
  virtual void soap_methods(void);
};

HTTP_Service* jobs_service_creator(HTTP_Connector& c,const char* uri,void* arg);
bool jobs_service_configurator(std::istream& f,const char* uri,HTTP_Service_Properties &prop);

