#include <openssl/bio.h>


class DelegationReceiver {
 private:
  bool activated_;
  bool delegated_;
  globus_gsi_proxy_handle_t proxy_;
  globus_gsi_cred_handle_t 
  std::string request_;
 public:
  DelegationReceiver(void);
  ~DelegationReceiver(void);
  operator bool(void) { return activated_; };
  bool operator!(void) { return !activated_; };
  const std::string& Request(void);
  bool Response(std::string& resp);
  bool Complete(void);
  bool Store(std::string& fname);
};

class DelegationSender {
 private:
  bool activated_;
  std::string response_;
 public:
  DelegationSender(void);
  ~DelegationSender(void);
  operator bool(void) { return activated_; };
  bool operator!(void) { return !activated_; };
  bool Request(const std::string& req);
  const std::string& Response(void);
};

DelegationReceiver::DelegationReceiver(void) {
  globus_gsi_proxy_handle_attrs_t attr;
  BIO* req_bio;
  activated_=false;
  delegated_=false;
  if(globus_module_activate(GLOBUS_GSI_CREDENTIAL_MODULE) != GLOBUS_SUCCESS) 
    goto exit0;
  if(globus_module_activate(GLOBUS_GSI_PROXY_MODULE) != GLOBUS_SUCCESS) 
    goto exit1;
  if((req_bio=BIO_new(BIO_s_mem())) == NULL)
    goto exit2;
  if(globus_gsi_proxy_handle_attrs_init(&attr) != GLOBUS_SUCCESS) 
    goto exit3;
  if(globus_gsi_proxy_handle_init(&proxy_,&attr) != GLOBUS_SUCCESS)
    goto exit4;
  // Create request
  if(globus_gsi_proxy_create_req(&proxy_,req_bio) == GLOBUS_SUCCESS) {
    char* req = NULL;
    long req_l = BIO_get_mem_data(req_bio,&req);
    if(req_l && req) {
      request_.assign(req,req_l);
      activated_=true;
    };
  };
  if(!activated_) globus_gsi_proxy_handle_destroy(&proxy_);
exit4:
  globus_gsi_proxy_handle_attrs_destroy(&attr);
exit3:
  BIO_free(request_bio);
exit2:
  if(!activated_) globus_module_deactivate(GLOBUS_GSI_PROXY_MODULE);
exit1:
  if(!activated_) globus_module_deactivate(GLOBUS_GSI_CREDENTIAL_MODULE);
exit0:
  return;
}

DelegationReceiver::~DelegationReceiver(void) {
  if(delegated_) {
    globus_gsi_cred_handle_destroy(&cred_);
  };
  if(activated_) {
    globus_gsi_proxy_handle_destroy(&proxy_);
    globus_module_deactivate(GLOBUS_GSI_PROXY_MODULE);
    globus_module_deactivate(GLOBUS_GSI_CREDENTIAL_MODULE);
  };
}

const std::string& DelegationReceiver::Request(void) {
  return request_;
}

bool DelegationReceiver::Response(std::string& resp) {
  if(!activated_) return false;
  BIO* resp_bio = BIO_new_mem_buf(resp.c_str(),resp.length());
  if(resp_bio == NULL) return false;
  if(delegated_) {
    delegated_=false;
    globus_gsi_cred_handle_destroy(&cred_);
  };
  if(globus_gsi_proxy_assemble_cred(proxy_,&cred,resp_bio) != GLOBUS_SUCCESS) {
    BIO_free(resp_bio);
    return false;
  };
  delegated_=true;
  BIO_free(resp_bio);
  return true;
}

bool DelegationReceiver::Complete(void) {
  return delegated_;
}

bool DelegationReceiver::Store(std::string& fname) {
  if(!delegated_) return false;
  return globus_gsi_cred_write_proxy(cred_,(char*)(fname.c_str()) == GLOBUS_SUCCESS;
}


DelegationSender::DelegationSender(void) {
  activated_=false;
  if(globus_module_activate(GLOBUS_GSI_PROXY_MODULE) != GLOBUS_SUCCESS) 
    goto exit1;
  activated_=true;
  if(!activated_) globus_module_deactivate(GLOBUS_GSI_PROXY_MODULE);
exit1:
  return;
}

bool DelegationSender::Request(const std::string& req) {
  if(!activated_) return false;
  bool r = false;
  BIO* resp_bio = BIO_new_mem_buf(resp.c_str(),resp.length());
  if(resp_bio == NULL) goto exit0;
  if(delegated_) {
    delegated_=false;
    globus_gsi_cred_handle_destroy(&cred_);
  };
  globus_gsi_proxy_handle_t handle;
  globus_gsi_proxy_handle_attrs_t attr;
  if(globus_gsi_proxy_handle_attrs_init(&attr) != GLOBUS_SUCCESS) goto exit1;
  if(globus_gsi_proxy_handle_init(&handle,&attr) != GLOBUS_SUCCESS) goto exit2;
  if(globus_gsi_proxy_inquire_req(handle,resp_bio) != GLOBUS_SUCCESS) goto exit3;
  BIO* req_bio = BIO_new(BIO_s_mem());
  if(req_bio == NULL) goto exit3;
  globus_gsi_cred_handle_t issuer_credential = ;

  if(globus_gsi_proxy_sign_req(handle,,req_bio) != GLOBUS_SUCCESS) goto exit4;


exit4:
  BIO_free(req_bio);
exit3:
  globus_gsi_proxy_handle_destroy(&handle);
exit2:
  globus_gsi_proxy_handle_attrs_destroy(&attr);
exit1:
  BIO_free(resp_bio);
exit0:
  return r;
}

