#ifndef __HTTPSD_H__
#define __HTTPSD_H__

#include <globus_io.h>
#include <list>
#include <string>
#include <iostream>

#include "server/connector.h"

typedef enum {
  HTTP_OK = 200,
  HTTP_NOT_IMPLEMENTED = 501,
  HTTP_NOT_ALLOWED = 403,
  HTTP_NOT_FOUND = 404,
  HTTP_ERROR = 500,
  HTTP_FAILURE = -1
} HTTP_Error;

// template for any service accessible through Connector
class HTTP_Service {
 friend class HTTP_Services;
 protected:
  std::string requested_url;
  std::string requested_path;
 public:
  HTTP_Service(void);
  virtual ~HTTP_Service(void);
  virtual HTTP_Error get(const char* uri,int &keep_alive);
  virtual HTTP_Error put(const char* uri,int &keep_alive);
  virtual HTTP_Error post(const char* uri,int &keep_alive);
};

class HTTP_Service_Properties {
 public:
  // whole is subtree is served by this service
  bool subtree;
  // configuration-dependent information passed during configuration
  void* arg;
};

// each service class must have such corresponding functions
typedef HTTP_Service* (*service_creator)(HTTP_Connector& c,const char* uri,void* arg);
typedef bool (*service_configurator)(std::istream& f,const char* uri,HTTP_Service_Properties &prop);

typedef struct {
  const char* name;
  service_creator      creat;
  service_configurator config;
} service_item_t;

// description of service created during configuration one per service
class HTTP_Service_description {
 friend class HTTP_Services;
 private:
  // URL served by this service
  std::string uri;
  service_creator creator;
  HTTP_Service_Properties properties;
 public:
  HTTP_Service_description(const char* u,service_creator c,const HTTP_Service_Properties &prop);
  // return true if 'u' contains url served by this service
  bool match(const char* u,std::string& subpath);
  HTTP_Service* create(HTTP_Connector& c);
};

class HTTP_Service_item {
 public:
  const HTTP_Connector* con;
  // URL for which this service instance was created
  std::string uri;
  bool subtree;
  HTTP_Service* serv;
  HTTP_Service_item(const HTTP_Connector* c,const char* u,bool st,HTTP_Service* s):con(c),uri(u),subtree(st),serv(s) { };
  ~HTTP_Service_item(void) { };
  bool match(const char *u,std::string& subpath);
};

// Holds list of services and manages their creation and destruction
class HTTP_Services {
 private:
  std::list<HTTP_Service_description> desc;
  std::list<HTTP_Service_item> serv;
  pthread_mutex_t lock;
 public:
  HTTP_Services(void);
  ~HTTP_Services(void);
  bool add(const char* u,service_creator c,const HTTP_Service_Properties &prop);
  bool remove(const char* u,service_creator c);
  HTTP_Service* get(HTTP_Connector& c,const char* u);
  void close(const HTTP_Connector& c);
};

#endif /* __HTTPSD_H__ */
